/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dialogs;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.IStiProgressInformation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class StiProgressInformationDialog
extends JDialog
implements IStiProgressInformation {
    private static final long serialVersionUID = 5113821996669853438L;
    private JProgressBar progressBar;
    private JButton cancelButton;
    private JLabel progressLabel;
    private boolean isMarquee = false;
    private boolean allowUseDoEvents = true;
    private Boolean isBreaked = false;
    private boolean allowClose = true;

    public StiProgressInformationDialog(JFrame parent) throws HeadlessException {
        super(parent, "", true);
        this.setSize(300, 135);
        this.buildComponent();
        this.bindEvents();
        this.setSize(300, 135);
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    private void buildComponent() {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.add(Box.createRigidArea(new Dimension(0, 2)));
        JPanel centerPanel1 = new JPanel(new FlowLayout(1));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        Dimension labelPanelDimension = new Dimension(280, 55);
        labelPanel.setMinimumSize(labelPanelDimension);
        labelPanel.setPreferredSize(labelPanelDimension);
        labelPanel.setBorder(BorderFactory.createEtchedBorder());
        labelPanel.setAlignmentX(1.0f);
        this.progressLabel = new JLabel(StiLocalization.getValue((String)"Dialogs", (String)"LoadingReport"));
        this.progressLabel.setAlignmentX(0.5f);
        this.progressLabel.setBorder(BorderFactory.createEmptyBorder(8, 0, 7, 0));
        this.progressBar = new JProgressBar();
        this.progressBar.setMaximumSize(new Dimension(262, 14));
        labelPanel.add(this.progressLabel);
        labelPanel.add(this.progressBar);
        centerPanel1.add(labelPanel);
        JPanel centerPanel2 = new JPanel(new FlowLayout(1));
        this.cancelButton = new JButton(StiLocalization.getHingValue((String)"Buttons", (String)"Cancel"));
        centerPanel2.add(this.cancelButton);
        this.add(centerPanel1);
        this.add(centerPanel2);
    }

    private void bindEvents() {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StiProgressInformationDialog.this.isBreaked = true;
                StiProgressInformationDialog.this.close();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (StiProgressInformationDialog.this.allowClose) {
                    StiProgressInformationDialog.this.isBreaked = true;
                }
            }
        });
    }

    @Override
    public void start(String title) {
        this.start(title, -1);
    }

    @Override
    public void start(String title, int progressMaximum) {
        this.setTitle(title);
        this.progressLabel.setText(title);
        if (progressMaximum != -1) {
            this.progressBar.setMaximum(progressMaximum - 1);
        }
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(-1);
        this.showDialog();
    }

    @Override
    public void updateTitle(String title) {
        this.setTitle(title);
    }

    public void showDialog() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                StiProgressInformationDialog.this.setVisible(true);
            }
        });
        t.start();
    }

    @Override
    public void setProgressBar(int value, int maximum) {
        this.progressBar.setValue(value);
        this.progressBar.setMaximum(maximum);
    }

    @Override
    public void hideProgressBar() {
        this.progressBar.setVisible(false);
    }

    @Override
    public void showProgressBar() {
        this.progressBar.setVisible(true);
    }

    @Override
    public void update(String value) {
        this.update(value, -1);
    }

    @Override
    public void update(String value, int progressValue) {
        this.progressLabel.setText(value);
        if (progressValue != -1) {
            this.progressBar.setValue(progressValue);
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void setAllowClose(boolean allows) {
        this.allowClose = allows;
        if (!allows) {
            this.setDefaultCloseOperation(0);
        } else {
            this.setDefaultCloseOperation(2);
        }
    }

    @Override
    public boolean getIsBreaked() {
        return this.isBreaked;
    }

    @Override
    public void setIsBreaked(boolean value) {
        this.isBreaked = value;
    }

    @Override
    public boolean getIsMarquee() {
        return this.isMarquee;
    }

    @Override
    public void setIsMarquee(boolean value) {
        this.isMarquee = value;
    }

    @Override
    public boolean getAllowUseDoEvents() {
        return this.allowUseDoEvents;
    }

    @Override
    public void setAllowUseDoEvents(boolean value) {
        this.allowUseDoEvents = value;
    }

    @Override
    public boolean getIsVisible() {
        return this.isVisible();
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
    }
}

