/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.crossTab.core.summaries;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.crossTab.core.enums.StiSummaryValues;
import com.stimulsoft.report.crossTab.core.summaries.StiSummaries;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

public class StiAverage
extends StiSummaries {
    public StiAverage(ArrayList<Object> sums, int totalIndex, StiComponentsCollection sumFields) {
        super(sums, totalIndex, sumFields);
    }

    @Override
    public Object calculation() {
        BigDecimal value = BigDecimal.ZERO;
        boolean isNull = true;
        if (this.sums != null && this.sums.size() > 0 && this.IsDateTime(this.sums)) {
            BigDecimal avgValue = new BigDecimal(0);
            long count2 = 0L;
            for (Object val : this.sums) {
                Date dateTimeValue;
                if (val == null || DBNull.Value.equals(val)) continue;
                isNull = false;
                if (val instanceof Date) {
                    dateTimeValue = (Date)val;
                    avgValue = avgValue.add(new BigDecimal(dateTimeValue.getTime()));
                    ++count2;
                }
                if (!(val instanceof Date) || val == null) continue;
                dateTimeValue = (Date)val;
                avgValue = avgValue.add(new BigDecimal(dateTimeValue.getTime()));
                ++count2;
            }
            if (count2 == 0L) {
                return null;
            }
            if (isNull) {
                return "-";
            }
            return new Date(avgValue.divide(new BigDecimal(count2), 20, 4).longValue());
        }
        if (this.sums == null || this.sums.isEmpty()) {
            return 0;
        }
        int countOfValues2 = 0;
        for (Object val : this.sums) {
            if (val == null || DBNull.Value.equals(val)) continue;
            isNull = false;
            BigDecimal valueDecimal = new BigDecimal(0);
            if (this.IsAllowConvertToDecimal(val)) {
                valueDecimal = this.ConvertToDecimal(val);
                value = value.add(valueDecimal);
            }
            if (this.summaryValues == StiSummaryValues.AllValues) {
                ++countOfValues2;
            }
            if (this.summaryValues == StiSummaryValues.SkipNulls && val != null) {
                ++countOfValues2;
            }
            if (this.summaryValues != StiSummaryValues.SkipZerosAndNulls || val == null || valueDecimal.intValue() == 0) continue;
            ++countOfValues2;
        }
        if (countOfValues2 == 0) {
            return 0;
        }
        if (isNull) {
            return "-";
        }
        return value.divide(new BigDecimal(countOfValues2), 4, 4);
    }
}

