/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiBlocklyHelper;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.interfaces.IStiTextBrush;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.events.StiEventsCollection;
import com.stimulsoft.report.events.StiGetZipCodeEvent;
import com.stimulsoft.report.events.StiValueEventArgs;
import com.stimulsoft.report.expressions.StiZipCodeExpression;
import java.awt.image.BufferedImage;

public class StiZipCode
extends StiComponent
implements IStiBorder,
IStiExportImageExtended,
IStiTextBrush,
IStiBrush {
    private static final Object EventGetZipCode = new Object();
    private StiBrush brush = new StiSolidBrush();
    private StiBorder border = new StiBorder();
    private StiBrush textBrush = new StiSolidBrush(StiColor.Black);
    private String codeValue;
    private boolean ratio = true;
    private StiColor foreColor = StiColor.Black;
    private double size = 1.0;
    private double spaceRatio = 4.0;
    private boolean upperMarks = false;

    public StiZipCode() {
        this(StiRectangle.empty());
    }

    public StiZipCode(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(false);
        this.getCode().setValue("1234567890");
        if (StiOptions.Engine.isUseOldZipCodePaintMode()) {
            this.spaceRatio = 1.0;
        }
    }

    @Override
    public BufferedImage getImage(Double zoom) {
        return this.getImage(zoom, StiExportFormat.None);
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        return true;
    }

    @Override
    public boolean getCanShrink() {
        return super.getCanShrink();
    }

    @Override
    public void setCanShrink(boolean value) {
    }

    @Override
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public void setCanGrow(boolean value) {
    }

    @Override
    public Object clone(boolean cloneProperties) {
        StiZipCode zipCode = (StiZipCode)super.clone(cloneProperties);
        zipCode.textBrush = this.textBrush != null ? (StiBrush)this.textBrush.clone() : null;
        return zipCode;
    }

    @Override
    @StiSerializable(shortName="bh")
    public final StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(StiBrush value) {
        this.brush = value;
    }

    @Override
    @StiSerializable(shortName="br")
    public final StiBorder getBorder() {
        return this.border;
    }

    @Override
    public final void setBorder(StiBorder value) {
        this.border = value;
    }

    @Override
    @StiSerializable(shortName="tb")
    public final StiBrush getTextBrush() {
        return this.textBrush;
    }

    @Override
    public final void setTextBrush(StiBrush value) {
        this.textBrush = value;
    }

    public final StiRectangle calculateRect(StiRectangle rect, int count, int index, StiRectangle markRect) {
        double module = 0.0;
        double width = 0.0;
        double border = 0.0;
        double height = 0.0;
        double x = 0.0;
        double y = 0.0;
        if (StiOptions.Engine.isUseOldZipCodePaintMode()) {
            if (!this.ratio) {
                width = 5.0 * rect.width / (double)(6 * count - 1);
                border = width / 5.0;
                height = rect.height;
                x = rect.x + border * (double)index + width * (double)index;
                y = rect.y;
            } else {
                border = rect.height / 10.0;
                height = rect.height;
                width = height / 2.0;
                x = rect.x + border * (double)index + width * (double)index;
                y = rect.y;
            }
            markRect.x = 0.0;
            markRect.y = 0.0;
            markRect.width = 0.0;
            markRect.height = 0.0;
        } else if (!this.ratio) {
            module = rect.height / (double)(12 + (this.upperMarks ? 3 : 0));
            double moduleX = rect.width / ((5.0 + this.spaceRatio) * (double)count - this.spaceRatio + 2.0);
            width = moduleX * 5.0;
            border = moduleX * this.spaceRatio;
            height = module * 10.0;
            x = rect.x + moduleX + (width + border) * (double)index;
            y = rect.y + module * (double)(this.upperMarks ? 4 : 1);
            markRect.x = x - moduleX;
            markRect.y = y - module * 4.0;
            markRect.width = moduleX * 7.0;
            markRect.height = module * 2.0;
        } else {
            module = rect.height / (double)(12 + (this.upperMarks ? 3 : 0));
            height = module * 10.0;
            width = module * 5.0;
            border = module * this.spaceRatio;
            x = rect.x + module + (width + border) * (double)index;
            y = rect.y + module * (double)(this.upperMarks ? 4 : 1);
            markRect.x = x - module;
            markRect.y = y - module * 4.0;
            markRect.width = module * 7.0;
            markRect.height = module * 2.0;
        }
        return new StiRectangle(x, y, width, height);
    }

    @Override
    public StiEventsCollection getEvents() {
        StiEventsCollection events = super.getEvents();
        return events;
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.ZipCode.getValue();
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.Get((String)"Report", (String)"Components");
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiZipCode");
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final String getCodeValue() {
        return this.codeValue;
    }

    public final void setCodeValue(String value) {
        this.codeValue = value;
    }

    @StiSerializable
    public StiZipCodeExpression getCode() {
        return new StiZipCodeExpression(this, "Code");
    }

    public void setCode(StiZipCodeExpression value) {
        if (value != null) {
            value.Set(this, "Code", value.getValue());
        }
    }

    @Override
    public void invokeEvents() {
        super.invokeEvents();
        try {
            if (this.getEvents().get(EventGetZipCode) != null) {
                StiValueEventArgs e = new StiValueEventArgs();
                this.InvokeGetZipCode(this, e);
                if (e.getValue() != null) {
                    this.codeValue = e.getValue().toString();
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
    }

    protected void OnGetZipCode(StiValueEventArgs e) {
    }

    public final void InvokeGetZipCode(StiComponent sender, StiValueEventArgs e) {
        try {
            this.OnGetZipCode(e);
            this.invokeScript(this.getGetZipCodeEvent(), sender, e);
            StiBlocklyHelper.invokeBlockly(this.getReport(), sender, this.getGetZipCodeEvent(), e);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException(ex);
        }
    }

    @StiSerializable
    public final StiGetZipCodeEvent getGetZipCodeEvent() {
        return new StiGetZipCodeEvent(this);
    }

    public final void setGetZipCodeEvent(StiGetZipCodeEvent value) {
        if (value != null) {
            value.Set(this, value.getScript());
        }
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 200L, 32L);
    }

    @StiSerializable
    @StiDefaulValue(value="true")
    public final boolean getRatio() {
        return this.ratio;
    }

    public final void setRatio(boolean value) {
        this.ratio = value;
    }

    @StiSerializable
    public final StiColor getForeColor() {
        return this.foreColor;
    }

    public final void setForeColor(StiColor value) {
        this.foreColor = value;
    }

    @StiSerializable
    @StiDefaulValue(value="1.0")
    public final double getSize() {
        return this.size;
    }

    public final void setSize(double value) {
        this.size = value;
    }

    @StiSerializable
    @StiDefaulValue(value="4.0")
    public double getSpaceRatio() {
        return this.spaceRatio;
    }

    public void setSpaceRatio(double spaceRatio) {
        this.spaceRatio = spaceRatio;
    }

    @StiSerializable
    public boolean getUpperMarks() {
        return this.upperMarks;
    }

    public void setUpperMarks(boolean upperMarks) {
        this.upperMarks = upperMarks;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("CanShrink");
        jObject.RemoveProperty("CanGrow");
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getBrush()));
        jObject.AddPropertyStringNullOfEmpty("Border", StiJsonReportObjectHelper.Serialize.JBorder((StiBorder)this.getBorder()));
        jObject.AddPropertyStringNullOfEmpty("TextBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getTextBrush()));
        jObject.AddPropertyStringNullOfEmpty("CodeValue", this.getCodeValue());
        jObject.AddPropertyJObject("Code", this.getCode().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetZipCodeEvent", this.getGetZipCodeEvent().SaveToJsonObject(mode));
        jObject.AddPropertyBool("Ratio", this.getRatio(), true);
        jObject.AddPropertyStringNullOfEmpty("ForeColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getForeColor(), (StiColorEnum)StiColorEnum.Black));
        jObject.AddPropertyDouble("SpaceRatio", this.getSpaceRatio(), 4.0);
        jObject.AddPropertyBool("UpperMarks", this.getUpperMarks());
        jObject.AddPropertyDouble("Size", this.getSize(), 1.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("Border")) {
                this.border = StiJsonReportObjectHelper.Deserialize.Border((JProperty)property);
                continue;
            }
            if (property.Name.equals("TextBrush")) {
                this.textBrush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("CodeValue")) {
                this.codeValue = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Code")) {
                StiZipCodeExpression _expression = new StiZipCodeExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setCode(_expression);
                continue;
            }
            if (property.Name.equals("GetZipCodeEvent")) {
                StiGetZipCodeEvent _event = new StiGetZipCodeEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetZipCodeEvent(_event);
                continue;
            }
            if (property.Name.equals("Ratio")) {
                this.ratio = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ForeColor")) {
                this.foreColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("SpaceRatio")) {
                this.spaceRatio = property.doubleValue();
                continue;
            }
            if (property.Name.equals("UpperMarks")) {
                this.upperMarks = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("Size")) continue;
            this.size = property.doubleValue();
        }
    }
}

