/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiMargins;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.interfaces.IStiHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiVertAlignment;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.dictionary.databases.StiResourcesCollection;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.units.StiUnit;
import java.awt.image.BufferedImage;
import java.io.IOException;

public abstract class StiView
extends StiComponent
implements IStiHorAlignment,
IStiVertAlignment,
IStiBorder,
IStiExportImageExtended,
IStiBrush {
    private StiHorAlignment horAlignment = StiHorAlignment.Left;
    private StiVertAlignment vertAlignment = StiVertAlignment.Top;
    private StiBorder border = new StiBorder();
    private StiBrush brush = new StiSolidBrush(StiColor.Transparent);
    private boolean smoothing = true;
    private boolean isCachedImage = false;
    private Object objectToDraw = null;
    protected String imageBytesToDraw = null;
    private boolean stretch = false;
    private double multipleFactor = 1.0;
    private boolean aspectRatio = false;
    protected BufferedImage bufferedImage = null;
    private StiMargins margins = new StiMargins();

    public BufferedImage getBufferedImage(StiRectangle rect) {
        return this.getBufferedImage(rect, 1.0);
    }

    public boolean isEmptyBufferedImage() {
        return this.bufferedImage == null;
    }

    public void clearBufferedImage() {
        if (this.bufferedImage != null && this.bufferedImage.getGraphics() != null) {
            this.bufferedImage.getGraphics().dispose();
        }
        this.bufferedImage = null;
    }

    public BufferedImage getBufferedImage(StiRectangle rect, double zoom) {
        if (this.bufferedImage == null && (this.imageBytesToDraw != null || this.existImageToDraw())) {
            try {
                this.bufferedImage = StiImageHelper.decodeImage(this.imageBytesToDraw, rect, zoom);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.bufferedImage;
    }

    public boolean existImageToDraw() {
        return this.getImageBytesToDraw() != null;
    }

    public boolean imageToDrawIsMetafile() {
        return false;
    }

    public StiView() {
        this(StiRectangle.empty());
    }

    public StiView(StiRectangle rect) {
        super(rect);
    }

    @Override
    public Object clone(boolean cloneProperties) {
        StiView view = (StiView)super.clone(cloneProperties);
        view.border = this.border != null ? (StiBorder)this.border.clone() : null;
        view.brush = this.brush != null ? (StiBrush)this.brush.clone() : null;
        view.horAlignment = this.horAlignment;
        view.vertAlignment = this.vertAlignment;
        return view;
    }

    @Override
    @StiSerializable(shortName="ha")
    @StiDefaulValue(value="Left")
    public final StiHorAlignment getHorAlignment() {
        return this.horAlignment;
    }

    @Override
    public final void setHorAlignment(StiHorAlignment value) {
        this.horAlignment = value;
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        return true;
    }

    @Override
    @StiSerializable(shortName="va")
    @StiDefaulValue(value="Top")
    public final StiVertAlignment getVertAlignment() {
        return this.vertAlignment;
    }

    @Override
    public final void setVertAlignment(StiVertAlignment value) {
        this.vertAlignment = value;
    }

    public boolean IsExportAsImage(StiExportFormat format) {
        return true;
    }

    @Override
    @StiSerializable(shortName="br")
    public final StiBorder getBorder() {
        return this.border;
    }

    @Override
    public final void setBorder(StiBorder value) {
        this.border = value;
    }

    @Override
    @StiSerializable(shortName="bh")
    public final StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(StiBrush value) {
        this.brush = value;
    }

    @Override
    public StiSize getActualSize() {
        StiSize newSize = new StiSize(this.getWidth(), this.getHeight());
        if (this.getCanGrow() || this.canShrink) {
            if (this.getImageBytesToDraw() != null) {
                double compHeight;
                StiUnit unit = this.getPage().getUnit();
                double compWidth = unit.ConvertToHInches(this.getWidth());
                BufferedImage img = this.getBufferedImage(new StiRectangle(0.0, 0.0, compWidth, compHeight = unit.ConvertToHInches(this.getHeight())));
                if (img != null) {
                    if (this.getCanGrow()) {
                        if ((double)img.getWidth() * this.getMultipleFactor() > compWidth) {
                            newSize.setWidth(unit.ConvertFromHInches((double)img.getWidth() * this.getMultipleFactor()));
                        }
                        if ((double)img.getHeight() * this.getMultipleFactor() > compHeight) {
                            newSize.setHeight(unit.ConvertFromHInches((double)img.getHeight() * this.getMultipleFactor()));
                        }
                    }
                    if (this.canShrink) {
                        if ((double)img.getWidth() * this.getMultipleFactor() < compWidth) {
                            newSize.setWidth(unit.ConvertFromHInches((double)img.getWidth() * this.getMultipleFactor()));
                        }
                        if ((double)img.getHeight() * this.getMultipleFactor() < compHeight) {
                            newSize.setHeight(unit.ConvertFromHInches((double)img.getHeight() * this.getMultipleFactor()));
                        }
                    }
                }
            } else {
                return StiSize.getEmpty();
            }
        }
        return newSize;
    }

    public final StiSize getRealSize() {
        StiSize newSize = new StiSize(this.getWidth(), this.getHeight());
        if (this.getCanGrow() || this.canShrink) {
            if (this.getImageBytesToDraw() != null) {
                StiUnit unit = this.getPage().getUnit();
                double compWidth = unit.ConvertToHInches(this.getWidth());
                double compHeight = unit.ConvertToHInches(this.getHeight());
                BufferedImage img = this.getBufferedImage(new StiRectangle(0.0, 0.0, compWidth, compHeight));
                if (this.getCanGrow()) {
                    if ((double)img.getWidth() * this.getMultipleFactor() > compWidth) {
                        newSize.setWidth(unit.ConvertFromHInches((double)img.getWidth() * this.getMultipleFactor()));
                    }
                    if ((double)img.getHeight() * this.getMultipleFactor() > compHeight) {
                        newSize.setHeight(unit.ConvertFromHInches((double)img.getHeight() * this.getMultipleFactor()));
                    }
                }
                if ((double)img.getWidth() * this.getMultipleFactor() < compWidth) {
                    newSize.setWidth(unit.ConvertFromHInches((double)img.getWidth() * this.getMultipleFactor()));
                }
                if ((double)img.getHeight() * this.getMultipleFactor() < compHeight) {
                    newSize.setHeight(unit.ConvertFromHInches((double)img.getHeight() * this.getMultipleFactor()));
                }
            } else {
                return StiSize.getEmpty();
            }
        }
        return newSize;
    }

    @StiSerializable
    @StiDefaulValue(value="true")
    public final boolean getSmoothing() {
        return this.smoothing;
    }

    public final void setSmoothing(boolean value) {
        this.smoothing = value;
    }

    public final boolean getIsCachedImage() {
        return this.isCachedImage;
    }

    public final void setIsCachedImage(boolean value) {
        this.isCachedImage = value;
    }

    public final Object getObjectToDraw() {
        return this.objectToDraw;
    }

    public final void setObjectToDraw(Object value) {
        this.objectToDraw = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public String getImageToDraw() {
        return null;
    }

    public void setImageToDraw(String value) {
        this.setImageBytesToDraw(value);
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public String getImageBytesToDraw() {
        StiResourcesCollection resources;
        boolean storeImagesInResources;
        boolean isDocumentSerialize;
        boolean bl = isDocumentSerialize = this.getPage() != null && this.getPage().document != null;
        boolean bl2 = isDocumentSerialize ? (this.getPage().document.getReport() != null ? this.getPage().document.getReport().isStoreImagesInResources() : false) : (storeImagesInResources = this.getReport() != null ? this.getReport().isStoreImagesInResources() : false);
        StiResourcesCollection stiResourcesCollection = isDocumentSerialize ? this.getPage().document.getResources() : (resources = this.getReport() != null && this.getReport().getDictionary() != null ? this.getReport().getDictionary().getResources() : null);
        if (storeImagesInResources) {
            if (isDocumentSerialize) {
                return null;
            }
            byte[] imageBytes = this.getImageFromResource(resources);
            if (imageBytes != null && this.imageBytesToDraw == null) {
                try {
                    this.bufferedImage = StiImageHelper.decodeImage(imageBytes, null);
                    this.imageBytesToDraw = StiImageHelper.imageToBase64(this.bufferedImage, StiImageFormat.Png);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.getIsDesigning()) {
            return this.imageBytesToDraw;
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)this.imageBytesToDraw)) {
            return this.imageBytesToDraw;
        }
        if (this.getGuid() == null) {
            return null;
        }
        return null;
    }

    public void setImageBytesToDraw(String value) {
        if (value != null && value.indexOf(44) > 0) {
            value = value.substring(value.indexOf(44) + 1);
        }
        this.isCachedImage = false;
        this.imageBytesToDraw = value;
        this.bufferedImage = null;
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getStretch() {
        return this.stretch;
    }

    public final void setStretch(boolean value) {
        this.stretch = value;
    }

    @StiSerializable
    @StiDefaulValue(value="1.0")
    public final double getMultipleFactor() {
        return this.multipleFactor;
    }

    public final void setMultipleFactor(double value) {
        this.multipleFactor = value;
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getAspectRatio() {
        return this.aspectRatio;
    }

    public final void setAspectRatio(boolean value) {
        this.aspectRatio = value;
    }

    public abstract String GetImageFromSource();

    protected abstract byte[] getImageFromResource(StiResourcesCollection var1);

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyEnum("HorAlignment", (Enum)this.getHorAlignment(), (Enum)StiHorAlignment.Left);
        jObject.AddPropertyEnum("VertAlignment", (Enum)this.getVertAlignment(), (Enum)StiVertAlignment.Top);
        jObject.AddPropertyStringNullOfEmpty("Border", StiJsonReportObjectHelper.Serialize.JBorder((StiBorder)this.getBorder()));
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getBrush()));
        jObject.AddPropertyBool("Smoothing", this.getSmoothing(), true);
        jObject.AddPropertyBool("Stretch", this.getStretch());
        jObject.AddPropertyDouble("MultipleFactor", this.getMultipleFactor(), 1.0);
        jObject.AddPropertyBool("AspectRatio", this.getAspectRatio());
        if (mode == StiJsonSaveMode.Document) {
            if (this.getReport().isStoreImagesInResources()) {
                byte[] imageBytes = this.getImageFromResource(this.getReport().getDictionary().getResources());
                if (imageBytes == null) {
                    jObject.AddPropertyStringNullOfEmpty("ImageBytesToDraw", this.getImageBytesToDraw());
                }
            } else {
                jObject.AddPropertyStringNullOfEmpty("ImageBytesToDraw", this.getImageBytesToDraw());
            }
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("HorAlignment")) {
                this.horAlignment = StiHorAlignment.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("VertAlignment")) {
                this.vertAlignment = StiVertAlignment.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("Border")) {
                this.border = StiJsonReportObjectHelper.Deserialize.Border((JProperty)property);
                continue;
            }
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("Smoothing")) {
                this.smoothing = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Stretch")) {
                this.stretch = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("MultipleFactor")) {
                this.multipleFactor = property.doubleValue();
                continue;
            }
            if (property.Name.equals("AspectRatio")) {
                this.aspectRatio = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ImageBytesToDraw")) {
                this.setImageBytesToDraw((String)property.Value);
                continue;
            }
            if (!property.Name.equals("ImageToDraw")) continue;
            this.setImageBytesToDraw((String)property.Value);
        }
    }

    @StiSerializable
    public StiMargins getMargins() {
        return this.margins;
    }

    public void setMargins(StiMargins margins) {
        this.margins = margins;
    }
}

