/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiSparklineType;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiDataRelation;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.engine.engineV2.builders.StiSparklineV2Builder;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.painters.StiPainter;
import java.awt.image.BufferedImage;

public class StiSparkline
extends StiComponent
implements IStiExportImageExtended,
IStiDataRelation,
IStiBorder,
IStiBrush {
    public String dataRelationName;
    public StiBrush brush = new StiSolidBrush();
    public StiBorder border = new StiBorder();
    private String valueDataColumn = "";
    public double[] values;
    public StiSparklineType type = StiSparklineType.Area;
    public boolean showHighLowPoints;
    public boolean showFirstLastPoints = true;
    public StiColor positiveColor = StiColor.fromHtml((String)"537eb6");
    public StiColor negativeColor = StiColor.fromHtml((String)"ff0000");

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("CanShrink");
        jObject.RemoveProperty("CanGrow");
        jObject.AddPropertyStringNullOrEmpty("DataRelationName", this.dataRelationName);
        jObject.AddPropertyStringNullOrEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.brush));
        jObject.AddPropertyStringNullOrEmpty("Border", StiJsonReportObjectHelper.Serialize.JBorder((StiBorder)this.border));
        jObject.AddPropertyStringNullOrEmpty("ValueDataColumn", this.valueDataColumn);
        jObject.AddPropertyEnum("Type", (Enum)this.type, (Enum)StiSparklineType.Area);
        jObject.AddPropertyBool("ShowHighLowPoints", this.showHighLowPoints);
        jObject.AddPropertyBool("ShowFirstLastPoints", this.showFirstLastPoints, true);
        jObject.AddPropertyStringNullOrEmpty("PositiveColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.positiveColor, (StiColor)StiColor.fromHtml((String)"537eb6")));
        jObject.AddPropertyStringNullOrEmpty("NegativeColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.negativeColor, (StiColor)StiColor.fromHtml((String)"ff0000")));
        if (mode == StiJsonSaveMode.Document) {
            jObject.AddPropertyStringNullOrEmpty("ValuesContainer", this.getValuesContainer());
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("DataRelationName")) {
                this.dataRelationName = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("Border")) {
                this.border = StiJsonReportObjectHelper.Deserialize.Border((JProperty)property);
                continue;
            }
            if (property.Name.equals("ValueDataColumn")) {
                this.valueDataColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Type")) {
                this.type = StiSparklineType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("ShowHighLowPoints")) {
                this.showHighLowPoints = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ShowFirstLastPoints")) {
                this.showFirstLastPoints = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("PositiveColor")) {
                this.positiveColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("NegativeColor")) {
                this.negativeColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (!property.Name.equals("ValuesContainer")) continue;
            this.setValuesContainer((String)property.Value);
        }
    }

    @Override
    public StiDataRelation getDataRelation() {
        if (this.getPage() == null || this.getReport() != null && this.getReport().getDictionary() != null && this.getReport().getDictionary().getRelations() == null || this.dataRelationName == null || this.dataRelationName.length() == 0) {
            return null;
        }
        return this.getReport() != null && this.getReport().getDictionary() != null && this.getReport().getDictionary().getRelations() != null ? this.getReport().getDictionary().getRelations().get(this.dataRelationName) : null;
    }

    @Override
    @StiSerializable
    public String getDataRelationName() {
        return this.dataRelationName;
    }

    @Override
    public void setDataRelationName(String dataRelationName) {
        this.dataRelationName = dataRelationName;
    }

    public BufferedImage getImage(double zoom) {
        return this.getImage(zoom, StiExportFormat.None);
    }

    public BufferedImage getImage(double zoom, StiExportFormat format) {
        StiPainter painter = StiPainter.getPainter(this);
        return painter.getImage(this, zoom, format);
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        return true;
    }

    @Override
    public Object clone(boolean cloneProperties) {
        StiSparkline sparkline = (StiSparkline)super.clone(cloneProperties);
        sparkline.border = this.border != null ? (StiBorder)this.border.clone() : null;
        sparkline.brush = this.brush != null ? (StiBrush)this.brush.clone() : null;
        return sparkline;
    }

    @Override
    @StiSerializable
    public StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public void setBrush(StiBrush brush) {
        this.brush = brush;
    }

    public boolean shouldSerializeBorder() {
        return this.border == null || !this.border.isDefault();
    }

    @Override
    @StiSerializable
    public StiBorder getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(StiBorder border) {
        this.border = border;
    }

    @Override
    public boolean getCanShrink() {
        return super.getCanShrink();
    }

    @Override
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public int getPriority() {
        return StiComponentPriority.Component.getValue();
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.Get((String)"Report", (String)"Components");
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 100L, 30L);
    }

    public StiComponentType getStiComponentType() {
        return StiComponentType.Simple;
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.Sparkline.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiSparkline");
    }

    public StiComponent createNew() {
        return new StiSparkline();
    }

    public double[] fetchValues() {
        if (this.values == null && this.isDesigning()) {
            double[] tempValues = StiSparklineV2Builder.getValuesFromValueDataColumn(this, 10);
            this.values = tempValues != null && tempValues.length > 0 ? tempValues : new double[]{1.0, 2.0, 3.0, 6.0, 3.0, 2.0, 7.0, 4.0, 2.0, -3.0, -5.0};
        }
        return this.values;
    }

    public StiDataSource getDataSource() {
        return StiDataColumn.GetDataSourceFromDataColumn(this.getReport().getDictionary(), this.valueDataColumn);
    }

    public void setValueDataColumn(String value) {
        if (this.valueDataColumn != value) {
            this.valueDataColumn = value;
            this.values = null;
        }
    }

    @StiSerializable
    public String getValueDataColumn() {
        return this.valueDataColumn;
    }

    @StiSerializable
    public String getValuesContainer() {
        if (this.values == null) {
            return null;
        }
        String result = "";
        if (this.values.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (double s : this.values) {
                sb.append(s).append(",");
            }
            result = sb.deleteCharAt(sb.length() - 1).toString();
        }
        return result;
    }

    public void setValuesContainer(String value) {
        if (value == null || value.trim().length() == 0) {
            this.values = null;
        } else {
            String[] strs = value.split(";");
            this.values = new double[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                try {
                    this.values[i] = Double.parseDouble(strs[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @StiSerializable
    public StiSparklineType getType() {
        return this.type;
    }

    public void setType(StiSparklineType type) {
        this.type = type;
    }

    @StiSerializable
    public boolean isShowHighLowPoints() {
        return this.showHighLowPoints;
    }

    public void setShowHighLowPoints(boolean showHighLowPoints) {
        this.showHighLowPoints = showHighLowPoints;
    }

    @StiSerializable
    public boolean isShowFirstLastPoints() {
        return this.showFirstLastPoints;
    }

    public void setShowFirstLastPoints(boolean showFirstLastPoints) {
        this.showFirstLastPoints = showFirstLastPoints;
    }

    @StiSerializable
    public StiColor getPositiveColor() {
        return this.positiveColor;
    }

    public void setPositiveColor(StiColor positiveColor) {
        this.positiveColor = positiveColor;
    }

    private boolean shouldSerializePositiveColor() {
        return this.positiveColor != StiColor.fromHtml((String)"537eb6");
    }

    @StiSerializable
    public StiColor getNegativeColor() {
        return this.negativeColor;
    }

    public void setNegativeColor(StiColor negativeColor) {
        this.negativeColor = negativeColor;
    }

    private boolean shouldSerializeNegativeColor() {
        return this.negativeColor != StiColor.fromHtml((String)"ff0000");
    }

    public StiSparkline() {
        this(StiRectangle.empty());
    }

    public StiSparkline(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(false);
    }

    @Override
    public boolean existDataRelation() {
        return this.getDataRelation() != null;
    }
}

