/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.simplecomponents.StiRectanglePrimitive;

public class StiRoundedRectanglePrimitive
extends StiRectanglePrimitive {
    private float round = new Float(0.2).floatValue();

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.RoundedRectanglePrimitive.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.get((String)"Components", (String)"StiRoundedRectanglePrimitive");
    }

    @StiSerializable
    public float getRound() {
        return this.round;
    }

    public void setRound(float value) {
        if (value > 0.0f && (double)value <= 0.5) {
            this.round = value;
        }
    }

    public StiRoundedRectanglePrimitive() {
        this(StiRectangle.empty());
    }

    public StiRoundedRectanglePrimitive(StiRectangle rect) {
        super(rect);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Round", (double)this.getRound(), (double)0.2f);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (!property.Name.equals("Round")) continue;
            this.round = property.floatValue().floatValue();
        }
    }
}

