/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.simplecomponents.StiPrimitive;

public abstract class StiLinePrimitive
extends StiPrimitive {
    private StiPenStyle style = StiPenStyle.Solid;
    private StiColor color = StiColor.Black;
    private double size = 1.0;

    public StiLinePrimitive() {
        this(StiRectangle.empty());
    }

    public StiLinePrimitive(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
    }

    @Override
    public boolean getInvalidateOnMouseOver() {
        return true;
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 60L, 60L);
    }

    @StiDefaulValue(value="Solid")
    @StiSerializable
    public final StiPenStyle getStyle() {
        return this.style;
    }

    public final void setStyle(StiPenStyle value) {
        this.style = value;
    }

    @StiSerializable
    public StiColor getColor() {
        return this.color;
    }

    public void setColor(StiColor value) {
        this.color = value;
    }

    @StiDefaulValue(value="1.0")
    @StiSerializable
    public final double getSize() {
        return this.size;
    }

    public final void setSize(double value) {
        this.size = value;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyEnum("Style", (Enum)this.getStyle(), (Enum)StiPenStyle.Solid);
        jObject.AddPropertyStringNullOfEmpty("Color", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getColor(), (StiColorEnum)StiColorEnum.Black));
        jObject.AddPropertyFloat("Size", this.getSize(), 1.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Style")) {
                this.style = StiPenStyle.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("Color")) {
                this.color = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (!property.Name.equals("Size")) continue;
            this.size = property.floatValue().floatValue();
        }
    }
}

