/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiDownloadCache;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.Base64;
import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiBlocklyHelper;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReportParser;
import com.stimulsoft.report.StiScriptHelper;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiMargins;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiImageProcessingDuplicatesType;
import com.stimulsoft.report.components.enums.StiImageRotation;
import com.stimulsoft.report.components.interfaces.IStiBreakable;
import com.stimulsoft.report.components.interfaces.IStiGlobalizedName;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiView;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.databases.StiResourcesCollection;
import com.stimulsoft.report.events.StiEvent;
import com.stimulsoft.report.events.StiGetImageDataEvent;
import com.stimulsoft.report.events.StiGetImageDataEventArgs;
import com.stimulsoft.report.events.StiGetImageURLEvent;
import com.stimulsoft.report.events.StiValueEventArgs;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.expressions.StiImageDataExpression;
import com.stimulsoft.report.expressions.StiImageURLExpression;
import com.stimulsoft.report.expressions.StiUnifiedExpression;
import com.stimulsoft.report.helpers.StiExpressionHelper;
import com.stimulsoft.report.helpers.StiFontIcons;
import com.stimulsoft.report.helpers.StiHyperlinkProcessor;
import com.stimulsoft.report.units.StiUnit;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import java.util.logging.Logger;

public class StiImage
extends StiView
implements IStiBreakable,
IStiGlobalizedName {
    private static final Logger LOGGER = Logger.getLogger("com.stimulsoft.report.components.simplecomponents.StiImage");
    private String globalizedName = "";
    protected static Object PropertyCanBreak = new Object();
    private Object imageURLValue;
    private static final Object EventGetImageURL = new Object();
    private static final Object EventGetImageData = new Object();
    protected static Object PropertyProcessingDuplicates = new Object();
    private StiImageRotation imageRotation = StiImageRotation.None;
    private String imageBytes;
    private String file = "";
    private String dataColumn = "";
    private StiFontIcons icon;
    private StiColor iconColor = StiColor.get((String)"4472C4");

    public StiImage() {
        this(StiRectangle.empty());
    }

    public StiImage(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
    }

    public StiImage(String image) {
        this.imageBytesToDraw = image;
        this.imageBytes = image;
    }

    public StiImage(byte[] bytes) {
        this.imageBytes = this.imageBytesToDraw = new String(bytes);
    }

    public BufferedImage getBufferedImage() {
        if (this.page != null) {
            StiUnit unit = this.page.getUnit();
            return this.getBufferedImage(new StiRectangle(unit.ConvertToHInches(this.getLeft()), unit.ConvertToHInches(this.getTop()), unit.ConvertToHInches(this.getWidth()), unit.ConvertToHInches(this.getHeight())));
        }
        return this.getBufferedImage(null);
    }

    @Override
    public BufferedImage getBufferedImage(StiRectangle rect) {
        return this.getBufferedImage(rect, 1.0);
    }

    @Override
    public BufferedImage getBufferedImage(StiRectangle rect, double zoom) {
        if (this.bufferedImage == null && (this.imageBytesToDraw != null || this.existImageToDraw())) {
            super.getBufferedImage(rect, zoom);
            if (this.imageRotation != StiImageRotation.None) {
                this.bufferedImage = this.rotateImage(this.bufferedImage);
            }
        }
        return this.bufferedImage;
    }

    public BufferedImage rotateImage(BufferedImage image) {
        if (image == null) {
            return null;
        }
        BufferedImage newImage = null;
        AffineTransform at = new AffineTransform();
        if (this.imageRotation.equals((Object)StiImageRotation.Rotate180)) {
            newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            at.translate(image.getWidth(), image.getHeight());
            at.scale(-1.0, -1.0);
            ((Graphics2D)newImage.getGraphics()).drawImage(image, at, null);
        } else if (this.imageRotation.equals((Object)StiImageRotation.Rotate90CW)) {
            newImage = new BufferedImage(image.getHeight(), image.getWidth(), 2);
            at.translate(image.getHeight(), 0.0);
            at.rotate(Math.toRadians(90.0));
        } else if (this.imageRotation.equals((Object)StiImageRotation.Rotate90CCW)) {
            newImage = new BufferedImage(image.getHeight(), image.getWidth(), 2);
            at.translate(0.0, image.getWidth());
            at.rotate(Math.toRadians(-90.0));
        } else if (this.imageRotation.equals((Object)StiImageRotation.FlipHorizontal)) {
            newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            at.scale(-1.0, 1.0);
            at.translate(-image.getWidth(), 0.0);
        } else if (this.imageRotation.equals((Object)StiImageRotation.FlipVertical)) {
            newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            at.scale(1.0, -1.0);
            at.translate(0.0, -image.getHeight());
        }
        newImage.createGraphics().drawImage(image, at, null);
        return newImage;
    }

    public StiRectangle convertImageMargins(StiRectangle rect, boolean convert) {
        StiMargins margins = this.getMargins();
        if (margins.isEmpty()) {
            return rect;
        }
        double zoom = convert ? this.page.getZoom() : 1.0;
        double marginsLeft = margins.getLeft();
        double marginsRight = margins.getRight();
        double marginsTop = margins.getTop();
        double marginsBottom = margins.getBottom();
        if (marginsLeft != 0.0) {
            rect.x += marginsLeft * zoom;
            rect.width -= marginsLeft * zoom;
        }
        if (marginsTop != 0.0) {
            rect.y += marginsTop * zoom;
            rect.height -= marginsTop * zoom;
        }
        if (marginsRight != 0.0) {
            rect.width -= marginsRight * zoom;
        }
        if (marginsBottom != 0.0) {
            rect.height -= marginsBottom * zoom;
        }
        return rect;
    }

    @Override
    @StiDefaulValue(value="")
    @StiSerializable
    public final String getGlobalizedName() {
        return this.globalizedName;
    }

    @Override
    public final void setGlobalizedName(String value) {
        this.globalizedName = value;
    }

    protected String getImageFromUrl() throws UnsupportedEncodingException, FileNotFoundException, IOException {
        String url;
        String string = url = this.getImageURLValue() instanceof String ? (String)this.getImageURLValue() : null;
        if (StiValidationUtil.isNotNullOrEmpty((String)url)) {
            byte[] bytes = null;
            String resourceName = StiHyperlinkProcessor.getResourceNameFromHyperlink(url);
            if (resourceName != null) {
                return Base64.encode((byte[])StiHyperlinkProcessor.getBytes(this.getReport(), url));
            }
            String variableName = StiHyperlinkProcessor.getVariableNameFromHyperlink(url);
            if (bytes == null) {
                bytes = StiHyperlinkProcessor.getBytes(this.getReport(), url);
            }
            if (bytes == null) {
                bytes = StiDownloadCache.get((String)url);
            }
            if (bytes != null) {
                BufferedImage bi = StiImageHelper.decodeImage(bytes, this.getPaintRectangle());
                return StiImageHelper.imageToBase64(bi, StiImageFormat.Png);
            }
            LOGGER.warning("Unable to access image with URL: " + url);
        }
        return null;
    }

    @Override
    protected byte[] getImageFromResource(StiResourcesCollection resources) {
        String url = this.isDesigning() ? StiReportParser.parse(this.getImageURL().getValue(), this, true, null, true, false) : (String)this.getImageURLValue();
        try {
            StiResource resource = StiHyperlinkProcessor.getResourceByHyperlink(resources, url);
            return resource != null ? resource.getContent() : null;
        }
        catch (Exception ex) {
            if (this.getIsDesigning()) {
                return new byte[0];
            }
            return null;
        }
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getCanBreak() {
        return this.properties.getBool(PropertyCanBreak, false);
    }

    @Override
    public void setCanBreak(boolean value) {
        this.properties.setBool(PropertyCanBreak, value, false);
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.Image.getValue();
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.Get((String)"Report", (String)"Components");
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiImage");
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 100L, 100L);
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final Object getImageURLValue() {
        return this.imageURLValue;
    }

    public final void setImageURLValue(Object value) {
        if (!Objects.equals(this.imageURLValue, value)) {
            this.imageURLValue = value;
            if (StiValidationUtil.isNullOrEmpty((String)this.getImageBytes()) && (this.getReport() != null && this.getReport().getIsRendering() || this.getReport() == null && !StiHyperlinkProcessor.isResourceHyperlink(value != null ? value.toString() : null)) && value != null) {
                try {
                    this.setImageBytesToDraw(this.getImageFromUrl());
                }
                catch (Exception ex) {
                    if (this.getReport() != null) {
                        String.format(StiValidationUtil.isNotNullOrEmpty((String)ex.getMessage()) ? ex.getMessage() : ex.getStackTrace()[0].toString(), new Object[0]);
                    }
                    ex.printStackTrace();
                }
            }
        }
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiImageURLExpression getImageURL() {
        return new StiImageURLExpression(this, "ImageURL");
    }

    public void setImageURL(StiImageURLExpression value) {
        if (value != null) {
            value.Set(this, "ImageURL", value.getValue());
        }
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiImageDataExpression getImageData() {
        return new StiImageDataExpression(this, "ImageData");
    }

    public void setImageData(StiImageDataExpression value) {
        if (value != null) {
            value.Set(this, "ImageData", value.getValue());
        }
    }

    @Override
    public void invokeEvents() {
        try {
            super.invokeEvents();
            if (this.getImageURLValue() == null || this.getImageURLValue() instanceof String && StiValidationUtil.isNullOrEmpty((String)((String)this.getImageURLValue()))) {
                StiValueEventArgs e = new StiValueEventArgs();
                this.invokeGetImageURL(this, e);
                this.setImageURLValue(e.getValue());
            }
            if (!StiValidationUtil.isNullOrEmpty((String)this.getImageData().getValue())) {
                StiGetImageDataEventArgs ee = new StiGetImageDataEventArgs();
                this.invokeGetImageData(this, ee);
                if (ee.getValue() != null) {
                    this.putImage(ee.getValue());
                }
            }
        }
        catch (Exception e1) {
            if (this.getReport() != null) {
                String.format(StiValidationUtil.isNotNullOrEmpty((String)e1.getMessage()) ? e1.getMessage() : e1.getStackTrace()[0].toString(), new Object[0]);
            }
            e1.printStackTrace();
        }
    }

    public void invokeGetImageData(Object sender, StiGetImageDataEventArgs e) {
        try {
            Object parserResult = StiScriptHelper.parseTextValue(this.getImageData().getValue(), this);
            if (parserResult instanceof BufferedImage) {
                e.setValue(StiImageHelper.imageToBase64((BufferedImage)parserResult, StiImageFormat.Png));
            } else if (parserResult != null && parserResult instanceof String) {
                e.setValue((String)parserResult);
            }
            this.invokeScript(this.getGetImageDataEvent(), sender, e);
            StiBlocklyHelper.invokeBlockly(this.getReport(), sender, this.getGetImageDataEvent(), e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void OnGetImageURL(StiValueEventArgs e) {
    }

    public void invokeGetImageURL(Object sender, StiValueEventArgs e) {
        block3: {
            try {
                Object parserResult = StiScriptHelper.parseTextValue(this.getImageURL().getValue(), this);
                if (parserResult != null) {
                    e.setValue(parserResult.toString());
                }
                this.invokeScript(this.getGetImageURLEvent(), sender, e);
                StiBlocklyHelper.invokeBlockly(this.getReport(), sender, this.getGetImageURLEvent(), e);
            }
            catch (Exception e1) {
                if (StiOptions.Engine.logLevel < 10) break block3;
                e1.printStackTrace();
            }
        }
    }

    @StiSerializable
    public StiGetImageURLEvent getGetImageURLEvent() {
        return new StiGetImageURLEvent(this);
    }

    public void setGetImageURLEvent(StiGetImageURLEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnGetImageData(StiGetImageDataEventArgs e) {
    }

    @StiSerializable
    public StiGetImageDataEvent getGetImageDataEvent() {
        return new StiGetImageDataEvent(this);
    }

    public void setGetImageDataEvent(StiGetImageDataEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @StiDefaulValue(value="None")
    @StiSerializable
    public StiImageProcessingDuplicatesType getProcessingDuplicates() {
        return (StiImageProcessingDuplicatesType)((Object)this.properties.get(PropertyProcessingDuplicates, (Object)StiImageProcessingDuplicatesType.None));
    }

    public void setProcessingDuplicates(StiImageProcessingDuplicatesType value) {
        this.properties.set(PropertyProcessingDuplicates, (Object)value, (Object)StiImageProcessingDuplicatesType.None);
    }

    @StiDefaulValue(value="None")
    @StiSerializable
    public final StiImageRotation getImageRotation() {
        return this.imageRotation;
    }

    public final void setImageRotation(StiImageRotation value) {
        this.imageRotation = value;
        this.bufferedImage = null;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public final String getImage() {
        return null;
    }

    public final void setImage(String value) {
        this.setImageBytes(value);
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public final String getImageBytes() {
        return this.imageBytes;
    }

    public final void setImageBytes(String value) {
        if (StiValidationUtil.isNullOrEmpty((String)value)) {
            value = null;
        }
        if (value != null && value.indexOf(44) > 0) {
            value = value.substring(value.indexOf(44) + 1);
        }
        this.imageBytes = value;
        this.setImageBytesToDraw(this.imageBytes);
    }

    public void putImage(byte[] image) throws UnsupportedEncodingException {
        this.setImageBytes(new String(image, "UTF-8"));
    }

    public void putImage(String image) {
        this.setImageBytes(image);
    }

    public void resetImage() {
        this.setImageBytes(null);
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public final String getFile() {
        return this.file;
    }

    @Override
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public String getImageBytesToDraw() {
        String img = super.getImageBytesToDraw();
        if (img == null && StiValidationUtil.isNotNullOrEmpty((String)this.file)) {
            this.setImageBytesToDraw(this.getImageFromFile());
            return super.getImageBytesToDraw();
        }
        return img;
    }

    public final void setFile(String value) {
        if (!this.file.equals(value)) {
            this.file = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getImageFromFile() {
        if (StiValidationUtil.isNotNullOrEmpty((String)this.file)) {
            String parsedFile = StiExpressionHelper.parseText(this.getPage(), this.file);
            File tempFile = new File(parsedFile);
            FileInputStream fis = null;
            if (tempFile.exists()) {
                try {
                    fis = new FileInputStream(parsedFile);
                    BufferedImage bi = StiImageHelper.decodeImage(StiIOUtil.toByteArray((InputStream)fis), this.getPaintRectangle());
                    String string = StiImageHelper.imageToBase64(bi, StiImageFormat.Png);
                    return string;
                }
                catch (Exception ex) {
                    if (this.getReport() != null) {
                        String.format(String.format("Image can't be loaded from file (%s) '%s' in image component %s!", parsedFile, this.file, this.getName()), new Object[0]);
                    }
                    System.out.println(String.format("Image can't be loaded from file (%s) '%s' in image component %s!", parsedFile, this.file, this.getName()));
                    ex.printStackTrace();
                }
                finally {
                    block16: {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (Exception e) {
                                if (StiOptions.Engine.logLevel < 10) break block16;
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public final String getDataColumn() {
        return this.dataColumn;
    }

    public final void setDataColumn(String value) {
        this.dataColumn = value;
    }

    @Override
    public boolean Break(StiComponent dividedComponent, double devideFactor, StiRefObject<Double> divideLine, StiRefObject<Boolean> haveBreaked) {
        divideLine.argvalue = 0.0;
        boolean result = true;
        if (this.getImageBytesToDraw() != null) {
            // empty if block
        }
        return result;
    }

    @Override
    public String GetImageFromSource() {
        if (StiValidationUtil.isNotEmpty((String)this.getDataColumn())) {
            return this.getImageFromDataColumn();
        }
        return this.imageBytes;
    }

    protected String getImageFromDataColumn() {
        Object imageObject = StiDataColumn.GetDataFromDataColumn(this.getReport().dictionary, this.getDataColumn());
        StiImage image = StiImageHelper.getImageFromObject(imageObject);
        return image != null ? image.getImageBytes() : null;
    }

    public void setImage(StiImage image) {
        if (image == null) {
            this.setImageBytesToDraw(null);
            this.imageBytes = null;
        } else {
            this.setImageBytesToDraw(image.getImageBytes());
            this.imageBytes = image.getImageBytes();
        }
    }

    @StiSerializable
    public StiFontIcons getIcon() {
        return this.icon;
    }

    public void setIcon(StiFontIcons icon) {
        if (icon == null) {
            this.setImageBytesToDraw(null);
            this.imageBytes = null;
        } else {
            this.icon = icon;
            this.setImageBytesToDraw(StiBase64EncoderUtil.encode((String)("icon;" + (Object)((Object)icon) + ";" + this.iconColor.serializeString())));
        }
    }

    @StiSerializable
    public StiColor getIconColor() {
        return this.iconColor;
    }

    public void setIconColor(StiColor iconColor) {
        this.iconColor = iconColor;
        this.setIcon(this.icon);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("GlobalizedName", this.getGlobalizedName());
        jObject.AddPropertyBool("CanBreak", this.getCanBreak());
        jObject.AddPropertyJObject("GetImageURLEvent", this.getGetImageURLEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetImageDataEvent", this.getGetImageDataEvent().SaveToJsonObject(mode));
        jObject.AddPropertyEnum("ProcessingDuplicates", (Enum)this.getProcessingDuplicates(), (Enum)StiImageProcessingDuplicatesType.None);
        jObject.AddPropertyEnum("ImageRotation", (Enum)this.getImageRotation(), (Enum)StiImageRotation.None);
        jObject.AddPropertyStringNullOfEmpty("File", this.getFile());
        jObject.AddPropertyStringNullOfEmpty("DataColumn", this.getDataColumn());
        if (this.icon != null) {
            jObject.AddPropertyEnum("Icon", (Enum)this.icon);
        }
        jObject.AddPropertyStringNullOfEmpty("IconColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.iconColor, (StiColor)StiColor.fromArgb((int)68, (int)114, (int)196)));
        if (mode == StiJsonSaveMode.Document) {
            jObject.AddPropertyStringNullOfEmpty("ImageURLValue", (String)this.getImageURLValue());
        } else {
            jObject.AddPropertyJObject("ImageURL", this.getImageURL().SaveToJsonObject(mode));
            jObject.AddPropertyJObject("ImageData", this.getImageData().SaveToJsonObject(mode));
            jObject.put("ImageBytes", (Object)this.getImageBytes());
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            StiEvent _event;
            StiUnifiedExpression _expression;
            if (property.Name.equals("GlobalizedName")) {
                this.globalizedName = (String)property.Value;
                continue;
            }
            if (property.Name.equals("CanBreak")) {
                this.setCanBreak((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("ImageURLValue")) {
                this.imageURLValue = property.Value;
                continue;
            }
            if (property.Name.equals("ImageURL")) {
                _expression = new StiImageURLExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setImageURL((StiImageURLExpression)_expression);
                continue;
            }
            if (property.Name.equals("ImageData")) {
                _expression = new StiImageDataExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setImageData((StiImageDataExpression)_expression);
                continue;
            }
            if (property.Name.equals("GetImageURLEvent")) {
                _event = new StiGetImageURLEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetImageURLEvent((StiGetImageURLEvent)_event);
                continue;
            }
            if (property.Name.equals("GetImageDataEvent")) {
                _event = new StiGetImageDataEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetImageDataEvent((StiGetImageDataEvent)_event);
                continue;
            }
            if (property.Name.equals("ProcessingDuplicates")) {
                this.setProcessingDuplicates(StiImageProcessingDuplicatesType.valueOf((String)property.Value));
                continue;
            }
            if (property.Name.equals("ImageRotation")) {
                this.setImageRotation(StiImageRotation.valueOf((String)property.Value));
                continue;
            }
            if (property.Name.equals("Image")) {
                this.setImageBytes((String)property.Value);
                continue;
            }
            if (property.Name.equals("ImageBytes")) {
                this.setImageBytes((String)property.Value);
                continue;
            }
            if (property.Name.equals("File")) {
                this.file = (String)property.Value;
                continue;
            }
            if (property.Name.equals("DataColumn")) {
                this.dataColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Icon")) {
                this.setIcon(StiFontIcons.valueOf((String)property.Value));
                continue;
            }
            if (!property.Name.equals("IconColor")) continue;
            this.setIconColor(StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value)));
        }
    }
}

