/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.simplecomponents.StiEndPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiStartPointPrimitive;

public abstract class StiCrossLinePrimitive
extends StiLinePrimitive {
    public StiStartPointPrimitive StoredStartPoint;
    public StiEndPointPrimitive StoredEndPoint;

    public StiCrossLinePrimitive() {
        this(StiRectangle.empty());
    }

    public StiCrossLinePrimitive(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
        this.NewGuid();
    }

    @Override
    public void OnRemoveComponent() {
        StiEndPointPrimitive endPoint;
        StiStartPointPrimitive startPoint = this.getStartPoint();
        if (startPoint != null && startPoint.getParent() != null && startPoint.getParent().getComponents().contains(startPoint)) {
            startPoint.setReferenceToGuid(null);
            startPoint.getParent().getComponents().remove(startPoint);
        }
        if ((endPoint = this.getEndPoint()) != null && endPoint.getParent() != null && endPoint.getParent().getComponents().contains(endPoint)) {
            endPoint.setReferenceToGuid(null);
            endPoint.getParent().getComponents().remove(endPoint);
        }
    }

    @Override
    public boolean canContainIn(StiComponent component) {
        return component instanceof StiPage;
    }

    @Override
    public boolean getLinked() {
        return super.getLinked();
    }

    @Override
    public void setLinked(boolean value) {
        StiEndPointPrimitive endPoint;
        super.setLinked(value);
        StiStartPointPrimitive startPoint = this.getStartPoint();
        if (startPoint != null) {
            startPoint.setLinked(value);
        }
        if ((endPoint = this.getEndPoint()) != null) {
            endPoint.setLinked(value);
        }
    }

    @Override
    public double getLeft() {
        StiStartPointPrimitive startPoint = this.getStartPoint();
        if (startPoint == null) {
            return super.getLeft();
        }
        StiPoint pos = new StiPoint(startPoint.getLeft(), startPoint.getTop());
        return (double)Math.round(startPoint.ComponentToPage(pos).getX() * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    @Override
    public void setLeft(double value) {
        StiStartPointPrimitive startPoint = this.getStartPoint();
        if (startPoint == null) {
            super.setLeft(value);
        } else {
            StiPoint pos = new StiPoint(value, 0.0);
            pos = startPoint.PageToComponent(pos);
            startPoint.setLeft(pos.getX());
        }
    }

    @Override
    public double getTop() {
        StiStartPointPrimitive startPoint = this.getStartPoint();
        if (startPoint == null) {
            return super.getTop();
        }
        StiPoint pos = new StiPoint(startPoint.getLeft(), startPoint.getTop());
        return (double)Math.round(startPoint.ComponentToPage(pos).getY() * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    @Override
    public void setTop(double value) {
        StiStartPointPrimitive startPoint = this.getStartPoint();
        if (startPoint == null) {
            super.setTop(value);
        } else {
            StiPoint pos = new StiPoint(0.0, value);
            pos = startPoint.PageToComponent(pos);
            startPoint.setTop(pos.getY());
        }
    }

    @Override
    public double getHeight() {
        StiStartPointPrimitive startPoint = this.getStartPoint();
        StiEndPointPrimitive endPoint = this.getEndPoint();
        if (startPoint == null || endPoint == null) {
            return super.getHeight();
        }
        StiPoint startPos = new StiPoint(startPoint.getLeft(), startPoint.getTop());
        StiPoint endPos = new StiPoint(endPoint.getLeft(), endPoint.getTop());
        startPos = startPoint.ComponentToPage(startPos);
        endPos = endPoint.ComponentToPage(endPos);
        return (double)Math.round((endPos.getY() - startPos.getY()) * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    @Override
    public void setHeight(double value) {
        super.setHeight(value);
        StiStartPointPrimitive startPoint = this.getStartPoint();
        StiEndPointPrimitive endPoint = this.getEndPoint();
        if (startPoint != null && endPoint != null) {
            StiPoint startPos = new StiPoint(startPoint.getLeft(), startPoint.getTop());
            startPos = startPoint.ComponentToPage(startPos);
            StiPoint endPos = new StiPoint(startPos.getX().doubleValue(), startPos.getY() + value);
            endPos = endPoint.PageToComponent(endPos);
            endPoint.setTop(endPos.getY());
        }
    }

    public final StiStartPointPrimitive getStartPoint() {
        if (this.getReport() != null && !this.getReport().getIsRendering() && !this.isDesigning()) {
            return null;
        }
        if (this.isDesigning() && this.StoredStartPoint != null) {
            return this.StoredStartPoint;
        }
        if (this.getPage() == null) {
            return null;
        }
        this.StoredStartPoint = this.getStartPoint(this.getPage());
        return this.StoredStartPoint;
    }

    public final StiStartPointPrimitive getStartPoint(StiContainer cont) {
        for (StiComponent comp : cont.getComponents()) {
            StiStartPointPrimitive startPoint2;
            StiStartPointPrimitive startPoint = (StiStartPointPrimitive)(comp instanceof StiStartPointPrimitive ? comp : null);
            if (startPoint != null && startPoint.getReferenceToGuid().equals(this.getGuid())) {
                return startPoint;
            }
            StiContainer cont2 = (StiContainer)(comp instanceof StiContainer ? comp : null);
            if (cont2 == null || (startPoint2 = this.getStartPoint(cont2)) == null) continue;
            return startPoint2;
        }
        return null;
    }

    public final StiEndPointPrimitive getEndPoint() {
        if (this.getReport() != null && !this.getReport().getIsRendering() && !this.isDesigning()) {
            return null;
        }
        if (this.isDesigning() && this.StoredEndPoint != null) {
            return this.StoredEndPoint;
        }
        if (this.getPage() == null) {
            return null;
        }
        this.StoredEndPoint = this.getEndPoint(this.getPage());
        return this.StoredEndPoint;
    }

    public final StiEndPointPrimitive getEndPoint(StiContainer cont) {
        for (StiComponent comp : cont.getComponents()) {
            StiEndPointPrimitive endPoint2;
            StiEndPointPrimitive endPoint = (StiEndPointPrimitive)(comp instanceof StiEndPointPrimitive ? comp : null);
            if (endPoint != null && endPoint.getReferenceToGuid().equals(this.getGuid())) {
                return endPoint;
            }
            StiContainer cont2 = (StiContainer)(comp instanceof StiContainer ? comp : null);
            if (cont2 == null || (endPoint2 = this.getEndPoint(cont2)) == null) continue;
            return endPoint2;
        }
        return null;
    }
}

