/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.report.StiBlocklyHelper;
import com.stimulsoft.report.StiScriptHelper;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiCheckStyle;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBreakable;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiEditable;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.interfaces.IStiTextBrush;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.events.StiEvent;
import com.stimulsoft.report.events.StiEventsCollection;
import com.stimulsoft.report.events.StiGetCheckedEvent;
import com.stimulsoft.report.events.StiGetExcelValueEvent;
import com.stimulsoft.report.events.StiGetExcelValueEventArgs;
import com.stimulsoft.report.events.StiValueEventArgs;
import com.stimulsoft.report.expressions.StiCheckedExpression;
import com.stimulsoft.report.expressions.StiExcelValueExpression;
import com.stimulsoft.report.expressions.StiUnifiedExpression;
import com.stimulsoft.report.units.StiUnit;
import java.util.Locale;
import java.util.logging.Logger;

public class StiCheckBox
extends StiComponent
implements IStiBorder,
IStiTextBrush,
IStiEditable,
IStiBrush,
IStiBreakable,
IStiExportImageExtended {
    private static Logger LOG = Logger.getLogger("com.stimulsoft.report.components.simplecomponents.StiCheckBox");
    private StiBrush brush = new StiSolidBrush();
    private StiBorder border = new StiBorder();
    private StiBrush textBrush = new StiSolidBrush(StiColor.Black);
    private boolean editable = false;
    private boolean canBreak = false;
    private static final Object EventGetChecked = new Object();
    private static final Object EventGetExcelValue = new Object();
    private Object checkedValue;
    private String excelDataValue;
    private StiColor contourColor = StiColor.Black;
    private double size = 1.0;
    private final StiCheckStyle checkStyle = StiCheckStyle.Check;
    private String values = "true/false";
    private StiCheckStyle checkStyleForTrue = StiCheckStyle.Check;
    private StiCheckStyle checkStyleForFalse = StiCheckStyle.None;

    @Override
    public String SaveState() {
        return null;
    }

    @Override
    public boolean getCanShrink() {
        return super.getCanShrink();
    }

    @Override
    public void setCanShrink(boolean value) {
    }

    @Override
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public void setCanGrow(boolean value) {
    }

    @Override
    @StiSerializable(shortName="bh")
    public final StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(StiBrush value) {
        this.brush = value;
    }

    @Override
    @StiSerializable(shortName="br")
    public final StiBorder getBorder() {
        return this.border;
    }

    @Override
    public final void setBorder(StiBorder value) {
        this.border = value;
    }

    @Override
    @StiSerializable(shortName="tb")
    public final StiBrush getTextBrush() {
        return this.textBrush;
    }

    @Override
    public final void setTextBrush(StiBrush value) {
        this.textBrush = value;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean value) {
        this.editable = value;
    }

    private String saveState() {
        return this.getCheckedValue() instanceof Boolean && (Boolean)this.getCheckedValue() == true ? "true" : "false";
    }

    @Override
    public Object clone(boolean cloneProperties) {
        StiCheckBox checkBox = (StiCheckBox)super.clone(cloneProperties);
        checkBox.textBrush = this.textBrush != null ? (StiBrush)this.textBrush.clone() : null;
        return checkBox;
    }

    @Override
    public boolean getCanBreak() {
        return this.canBreak || this.getGrowToHeight() && this.getPage() != null && this.getHeight() / this.getPage().getPageHeight() > 0.5;
    }

    @Override
    public void setCanBreak(boolean value) {
        this.canBreak = value;
    }

    @Override
    public final boolean Break(StiComponent dividedComponent, double devideFactor, StiRefObject<Double> divideLine, StiRefObject<Boolean> haveBreaked) {
        boolean first;
        divideLine.argvalue = 0.0;
        boolean result = true;
        boolean bl = first = devideFactor > 0.5 || this.getPage() != null && this.getHeight() / this.getPage().getPageHeight() > 0.5;
        if (first) {
            ((StiCheckBox)dividedComponent).setCheckedValue(null);
        } else {
            this.setCheckedValue(null);
        }
        return result;
    }

    @Override
    public StiEventsCollection getEvents() {
        StiEventsCollection events = super.getEvents();
        if (this.getGetCheckedEvent() != null) {
            events.add(this.getGetCheckedEvent());
        }
        return events;
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.CheckBox.getValue();
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.get((String)"Report", (String)"Components");
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.get((String)"Components", (String)"StiCheckBox");
    }

    @Override
    public void invokeEvents() {
        super.invokeEvents();
        if (this.getChecked().getValue() != null && this.getChecked().getValue().length() > 0 && this.checkedValue == null) {
            StiValueEventArgs e = new StiValueEventArgs();
            this.InvokeGetChecked(this, e);
            this.checkedValue = e.getValue();
        }
    }

    protected void OnGetChecked(StiValueEventArgs e) {
    }

    public final void InvokeGetChecked(StiComponent sender, StiValueEventArgs e) {
        try {
            Object parseTextValue;
            this.OnGetChecked(e);
            if (this.getChecked().getValue() != null && this.getChecked().getValue().length() > 0 && (parseTextValue = StiScriptHelper.parseTextValue(this.getChecked().getValue(), this)) != null) {
                e.setValue(parseTextValue);
            }
            this.invokeScript(this.getGetCheckedEvent(), sender, e);
            StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getGetCheckedEvent(), e);
        }
        catch (Exception e1) {
            if (this.getReport() != null) {
                String.format("Expression in parameters of '%s' can't be evaluated! %s", this.getName(), e1.getMessage());
            }
            LOG.warning(String.format("Expression in parameters of '%s' can't be evaluated! %s", this.getName(), e1.getMessage()));
        }
    }

    public void InvokeGetExcelValue(StiComponent sender, StiGetExcelValueEventArgs e) {
        try {
            this.OnGetExcelValue(e);
            this.invokeScript(this.getGetExcelValueEvent(), sender, e);
            StiBlocklyHelper.invokeBlockly(this.getReport(), sender, this.getGetExcelValueEvent(), e);
        }
        catch (Exception ex) {
            StiLoggingUtil.printStackTrace((Exception)ex);
        }
    }

    @StiSerializable
    public final StiGetCheckedEvent getGetCheckedEvent() {
        return new StiGetCheckedEvent(this);
    }

    public final void setGetCheckedEvent(StiGetCheckedEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnGetExcelValue(StiGetExcelValueEventArgs e) {
    }

    @StiSerializable
    public final StiGetExcelValueEvent getGetExcelValueEvent() {
        return new StiGetExcelValueEvent(this);
    }

    public final void setGetExcelValueEvent(StiGetExcelValueEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final Object getCheckedValue() {
        return this.checkedValue;
    }

    public final void setCheckedValue(Object value) {
        this.checkedValue = value;
    }

    @StiSerializable
    public final StiCheckedExpression getChecked() {
        return new StiCheckedExpression(this, "Checked");
    }

    public final void setChecked(StiCheckedExpression value) {
        if (value != null) {
            value.set(this, "Checked", value.getValue());
        }
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final String getExcelDataValue() {
        return this.excelDataValue;
    }

    public final void setExcelDataValue(String value) {
        this.excelDataValue = value;
    }

    @StiSerializable
    public StiExcelValueExpression getExcelValue() {
        return new StiExcelValueExpression(this, "ExcelValue");
    }

    public void setExcelValue(StiExcelValueExpression value) {
        if (value != null) {
            value.set(this, "ExcelValue", value.getValue());
        }
    }

    public final boolean isChecked() {
        String[] strs = null;
        if (this.getValues().indexOf(47) != -1) {
            strs = this.getValues().split("[/]", -1);
        } else if (this.getValues().indexOf(59) != -1) {
            strs = this.getValues().split("[;]", -1);
        } else if (this.getValues().indexOf(44) != -1) {
            strs = this.getValues().split("[,]", -1);
        }
        if (strs.length == 0) {
            return false;
        }
        String value = strs[0].toLowerCase(Locale.getDefault()).trim();
        if (value.length() == 0) {
            return false;
        }
        if (this.getCheckedValue() == null) {
            return false;
        }
        String checkedValueStr = this.getCheckedValue().toString().toLowerCase(Locale.getDefault()).trim();
        return value.equals(checkedValueStr);
    }

    public final boolean isUnchecked() {
        String[] strs = null;
        if (this.getValues().indexOf(47) != -1) {
            strs = this.getValues().split("[/]", -1);
        } else if (this.getValues().indexOf(59) != -1) {
            strs = this.getValues().split("[;]", -1);
        } else if (this.getValues().indexOf(44) != -1) {
            strs = this.getValues().split("[,]", -1);
        }
        if (strs.length < 2) {
            return false;
        }
        String value = strs[1].toLowerCase(Locale.getDefault()).trim();
        if (value.length() == 0) {
            return false;
        }
        if (this.getCheckedValue() == null) {
            return false;
        }
        String checkedValueStr = this.getCheckedValue().toString().toLowerCase(Locale.getDefault()).trim();
        return value.equals(checkedValueStr);
    }

    @StiSerializable
    public final StiColor getContourColor() {
        return this.contourColor;
    }

    public final void setContourColor(StiColor value) {
        this.contourColor = value;
    }

    @StiSerializable
    @StiDefaulValue(value="1.0")
    public final double getSize() {
        return this.size;
    }

    public final void setSize(double value) {
        this.size = value;
    }

    @Deprecated
    public final StiCheckStyle getCheckStyle() {
        return this.getCheckStyleForTrue();
    }

    @Deprecated
    public final void setCheckStyle(StiCheckStyle value) {
        if (this.checkStyle == value) {
            this.setCheckStyleForTrue(value);
            this.setCheckStyleForFalse(StiCheckStyle.None);
        }
    }

    @StiSerializable
    @StiDefaulValue(value="true/false")
    public final String getValues() {
        return this.values;
    }

    public final void setValues(String value) {
        this.values = value;
    }

    @StiSerializable
    @StiDefaulValue(value="Check")
    public final StiCheckStyle getCheckStyleForTrue() {
        return this.checkStyleForTrue;
    }

    public final void setCheckStyleForTrue(StiCheckStyle value) {
        this.checkStyleForTrue = value;
    }

    @StiSerializable
    @StiDefaulValue(value="None")
    public final StiCheckStyle getCheckStyleForFalse() {
        return this.checkStyleForFalse;
    }

    public final void setCheckStyleForFalse(StiCheckStyle value) {
        this.checkStyleForFalse = value;
    }

    public StiCheckBox() {
        this(StiRectangle.empty());
    }

    public StiCheckBox(StiRectangle rect) {
        super(rect);
    }

    @Override
    public void convert(StiUnit oldUnit, StiUnit newUnit) {
    }

    @Override
    public void saveState(String stateName) {
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        if (format == StiExportFormat.Text) {
            return false;
        }
        return format != StiExportFormat.Excel && format != StiExportFormat.ExcelXml && format != StiExportFormat.Excel2007 && format != StiExportFormat.Ods || this.excelDataValue == null || this.excelDataValue.length() <= 0;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("CanShrink");
        jObject.RemoveProperty("CanGrow");
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getBrush()));
        jObject.AddPropertyStringNullOfEmpty("Border", StiJsonReportObjectHelper.Serialize.JBorder((StiBorder)this.getBorder()));
        jObject.AddPropertyStringNullOfEmpty("TextBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getTextBrush()));
        jObject.AddPropertyBool("Editable", this.getEditable());
        jObject.AddPropertyJObject("GetCheckedEvent", this.getGetCheckedEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetExcelValueEvent", this.getGetExcelValueEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Checked", this.getChecked().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("ExcelDataValue", this.getExcelDataValue());
        jObject.AddPropertyJObject("ExcelValue", this.getExcelValue().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("ContourColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getContourColor(), (StiColorEnum)StiColorEnum.Black));
        jObject.AddPropertyDouble("Size", this.getSize(), 1.0);
        jObject.AddPropertyString("Values", this.getValues(), "true/false");
        jObject.AddPropertyEnum("CheckStyleForTrue", (Enum)this.getCheckStyleForTrue(), (Enum)StiCheckStyle.Check);
        jObject.AddPropertyEnum("CheckStyleForFalse", (Enum)this.getCheckStyleForFalse(), (Enum)StiCheckStyle.None);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            StiUnifiedExpression _expression;
            StiEvent _event;
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("Border")) {
                this.border = StiJsonReportObjectHelper.Deserialize.Border((JProperty)property);
                continue;
            }
            if (property.Name.equals("TextBrush")) {
                this.textBrush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("Editable")) {
                this.editable = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("GetCheckedEvent")) {
                _event = new StiGetCheckedEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetCheckedEvent((StiGetCheckedEvent)_event);
                continue;
            }
            if (property.Name.equals("GetExcelValueEvent")) {
                _event = new StiGetExcelValueEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetExcelValueEvent((StiGetExcelValueEvent)_event);
                continue;
            }
            if (property.Name.equals("Checked")) {
                _expression = new StiCheckedExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setChecked((StiCheckedExpression)_expression);
                continue;
            }
            if (property.Name.equals("ExcelDataValue")) {
                this.excelDataValue = (String)property.Value;
                continue;
            }
            if (property.Name.equals("ExcelValue")) {
                _expression = new StiExcelValueExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setExcelValue((StiExcelValueExpression)_expression);
                continue;
            }
            if (property.Name.equals("ContourColor")) {
                this.contourColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("Size")) {
                this.size = property.doubleValue();
                continue;
            }
            if (property.Name.equals("Values")) {
                this.values = (String)property.Value;
                continue;
            }
            if (property.Name.equals("CheckStyleForTrue")) {
                this.checkStyleForTrue = StiCheckStyle.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("CheckStyleForFalse")) continue;
            this.checkStyleForFalse = StiCheckStyle.valueOf((String)property.Value);
        }
    }
}

