/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.conditions;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.conditions.StiBaseCondition;
import com.stimulsoft.report.components.conditions.StiContentAlignment;
import com.stimulsoft.report.components.conditions.StiIconSetItem;
import com.stimulsoft.report.components.enums.StiIcon;
import com.stimulsoft.report.components.enums.StiIconSet;
import com.stimulsoft.report.components.enums.StiIconSetOperation;
import com.stimulsoft.report.components.enums.StiIconSetValueType;
import com.stimulsoft.report.components.indicators.StiIconSetIndicator;
import com.stimulsoft.report.components.indicators.StiIndicator;
import com.stimulsoft.report.components.interfaces.IStiIndicatorCondition;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import java.text.MessageFormat;

public class StiIconSetCondition
extends StiBaseCondition
implements IStiIndicatorCondition {
    private StiIconSet iconSet = StiIconSet.None;
    private StiContentAlignment contentAlignment = StiContentAlignment.MiddleLeft;
    private StiIconSetItem iconSetItem1 = null;
    private StiIconSetItem iconSetItem2 = null;
    private StiIconSetItem iconSetItem3 = null;
    private StiIconSetItem iconSetItem4 = null;
    private StiIconSetItem iconSetItem5 = null;
    private Float minimum = null;
    private Float maximum = null;

    public StiIconSetCondition() {
    }

    public StiIconSetCondition(String column, StiIconSet iconSet, StiContentAlignment contentAlignment, StiIconSetItem item1, StiIconSetItem item2, StiIconSetItem item3, StiIconSetItem item4, StiIconSetItem item5) {
        this.column = column;
        this.iconSet = iconSet;
        this.contentAlignment = contentAlignment;
        this.iconSetItem1 = item1;
        this.iconSetItem2 = item2;
        this.iconSetItem3 = item3;
        this.iconSetItem4 = item4;
        this.iconSetItem5 = item5;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public final StiIndicator CreateIndicator(StiText component) {
        if (StiValidationUtil.isNullOrEmpty((String)this.column)) {
            component.getReport().WriteToReportRenderingMessages(String.format("Column of Icon Set Condition of '%1$s' component is not specified!", component.getName()));
            return null;
        }
        if (this.minimum == null || this.maximum == null) {
            this.minimum = Float.valueOf(0.0f);
            this.maximum = Float.valueOf(0.0f);
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(component.getReport().dictionary, this.column);
            if (dataSource != null) {
                dataSource.saveState("Indicator");
                dataSource.First();
                int index = 0;
                while (!dataSource.getIsEof()) {
                    String value = StiDataColumn.getDataFromDataColumnStr(component.getReport().dictionary, this.column);
                    float floatValue = 0.0f;
                    try {
                        floatValue = Float.parseFloat(value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (index == 0) {
                        this.minimum = Float.valueOf(floatValue);
                        this.maximum = Float.valueOf(floatValue);
                    } else {
                        this.minimum = Float.valueOf(Math.min(this.minimum == null ? 0.0f : this.minimum.floatValue(), floatValue));
                        this.maximum = Float.valueOf(Math.max(this.maximum == null ? 0.0f : this.maximum.floatValue(), floatValue));
                    }
                    ++index;
                    dataSource.Next();
                }
                dataSource.RestoreState("Indicator");
            }
            if (dataSource == null) {
                StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(component.getReport().dictionary, this.column);
                if (businessObject == null) {
                    component.getReport().WriteToReportRenderingMessages(String.format("Column of Data Bar Condition of '%1$s' component is not found!", component.getName()));
                    return null;
                }
                businessObject.SaveState("Indicator");
                businessObject.CreateEnumerator();
                int index = 0;
                while (!businessObject.getIsEof()) {
                    String value = StiDataColumn.getDataFromDataColumnStr(component.getReport().dictionary, this.column);
                    float floatValue = 0.0f;
                    try {
                        floatValue = Float.parseFloat(value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (index == 0) {
                        this.minimum = Float.valueOf(floatValue);
                        this.maximum = Float.valueOf(floatValue);
                    } else {
                        this.minimum = Float.valueOf(Math.min(this.minimum == null ? 0.0f : this.minimum.floatValue(), floatValue));
                        this.maximum = Float.valueOf(Math.max(this.maximum == null ? 0.0f : this.maximum.floatValue(), floatValue));
                    }
                    ++index;
                    businessObject.next();
                }
                businessObject.RestoreState("Indicator");
            }
        }
        float minimumToUse = this.minimum == null ? 0.0f : this.minimum.floatValue();
        float maximumToUse = this.maximum == null ? 0.0f : this.maximum.floatValue();
        float dist = maximumToUse - minimumToUse;
        String currentValue = StiDataColumn.getDataFromDataColumnStr(component.getReport().dictionary, this.column);
        float floatCurrentValue = 0.0f;
        try {
            floatCurrentValue = Float.parseFloat(currentValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (floatCurrentValue > maximumToUse) {
            floatCurrentValue = maximumToUse;
        }
        if (floatCurrentValue < minimumToUse) {
            floatCurrentValue = minimumToUse;
        }
        float floatCurrentValuePercent = (floatCurrentValue - minimumToUse) / dist * 100.0f;
        StiIcon icon = StiIcon.None;
        if (this.getIconSetItem4() == null && this.getIconSetItem5() == null) {
            if (this.InRange(this.getIconSetItem1(), floatCurrentValue, floatCurrentValuePercent)) {
                icon = this.getIconSetItem1().getIcon();
            } else if (this.InRange(this.getIconSetItem2(), floatCurrentValue, floatCurrentValuePercent)) {
                icon = this.getIconSetItem2().getIcon();
            } else if (this.getIconSetItem3() != null) {
                icon = this.getIconSetItem3().getIcon();
            }
        } else if (this.getIconSetItem5() == null) {
            if (this.InRange(this.getIconSetItem1(), floatCurrentValue, floatCurrentValuePercent)) {
                icon = this.getIconSetItem1().getIcon();
            } else if (this.InRange(this.getIconSetItem2(), floatCurrentValue, floatCurrentValuePercent)) {
                icon = this.getIconSetItem2().getIcon();
            } else if (this.InRange(this.getIconSetItem3(), floatCurrentValue, floatCurrentValuePercent)) {
                icon = this.getIconSetItem3().getIcon();
            } else if (this.getIconSetItem4() != null) {
                icon = this.getIconSetItem4().getIcon();
            }
        } else if (this.InRange(this.getIconSetItem1(), floatCurrentValue, floatCurrentValuePercent)) {
            icon = this.getIconSetItem1().getIcon();
        } else if (this.InRange(this.getIconSetItem2(), floatCurrentValue, floatCurrentValuePercent)) {
            icon = this.getIconSetItem2().getIcon();
        } else if (this.InRange(this.getIconSetItem3(), floatCurrentValue, floatCurrentValuePercent)) {
            icon = this.getIconSetItem3().getIcon();
        } else if (this.InRange(this.getIconSetItem4(), floatCurrentValue, floatCurrentValuePercent)) {
            icon = this.getIconSetItem4().getIcon();
        } else if (this.getIconSetItem5() != null) {
            icon = this.getIconSetItem5().getIcon();
        }
        if (icon == StiIcon.None) {
            return null;
        }
        StiIconSetIndicator indicator = new StiIconSetIndicator();
        indicator.setIcon(icon);
        indicator.setAlignment(this.getContentAlignment());
        return indicator;
    }

    private boolean InRange(StiIconSetItem item, float floatCurrentValue, float floatCurrentValuePercent) {
        if (item == null) {
            return false;
        }
        return item.getValueType() == StiIconSetValueType.Percent ? (item.getOperation() == StiIconSetOperation.MoreThan ? floatCurrentValuePercent > item.getValue() : floatCurrentValuePercent >= item.getValue()) : (item.getOperation() == StiIconSetOperation.MoreThan ? floatCurrentValue > item.getValue() : floatCurrentValue >= item.getValue());
    }

    @Override
    public final void Reset() {
        this.minimum = null;
        this.maximum = null;
    }

    @StiSerializable
    public final StiContentAlignment getContentAlignment() {
        return this.contentAlignment;
    }

    public final void setContentAlignment(StiContentAlignment value) {
        this.contentAlignment = value;
    }

    @StiSerializable
    public final StiIconSet getIconSet() {
        return this.iconSet;
    }

    public final void setIconSet(StiIconSet value) {
        this.iconSet = value;
    }

    @StiSerializable
    public final StiIconSetItem getIconSetItem1() {
        return this.iconSetItem1;
    }

    public final void setIconSetItem1(StiIconSetItem value) {
        this.iconSetItem1 = value;
    }

    @StiSerializable
    public final StiIconSetItem getIconSetItem2() {
        return this.iconSetItem2;
    }

    public final void setIconSetItem2(StiIconSetItem value) {
        this.iconSetItem2 = value;
    }

    @StiSerializable
    public final StiIconSetItem getIconSetItem3() {
        return this.iconSetItem3;
    }

    public final void setIconSetItem3(StiIconSetItem value) {
        this.iconSetItem3 = value;
    }

    @StiSerializable
    public final StiIconSetItem getIconSetItem4() {
        return this.iconSetItem4;
    }

    public final void setIconSetItem4(StiIconSetItem value) {
        this.iconSetItem4 = value;
    }

    @StiSerializable
    public final StiIconSetItem getIconSetItem5() {
        return this.iconSetItem5;
    }

    public final void setIconSetItem5(StiIconSetItem value) {
        this.iconSetItem5 = value;
    }

    @Override
    public String serialize() {
        String iconSet1 = "null";
        String iconSet2 = "null";
        String iconSet3 = "null";
        String iconSet4 = "null";
        String iconSet5 = "null";
        if (this.iconSetItem1 != null) {
            iconSet1 = this.iconSetItem1.serialize();
        }
        if (this.iconSetItem2 != null) {
            iconSet2 = this.iconSetItem2.serialize();
        }
        if (this.iconSetItem3 != null) {
            iconSet3 = this.iconSetItem3.serialize();
        }
        if (this.iconSetItem4 != null) {
            iconSet4 = this.iconSetItem4.serialize();
        }
        if (this.iconSetItem5 != null) {
            iconSet5 = this.iconSetItem5.serialize();
        }
        String data = MessageFormat.format("IconSet,{0},{1},{2},{3},{4},{5},{6},{7}", StiXMLConvert.encodeName((String)this.getColumn()), StiXMLConvert.encodeName((Enum)this.iconSet), StiXMLConvert.encodeName((Enum)this.contentAlignment), StiXMLConvert.encodeName((String)iconSet1), StiXMLConvert.encodeName((String)iconSet2), StiXMLConvert.encodeName((String)iconSet3), StiXMLConvert.encodeName((String)iconSet4), StiXMLConvert.encodeName((String)iconSet5));
        return data;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = StiXMLConvert.decodeName((String)values[i]);
        }
        this.setColumn(values[1]);
        this.iconSet = StiIconSet.valueOf(values[2]);
        this.contentAlignment = StiContentAlignment.valueOf(values[3]);
        if (!values[4].equals("null")) {
            this.iconSetItem1 = new StiIconSetItem();
            this.iconSetItem1.deserializeStr(values[4]);
        }
        if (!values[5].equals("null")) {
            this.iconSetItem2 = new StiIconSetItem();
            this.iconSetItem2.deserializeStr(values[5]);
        }
        if (!values[6].equals("null")) {
            this.iconSetItem3 = new StiIconSetItem();
            this.iconSetItem3.deserializeStr(values[6]);
        }
        if (!values[7].equals("null")) {
            this.iconSetItem4 = new StiIconSetItem();
            this.iconSetItem4.deserializeStr(values[7]);
        }
        if (!values[8].equals("null")) {
            this.iconSetItem5 = new StiIconSetItem();
            this.iconSetItem5.deserializeStr(values[8]);
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyEnum("IconSet", (Enum)this.getIconSet(), (Enum)StiIconSet.None);
        jObject.AddPropertyEnum("ContentAlignment", (Enum)this.getContentAlignment(), (Enum)StiContentAlignment.MiddleLeft);
        if (this.iconSetItem1 != null) {
            jObject.AddPropertyJObject("IconSetItem1", this.iconSetItem1.SaveToJsonObject(mode));
        }
        if (this.iconSetItem2 != null) {
            jObject.AddPropertyJObject("IconSetItem2", this.iconSetItem2.SaveToJsonObject(mode));
        }
        if (this.iconSetItem3 != null) {
            jObject.AddPropertyJObject("IconSetItem3", this.iconSetItem3.SaveToJsonObject(mode));
        }
        if (this.iconSetItem4 != null) {
            jObject.AddPropertyJObject("IconSetItem4", this.iconSetItem4.SaveToJsonObject(mode));
        }
        if (this.iconSetItem5 != null) {
            jObject.AddPropertyJObject("IconSetItem5", this.iconSetItem5.SaveToJsonObject(mode));
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            StiIconSetItem icon;
            if (property.Name.equals("IconSet")) {
                this.iconSet = StiIconSet.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("ContentAlignment")) {
                this.contentAlignment = StiContentAlignment.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("IconSetItem1")) {
                icon = new StiIconSetItem();
                icon.LoadFromJsonObject((JSONObject)property.Value);
                this.iconSetItem1 = icon;
                continue;
            }
            if (property.Name.equals("IconSetItem2")) {
                icon = new StiIconSetItem();
                icon.LoadFromJsonObject((JSONObject)property.Value);
                this.iconSetItem2 = icon;
                continue;
            }
            if (property.Name.equals("IconSetItem3")) {
                icon = new StiIconSetItem();
                icon.LoadFromJsonObject((JSONObject)property.Value);
                this.iconSetItem3 = icon;
                continue;
            }
            if (property.Name.equals("IconSetItem4")) {
                icon = new StiIconSetItem();
                icon.LoadFromJsonObject((JSONObject)property.Value);
                this.iconSetItem4 = icon;
                continue;
            }
            if (!property.Name.equals("IconSetItem5")) continue;
            icon = new StiIconSetItem();
            icon.LoadFromJsonObject((JSONObject)property.Value);
            this.iconSetItem5 = icon;
        }
    }
}

