/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.conditions;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.StiGraphicsUnit;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.conditions.StiFilter;
import com.stimulsoft.report.components.enums.StiConditionPermissions;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.styles.StiBaseStyle;
import java.util.Hashtable;

public class StiConditionHelper
extends StiFilter {
    public static void Apply(Object comp, String styleName) {
        StiBaseStyle st2;
        StiComponent component = (StiComponent)(comp instanceof StiComponent ? comp : null);
        if (styleName.startsWith("##") && styleName.endsWith("##")) {
            styleName = styleName.substring(2, 2 + styleName.length() - 4);
            for (StiBaseStyle st : StiOptions.Designer.getStyles()) {
                if (!styleName.equals(st.getName())) continue;
                st.SetStyleToComponent(component);
                StiConditionHelper.applyParentStyle(st, component);
                return;
            }
        }
        if ((st2 = component.getReport().getStyles().get(styleName)) != null) {
            st2.SetStyleToComponent(component);
            StiConditionHelper.applyParentStyle(st2, component);
            return;
        }
        component.getReport().WriteToReportRenderingMessages(String.format("'%1$s' style not found in conditions of '%2$s' component!", styleName, component.getName()));
    }

    private static void applyParentStyle(StiBaseStyle style, StiComponent comp) {
        if (comp != null && comp.getReport() != null && comp.getReport().getEngine() != null) {
            if (comp.getReport().getEngine().getHashParentStyles() == null) {
                comp.getReport().getEngine().setHashParentStyles(new Hashtable<StiComponent, StiBaseStyle>());
            }
            comp.getReport().getEngine().getHashParentStyles().put(comp, style);
        }
    }

    public static void ApplyFont(Object component, StiFont font, StiEnumSet<StiConditionPermissions> perms) {
        IStiFont fontComp = (IStiFont)(component instanceof IStiFont ? component : null);
        if (fontComp != null) {
            boolean fontUsed = false;
            String fontName = fontComp.getFont().getName();
            double fontSize = fontComp.getFont().size;
            boolean fontStyleBold = fontComp.getFont().bold();
            boolean fontStyleItalic = fontComp.getFont().italic();
            boolean fontStyleUnderline = fontComp.getFont().underline();
            boolean fontStyleStrikeout = fontComp.getFont().strikeout();
            if (perms.contains((IStiEnum)StiConditionPermissions.Font)) {
                fontUsed = true;
                fontName = font.getName();
            }
            if (perms.contains((IStiEnum)StiConditionPermissions.FontSize)) {
                fontUsed = true;
                fontSize = font.getSize();
            }
            if (perms.contains((IStiEnum)StiConditionPermissions.FontStyleBold)) {
                fontUsed = true;
                fontStyleBold = font.bold();
            }
            if (perms.contains((IStiEnum)StiConditionPermissions.FontStyleItalic)) {
                fontUsed = true;
                fontStyleItalic = font.italic();
            }
            if (perms.contains((IStiEnum)StiConditionPermissions.FontStyleUnderline)) {
                fontUsed = true;
                fontStyleUnderline = font.underline();
            }
            if (perms.contains((IStiEnum)StiConditionPermissions.FontStyleStrikeout)) {
                fontUsed = true;
                fontStyleStrikeout = font.strikeout();
            }
            if (fontUsed) {
                int fontStyle = StiFontStyle.Regular.intValue;
                if (fontStyleBold) {
                    fontStyle |= StiFontStyle.Bold.intValue;
                }
                if (fontStyleItalic) {
                    fontStyle |= StiFontStyle.Italic.intValue;
                }
                if (fontStyleUnderline) {
                    fontStyle |= StiFontStyle.Underline.intValue;
                }
                if (fontStyleStrikeout) {
                    fontStyle |= StiFontStyle.Strikeout.intValue;
                }
                fontComp.setFont(new StiFont(fontName, fontSize, fontStyle, StiGraphicsUnit.Point));
            }
        }
    }
}

