/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.conditions;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.conditions.StiBaseCondition;
import com.stimulsoft.report.components.enums.StiConditionBorderSides;
import com.stimulsoft.report.components.enums.StiConditionPermissions;
import com.stimulsoft.report.components.enums.StiFilterCondition;
import com.stimulsoft.report.components.enums.StiFilterDataType;
import com.stimulsoft.report.components.enums.StiFilterItem;
import java.text.MessageFormat;
import java.util.Date;

public class StiCondition
extends StiBaseCondition
implements IStiSerializable,
IStiSerializableToString {
    private boolean enabled = true;
    private StiColor textColor = StiColorEnum.Red.color();
    private StiColor backColor = StiColorEnum.Transparent.color();
    private StiFont font = new StiFont("Arial", 8.0);
    private boolean canAssignExpression = false;
    private String assignExpression = "";
    private String style = "";
    private Boolean breakIfTrue = false;
    private StiEnumSet<StiConditionBorderSides> borderSides = StiEnumSet.of((Enum)StiConditionBorderSides.NotAssigned);
    private StiEnumSet<StiConditionPermissions> permissions = StiEnumSet.of((Enum)StiConditionPermissions.All);

    public StiCondition(StiFilterItem item, String column, StiFilterCondition condition, String value1, String value2, StiFilterDataType dataType, String expression, StiColor textColor, StiColor backColor, StiFont font, boolean enabled, boolean canAssignExpression, String assignExpression, String style, StiEnumSet<StiConditionBorderSides> borderSides, StiEnumSet<StiConditionPermissions> permissions) {
        super(item, column, condition, value1, value2, dataType, expression);
        this.textColor = textColor;
        this.backColor = backColor;
        this.font = font;
        this.enabled = enabled;
        this.canAssignExpression = canAssignExpression;
        this.assignExpression = assignExpression;
        this.style = style;
        this.borderSides = borderSides;
        this.permissions = permissions;
    }

    public StiCondition(String expression, StiColor textColor, StiColor backColor, StiFont font, boolean enabled) {
        super(expression);
        this.textColor = textColor;
        this.backColor = backColor;
        this.font = font;
        this.enabled = enabled;
    }

    public StiCondition(String expression, StiColor textColor, StiColor backColor, StiFont font, boolean enabled, boolean canAssignExpression, String assignExpression) {
        this(expression, textColor, backColor, font, enabled, canAssignExpression, assignExpression, "", (StiEnumSet<StiConditionBorderSides>)StiEnumSet.of((Enum)StiConditionBorderSides.NotAssigned));
    }

    public StiCondition(String expression, StiColor textColor, StiColor backColor, StiFont font, boolean enabled, boolean canAssignExpression, String assignExpression, String style, StiEnumSet<StiConditionBorderSides> borderSides) {
        this(expression, textColor, backColor, font, enabled);
        this.canAssignExpression = canAssignExpression;
        this.assignExpression = assignExpression;
        this.style = style;
        this.borderSides = borderSides;
    }

    public StiCondition(String expression, StiColor textColor, StiColor backColor, StiFont font, boolean enabled, boolean canAssignExpression, String assignExpression, String style, StiEnumSet<StiConditionBorderSides> borderSides, StiEnumSet<StiConditionPermissions> permissions) {
        this(expression, textColor, backColor, font, enabled);
        this.canAssignExpression = canAssignExpression;
        this.assignExpression = assignExpression;
        this.style = style;
        this.borderSides = borderSides;
        this.permissions = permissions;
    }

    public StiCondition(String column, StiFilterCondition condition, Date date1, StiColor textColor, StiColor backColor, StiFont font, boolean enabled) {
        super(column, condition, date1);
        this.textColor = textColor;
        this.backColor = backColor;
        this.font = font;
        this.enabled = enabled;
    }

    public StiCondition(String column, StiFilterCondition condition, Date date1, Date date2, StiColor textColor, StiColor backColor, StiFont font, boolean enabled) {
        super(column, condition, date1, date2);
        this.textColor = textColor;
        this.backColor = backColor;
        this.font = font;
        this.enabled = enabled;
    }

    public StiCondition(String column, StiFilterCondition condition, String value, StiFilterDataType dataType, StiColor textColor, StiColor backColor, StiFont font, boolean enabled) {
        super(column, condition, value, "", dataType);
        this.textColor = textColor;
        this.backColor = backColor;
        this.font = font;
        this.enabled = enabled;
    }

    public StiCondition(String column, StiFilterCondition condition, String value1, String value2, StiFilterDataType dataType, StiColor textColor, StiColor backColor, StiFont font, boolean enabled) {
        this(column, condition, value1, value2, dataType, textColor, backColor, font, enabled, false, "");
    }

    public StiCondition(String column, StiFilterCondition condition, String value1, String value2, StiFilterDataType dataType, StiColor textColor, StiColor backColor, StiFont font, boolean enabled, boolean canAssignExpression, String assignExpression) {
        this(column, condition, value1, value2, dataType, textColor, backColor, font, enabled, canAssignExpression, assignExpression, "", (StiEnumSet<StiConditionBorderSides>)StiEnumSet.of((Enum)StiConditionBorderSides.NotAssigned));
    }

    public StiCondition(String column, StiFilterCondition condition, String value1, String value2, StiFilterDataType dataType, StiColor textColor, StiColor backColor, StiFont font, boolean enabled, boolean canAssignExpression, String assignExpression, String style, StiEnumSet<StiConditionBorderSides> borderSides) {
        super(column, condition, value1, value2, dataType);
        this.textColor = textColor;
        this.backColor = backColor;
        this.font = font;
        this.enabled = enabled;
        this.canAssignExpression = canAssignExpression;
        this.assignExpression = assignExpression;
        this.style = style;
        this.borderSides = borderSides;
    }

    public StiCondition(String column, StiFilterCondition condition, String value1, String value2, StiFilterDataType dataType, StiColor textColor, StiColor backColor, StiFont font, boolean enabled, boolean canAssignExpression, String assignExpression, String style, StiEnumSet<StiConditionBorderSides> borderSides, StiEnumSet<StiConditionPermissions> permissions, boolean breakIfTrue) {
        super(column, condition, value1, value2, dataType);
        this.textColor = textColor;
        this.backColor = backColor;
        this.font = font;
        this.enabled = enabled;
        this.canAssignExpression = canAssignExpression;
        this.assignExpression = assignExpression;
        this.style = style;
        this.borderSides = borderSides;
        this.permissions = permissions;
        this.breakIfTrue = breakIfTrue;
    }

    public StiCondition(StiFilterItem item, String column, StiFilterCondition condition, String value1, String value2, StiFilterDataType dataType, String expression, StiColor textColor, StiColor backColor, StiFont font, boolean enabled) {
        this(item, column, condition, value1, value2, dataType, expression, textColor, backColor, font, enabled, false, "");
    }

    public StiCondition(StiFilterItem item, String column, StiFilterCondition condition, String value1, String value2, StiFilterDataType dataType, String expression, StiColor textColor, StiColor backColor, StiFont font, boolean enabled, boolean canAssignExpression, String assignExpression) {
        this(item, column, condition, value1, value2, dataType, expression, textColor, backColor, font, enabled, canAssignExpression, assignExpression, "", (StiEnumSet<StiConditionBorderSides>)StiEnumSet.of((Enum)StiConditionBorderSides.NotAssigned));
    }

    public StiCondition(StiFilterItem item, String column, StiFilterCondition condition, String value1, String value2, StiFilterDataType dataType, String expression, StiColor textColor, StiColor backColor, StiFont font, boolean enabled, boolean canAssignExpression, String assignExpression, String style, StiEnumSet<StiConditionBorderSides> borderSides) {
        this(item, column, condition, value1, value2, dataType, expression, textColor, backColor, font, enabled, canAssignExpression, assignExpression, style, borderSides, (StiEnumSet<StiConditionPermissions>)StiEnumSet.of((Enum)StiConditionPermissions.All));
    }

    public Object clone() {
        StiCondition condition = null;
        try {
            condition = (StiCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return condition;
    }

    @StiSerializable
    @StiDefaulValue(value="true")
    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean value) {
        this.enabled = value;
    }

    @StiSerializable
    public final StiColor getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(StiColor value) {
        this.textColor = value;
    }

    @StiSerializable
    public final StiColor getBackColor() {
        return this.backColor;
    }

    public final void setBackColor(StiColor value) {
        this.backColor = value;
    }

    @StiSerializable
    public final StiFont getFont() {
        return this.font;
    }

    public final void setFont(StiFont value) {
        this.font = value;
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getCanAssignExpression() {
        return this.canAssignExpression;
    }

    public final void setCanAssignExpression(boolean value) {
        this.canAssignExpression = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getAssignExpression() {
        return this.assignExpression;
    }

    public final void setAssignExpression(String value) {
        this.assignExpression = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getStyle() {
        return this.style;
    }

    public final void setStyle(String value) {
        this.style = value;
    }

    @StiSerializable
    @StiDefaulValue(value="NotAssigned")
    public final StiEnumSet<StiConditionBorderSides> getBorderSides() {
        return this.borderSides;
    }

    public final void setBorderSides(StiEnumSet<StiConditionBorderSides> value) {
        this.borderSides = value;
        int permissionsInt = this.getPermissionsInt();
        if (value.contains((IStiEnum)StiConditionBorderSides.NotAssigned)) {
            this.borderSides = StiEnumSet.of((Enum)StiConditionBorderSides.None);
            if ((permissionsInt & StiConditionPermissions.Borders.getValue()) > 0) {
                this.permissions.remove((IStiEnum)StiConditionPermissions.Borders);
            }
        }
    }

    private int getPermissionsInt() {
        int result = 0;
        for (StiConditionPermissions permission : this.permissions.collection()) {
            result += permission.getValue();
        }
        return result;
    }

    @StiSerializable
    @StiDefaulValue(value="All")
    public final StiEnumSet<StiConditionPermissions> getPermissions() {
        return this.permissions;
    }

    public final void setPermissions(StiEnumSet<StiConditionPermissions> value) {
        this.permissions = value;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        StiCondition condition = (StiCondition)(obj instanceof StiCondition ? obj : null);
        if (condition == null) {
            return false;
        }
        return this.backColor.equals(condition.backColor) && this.textColor.equals(condition.textColor) && this.column.equals(condition.column) && this.getCondition().equals((Object)condition.getCondition()) && this.getDataType().equals((Object)condition.getDataType()) && new Boolean(this.enabled).equals(condition.enabled) && this.font.equals((Object)condition.font) && this.getItem().equals((Object)condition.getItem()) && this.getValue1().equals(condition.getValue1()) && this.getValue2().equals(condition.getValue2()) && this.getExpression().getValue().trim().equals(condition.getExpression().getValue().trim()) && new Boolean(this.getCanAssignExpression()).equals(condition.getCanAssignExpression()) && this.getAssignExpression().equals(condition.getAssignExpression());
    }

    public StiCondition() {
    }

    @Override
    public String serialize() {
        String data = this.getItem() == StiFilterItem.Expression ? (StiValidationUtil.isNullOrEmpty((String)this.style) && this.borderSides.contains((IStiEnum)StiConditionBorderSides.NotAssigned) ? StiSerializerUtil.serializFormat((String)"{0}{1},{2},{3},{4},{5},{6},{7}", (Object[])new Object[]{this.breakIfTrue != false ? "BreakIfTrue," : "", StiXMLConvert.encodeName((String)this.getExpression().getValue()), this.textColor.serializeString(), this.backColor.serializeString(), StiXMLConvert.encodeName((String)this.font.serializeString()), this.enabled, this.canAssignExpression, StiXMLConvert.encodeName((String)this.assignExpression)}) : (this.permissions.contains((IStiEnum)StiConditionPermissions.All) ? StiSerializerUtil.serializFormat((String)"{0}{1},{2},{3},{4},{5},{6},{7},{8},{9}", (Object[])new Object[]{this.breakIfTrue != false ? "BreakIfTrue," : "", StiXMLConvert.encodeName((String)this.getExpression().getValue()), this.textColor.serializeString(), this.backColor.serializeString(), StiXMLConvert.encodeName((String)this.font.serializeString()), this.enabled, this.canAssignExpression, StiXMLConvert.encodeName((String)this.assignExpression), StiXMLConvert.encodeName((String)this.style), StiXMLConvert.encodeName(this.borderSides)}) : StiSerializerUtil.serializFormat((String)"{0}{1},{2},{3},{4},{5},{6},{7},{8},{9},{10}", (Object[])new Object[]{this.breakIfTrue != false ? "BreakIfTrue," : "", StiXMLConvert.encodeName((String)this.getExpression().getValue()), this.textColor.serializeString(), this.backColor.serializeString(), StiXMLConvert.encodeName((String)this.font.serializeString()), this.enabled, this.canAssignExpression, StiXMLConvert.encodeName((String)this.assignExpression), StiXMLConvert.encodeName((String)this.style), StiXMLConvert.encodeName(this.borderSides), StiXMLConvert.encodeName(this.permissions)}))) : (StiValidationUtil.isNullOrEmpty((String)this.style) && this.borderSides.contains((IStiEnum)StiConditionBorderSides.NotAssigned) ? StiSerializerUtil.serializFormat((String)"{0}{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11}", (Object[])new Object[]{this.breakIfTrue != false ? "BreakIfTrue," : "", StiXMLConvert.encodeName((String)this.getColumn()), this.getCondition(), StiXMLConvert.encodeName((String)this.getValue1(), (boolean)false), StiXMLConvert.encodeName((String)this.getValue2(), (boolean)false), this.getDataType(), this.textColor.serializeString(), this.backColor.serializeString(), StiXMLConvert.encodeName((String)this.font.serializeString()), this.enabled, this.canAssignExpression, StiXMLConvert.encodeName((String)this.assignExpression)}) : (this.permissions.contains((IStiEnum)StiConditionPermissions.All) ? StiSerializerUtil.serializFormat((String)"{0}{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13}", (Object[])new Object[]{this.breakIfTrue != false ? "BreakIfTrue," : "", StiXMLConvert.encodeName((String)this.getColumn()), this.getCondition(), StiXMLConvert.encodeName((String)this.getValue1(), (boolean)false), StiXMLConvert.encodeName((String)this.getValue2(), (boolean)false), this.getDataType(), this.textColor.serializeString(), this.backColor.serializeString(), StiXMLConvert.encodeName((String)this.font.serializeString()), this.enabled, this.canAssignExpression, StiXMLConvert.encodeName((String)this.assignExpression), StiXMLConvert.encodeName((String)this.style), StiXMLConvert.encodeName(this.borderSides)}) : MessageFormat.format("{0}{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},{14}", new Object[]{this.breakIfTrue != false ? "BreakIfTrue," : "", StiXMLConvert.encodeName((String)this.getColumn()), this.getCondition(), StiXMLConvert.encodeName((String)this.getValue1(), (boolean)false), StiXMLConvert.encodeName((String)this.getValue2(), (boolean)false), this.getDataType(), this.textColor.serializeString(), this.backColor.serializeString(), StiXMLConvert.encodeName((String)this.font.serializeString()), StiSerializTypeConverter.booleanToString((boolean)this.enabled), StiSerializTypeConverter.booleanToString((boolean)this.canAssignExpression), StiXMLConvert.encodeName((String)this.assignExpression), StiXMLConvert.encodeName((String)this.style), StiXMLConvert.encodeName(this.borderSides), StiXMLConvert.encodeName(this.permissions)})));
        return data;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values;
        boolean breakIfTrue = false;
        if (strObject.startsWith("BreakIfTrue,")) {
            breakIfTrue = true;
            strObject = strObject.replace("BreakIfTrue,", "");
        }
        if ((values = strObject.split(",", -1)).length == 5 || values.length == 7 || values.length > 7 && this.isBorderSides(values[8])) {
            this.setItem(StiFilterItem.Expression);
            this.getExpression().setValue(StiXMLConvert.decodeName((String)values[0]));
            this.textColor = StiColor.deserializeString((String)values[1]);
            this.backColor = StiColor.deserializeString((String)values[2]);
            this.font.deserializeString(StiXMLConvert.decodeName((String)values[3]));
            this.enabled = StiSerializTypeConverter.stringToBoolean((String)values[4]);
            if (values.length >= 7) {
                this.canAssignExpression = StiSerializTypeConverter.stringToBoolean((String)values[5]);
                this.assignExpression = StiXMLConvert.decodeName((String)values[6]);
            }
            if (values.length >= 9) {
                this.style = StiXMLConvert.decodeName((String)values[7]);
                this.borderSides = StiSerializTypeConverter.stringToEnums(StiConditionBorderSides.class, (String)StiXMLConvert.decodeName((String)values[8]));
                this.breakIfTrue = breakIfTrue;
            }
            if (values.length == 10) {
                this.permissions = StiSerializTypeConverter.stringToEnums(StiConditionPermissions.class, (String)StiXMLConvert.decodeName((String)values[9]));
            }
        } else {
            String filterCondition = values[1];
            if (filterCondition == "GreaterThen") {
                filterCondition = "GreaterThan";
            }
            if (filterCondition == "GreaterThenOrEqualTo") {
                filterCondition = "GreaterThanOrEqualTo";
            }
            if (filterCondition == "LessThen") {
                filterCondition = "LessThan";
            }
            if (filterCondition == "LessThenOrEqualTo") {
                filterCondition = "LessThanOrEqualTo";
            }
            this.setItem(StiFilterItem.Value);
            this.setColumn(StiXMLConvert.decodeName((String)values[0]));
            this.setCondition(StiFilterCondition.valueOf(filterCondition));
            this.setValue1(StiXMLConvert.decodeName((String)values[2]));
            this.setValue2(StiXMLConvert.decodeName((String)values[3]));
            this.setDataType(StiFilterDataType.valueOf(values[4]));
            this.textColor = StiColor.deserializeString((String)values[5]);
            this.backColor = StiColor.deserializeString((String)values[6]);
            this.font.deserializeString(StiXMLConvert.decodeName((String)values[7]));
            this.enabled = StiSerializTypeConverter.stringToBoolean((String)values[8]);
            this.canAssignExpression = false;
            if (values.length >= 11) {
                this.canAssignExpression = StiSerializTypeConverter.stringToBoolean((String)values[9]);
                this.assignExpression = StiXMLConvert.decodeName((String)values[10]);
            }
            if (values.length >= 13) {
                this.style = StiXMLConvert.decodeName((String)values[11]);
                this.borderSides = StiSerializTypeConverter.stringToEnums(StiConditionBorderSides.class, (String)StiXMLConvert.decodeName((String)values[12]));
            }
            if (values.length == 14) {
                this.permissions = StiSerializTypeConverter.stringToEnums(StiConditionPermissions.class, (String)StiXMLConvert.decodeName((String)values[13]));
            }
        }
    }

    private boolean isBorderSides(String value) {
        if ((value = StiXMLConvert.decodeName((String)value).toLowerCase()).equals("false") || value.equals("true")) {
            return false;
        }
        return value.indexOf("left") >= 0 || value.indexOf("top") >= 0 || value.indexOf("right") >= 0 || value.indexOf("bottom") >= 0 || value.indexOf("all") >= 0 || value.indexOf("none") >= 0 || value.indexOf("notassigned") >= 0;
    }

    @StiSerializable
    public Boolean getBreakIfTrue() {
        return this.breakIfTrue;
    }

    public void setBreakIfTrue(Boolean breakIfTrue) {
        this.breakIfTrue = breakIfTrue;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyBool("Enabled", this.getEnabled(), true);
        jObject.AddPropertyStringNullOfEmpty("TextColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.getTextColor(), (StiColor)StiColorEnum.Red.color()));
        jObject.AddPropertyStringNullOfEmpty("BackColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.getBackColor(), (StiColor)StiColorEnum.Transparent.color()));
        jObject.AddPropertyStringNullOfEmpty("Font", StiJsonReportObjectHelper.Serialize.fontDefault((StiFont)this.getFont()));
        jObject.AddPropertyBool("CanAssignExpression", this.getCanAssignExpression());
        jObject.AddPropertyStringNullOfEmpty("Style", this.getStyle());
        jObject.AddPropertyEnum("BorderSides", this.getBorderSides(), (IStiEnum)StiConditionBorderSides.NotAssigned);
        jObject.AddPropertyEnum("Permissions", this.getPermissions(), (IStiEnum)StiConditionPermissions.All);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Enabled")) {
                this.enabled = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("TextColor")) {
                this.textColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("BackColor")) {
                this.backColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("Font")) {
                this.font = StiJsonReportObjectHelper.Deserialize.Font((JProperty)property, (StiFont)this.font);
                continue;
            }
            if (property.Name.equals("CanAssignExpression")) {
                this.canAssignExpression = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Style")) {
                this.style = (String)property.Value;
                continue;
            }
            if (property.Name.equals("BorderSides")) {
                this.borderSides = StiEnumSet.stringToEnums(StiConditionBorderSides.class, (String)((String)property.Value));
                continue;
            }
            if (!property.Name.equals("Permissions")) continue;
            this.permissions = StiEnumSet.stringToEnums(StiConditionPermissions.class, (String)((String)property.Value));
        }
    }
}

