/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.complexcomponents;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.interfaces.IStiBreakable;

public class StiPanel
extends StiContainer
implements IStiBreakable {
    private boolean rightToLeft;
    private double columnGaps;
    private double columnWidth;
    private int columns;

    public StiPanel() {
        this(StiRectangle.empty());
    }

    public StiPanel(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getCanBreak() {
        return super.getCanBreak();
    }

    @Override
    public void setCanBreak(boolean value) {
        super.setCanBreak(value);
    }

    @StiDefaulValue(value="false")
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public boolean getRightToLeft() {
        return this.rightToLeft;
    }

    public void setRightToLeft(boolean value) {
        if (this.rightToLeft != value) {
            this.checkBlockedException("RightToLeft");
            this.rightToLeft = value;
        }
    }

    @StiDefaulValue(value="0.0")
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public double getColumnGaps() {
        return this.columnGaps;
    }

    public void setColumnGaps(double value) {
        if (this.columnGaps != value) {
            this.checkBlockedException("ColumnGaps");
            if (value < 0.0) {
                throw new IndexOutOfBoundsException("ColumnGaps " + String.format("Value of '%1$s' is not valid for 'ColumnGaps'. 'ColumnGaps' must be greater than or equal to 0.", value));
            }
            this.columnGaps = value;
        }
    }

    @StiDefaulValue(value="0.0")
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public double getColumnWidth() {
        return this.columnWidth;
    }

    public double getColumnWidth2() {
        double panelColumnWidth = this.columnWidth;
        if (panelColumnWidth == 0.0) {
            if (this.getColumns() == 0) {
                return this.getWidth();
            }
            panelColumnWidth = this.getWidth() / (double)this.getColumns() - this.getColumnGaps();
        }
        return panelColumnWidth;
    }

    public void setColumnWidth(double value) {
        if (this.columnWidth != value) {
            this.checkBlockedException("ColumnWidth");
            if (value < 0.0) {
                throw new IndexOutOfBoundsException("ColumnWidth " + String.format("Value of '%1$s' is not valid for 'ColumnWidth'. 'ColumnWidth' must be greater than or equal to 0.", value));
            }
            this.columnWidth = value;
        }
    }

    @StiDefaulValue(value="0")
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int value) {
        if (this.columns != value) {
            this.checkBlockedException("Columns");
            if (value < 0) {
                throw new IndexOutOfBoundsException("Columns " + String.format("Value of '%1$s' is not valid for 'Columns'. 'Columns' must be greater than or equal to 0.", value));
            }
            this.columns = value;
        }
    }

    public double getColumnWidthM() {
        double panelColumnWidth = this.getColumnWidth();
        if (panelColumnWidth == 0.0) {
            if (this.getColumns() == 0) {
                return this.getWidth();
            }
            panelColumnWidth = this.getWidth() / (double)this.getColumns() - this.getColumnGaps();
        }
        return panelColumnWidth;
    }

    @Override
    public int getPriority() {
        return StiComponentPriority.Panel.getValue();
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.Panel.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.get((String)"Components", (String)"StiPanel");
    }

    public void addComponent(StiComponent component) {
        component.setParent(this);
        this.getComponents().add(component);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyBool("CanBreak", this.getCanBreak(), true);
        jObject.AddPropertyBool("RightToLeft", this.getRightToLeft());
        jObject.AddPropertyDouble("ColumnGaps", this.getColumnGaps(), 0.0);
        jObject.AddPropertyDouble("ColumnWidth", this.getColumnWidth(), 0.0);
        jObject.AddPropertyInt("Columns", this.getColumns());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("RightToLeft")) {
                this.rightToLeft = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ColumnGaps")) {
                this.columnGaps = property.doubleValue();
                continue;
            }
            if (property.Name.equals("ColumnWidth")) {
                this.columnWidth = property.doubleValue();
                continue;
            }
            if (!property.Name.equals("Columns")) continue;
            this.columns = (Integer)property.Value;
        }
    }
}

