/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.bands;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentDivider;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiEmptyBand;
import com.stimulsoft.report.components.bands.StiStaticBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiPrintOnType;
import com.stimulsoft.report.components.interfaces.IStiBreakable;
import com.stimulsoft.report.components.interfaces.IStiPrintIfEmpty;
import com.stimulsoft.report.dialogs.IStiReportControl;
import com.stimulsoft.report.engine.StiEngineVersion;

public class StiReportTitleBand
extends StiStaticBand
implements IStiBreakable,
IStiPrintIfEmpty {
    private boolean printIfEmpty = true;

    public StiReportTitleBand() {
        this(StiRectangle.empty());
    }

    public StiReportTitleBand(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(false);
    }

    @Override
    public StiPrintOnType getPrintOn() {
        return super.getPrintOn();
    }

    @Override
    public void setPrintOn(StiPrintOnType value) {
        super.setPrintOn(value);
    }

    @Override
    public boolean getCanBreak() {
        return true;
    }

    @Override
    public void setCanBreak(boolean value) {
    }

    @Override
    public boolean Break(StiComponent dividedComponent, double devideFactor, StiRefObject<Double> divLine, StiRefObject<Boolean> haveBreaked) {
        divLine.argvalue = 0.0;
        StiContainer newCont = StiComponentDivider.BreakContainer(this.getHeight(), (StiContainer)(this instanceof StiContainer ? this : null), haveBreaked);
        ((StiContainer)dividedComponent).getComponents().Clear();
        ((StiContainer)dividedComponent).getComponents().AddRange(newCont.getComponents());
        return true;
    }

    @Override
    @StiDefaulValue(value="true")
    public boolean getPrintIfEmpty() {
        return this.printIfEmpty;
    }

    @Override
    public void setPrintIfEmpty(boolean value) {
        this.printIfEmpty = value;
    }

    @Override
    public boolean getResetPageNumber() {
        return super.getResetPageNumber();
    }

    @Override
    public void setResetPageNumber(boolean value) {
        super.setResetPageNumber(value);
    }

    @Override
    public StiColor getHeaderStartColor() {
        return StiColor.create((StiColorEnum)StiColorEnum.LightGreen);
    }

    @Override
    public StiColor getHeaderEndColor() {
        return StiColor.create((StiColorEnum)StiColorEnum.MediumSeaGreen);
    }

    @Override
    public StiComponentType getComponentType() {
        if (this.getPage() != null && this.getPage().getEngineVersion() == StiEngineVersion.EngineV2) {
            if (this.getPage().TitleBeforeHeader()) {
                return StiComponentType.Static;
            }
            return StiComponentType.Master;
        }
        return StiComponentType.Simple;
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.ReportTitleBand.getValue();
    }

    @Override
    public int getPriority() {
        if (this.getPage().TitleBeforeHeader()) {
            return StiComponentPriority.ReportTitleBandBefore.getValue();
        }
        if (this.getPage() != null && this.getPage().getEngineVersion() == StiEngineVersion.EngineV1) {
            return StiComponentPriority.ReportTitleBandAfterV1.getValue();
        }
        return StiComponentPriority.ReportTitleBandAfterV2.getValue();
    }

    @Override
    public boolean canContainIn(StiComponent component) {
        if (component instanceof IStiReportControl) {
            return false;
        }
        return component instanceof StiPage;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiReportTitleBand");
    }

    public final StiComponent GetMaster() {
        for (StiComponent component : this.getParent().getComponents()) {
            if (!(component instanceof StiDataBand) || component instanceof StiEmptyBand) continue;
            return component;
        }
        return null;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("PrintOn");
        jObject.RemoveProperty("CanBreak");
        jObject.AddPropertyBool("PrintIfEmpty", this.getPrintIfEmpty(), true);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (!property.Name.equals("PrintIfEmpty")) continue;
            this.printIfEmpty = (Boolean)property.Value;
        }
    }
}

