/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.bands;

import com.stimulsoft.base.EventArgs;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiBlocklyHelper;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiEmptySizeMode;
import com.stimulsoft.report.components.interfaces.IStiOddEvenStyles;
import com.stimulsoft.report.events.StiBeginRenderEvent;
import com.stimulsoft.report.events.StiEndRenderEvent;
import com.stimulsoft.report.events.StiEvent;
import com.stimulsoft.report.events.StiRenderingEvent;

public class StiEmptyBand
extends StiBand
implements IStiOddEvenStyles {
    private static final Object EventBeginRender = new Object();
    private static final Object EventRendering = new Object();
    private static final Object EventEndRender = new Object();
    private StiEmptySizeMode sizeMode = StiEmptySizeMode.AlignFooterToTop;

    @Override
    public String GetHeaderText() {
        return this.toString();
    }

    @Override
    public StiColor getHeaderStartColor() {
        return StiColor.create((StiColorEnum)StiColorEnum.GreenYellow);
    }

    @Override
    public StiColor getHeaderEndColor() {
        return StiColor.create((StiColorEnum)StiColorEnum.YellowGreen);
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.EmptyBand.getValue();
    }

    @Override
    public int getPriority() {
        return StiComponentPriority.EmptyBand.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiEmptyBand");
    }

    @Override
    @StiDefaulValue(value="")
    @StiSerializable
    public String getEvenStyle() {
        Object tempVar = this.properties.get(StiDataBand.PropertyEvenStyle, (Object)"");
        return (String)(tempVar instanceof String ? tempVar : null);
    }

    @Override
    public void setEvenStyle(String value) {
        this.properties.set(StiDataBand.PropertyEvenStyle, (Object)value, (Object)"");
    }

    @Override
    @StiDefaulValue(value="")
    @StiSerializable
    public String getOddStyle() {
        Object tempVar = this.properties.get(StiDataBand.PropertyOddStyle, (Object)"");
        return (String)(tempVar instanceof String ? tempVar : null);
    }

    @Override
    public void setOddStyle(String value) {
        this.properties.set(StiDataBand.PropertyOddStyle, (Object)value, (Object)"");
    }

    protected void OnBeginRender(EventArgs e) {
    }

    @StiSerializable
    public final StiBeginRenderEvent getBeginRenderEvent() {
        return new StiBeginRenderEvent(this);
    }

    public final void setBeginRenderEvent(StiBeginRenderEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnRendering(EventArgs e) {
    }

    @StiSerializable
    public final StiRenderingEvent getRenderingEvent() {
        return new StiRenderingEvent(this);
    }

    public final void setRenderingEvent(StiRenderingEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnEndRender(EventArgs e) {
    }

    @StiSerializable
    public final StiEndRenderEvent getEndRenderEvent() {
        return new StiEndRenderEvent(this);
    }

    public final void setEndRenderEvent(StiEndRenderEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @StiDefaulValue(value="AlignFooterToTop")
    @StiSerializable
    public StiEmptySizeMode getSizeMode() {
        return this.sizeMode;
    }

    public void setSizeMode(StiEmptySizeMode value) {
        this.sizeMode = value;
    }

    public StiEmptyBand() {
        this(StiRectangle.empty());
    }

    public StiEmptyBand(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(false);
    }

    @Override
    public void InvokeBeginRender() {
        this.OnBeginRender(EventArgs.Empty);
        this.invokeScript(this.getBeginRenderEvent());
        StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getBeginRenderEvent());
    }

    public void InvokeRendering() {
        this.OnRendering(EventArgs.Empty);
        this.invokeScript(this.getRenderingEvent());
        StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getRenderingEvent());
    }

    @Override
    public void InvokeEndRender() {
        this.OnEndRender(EventArgs.Empty);
        this.invokeScript(this.getEndRenderEvent());
        StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getEndRenderEvent());
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("EvenStyle", this.getEvenStyle());
        jObject.AddPropertyStringNullOfEmpty("OddStyle", this.getOddStyle());
        jObject.AddPropertyJObject("BeginRenderEvent", this.getBeginRenderEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("RenderingEvent", this.getRenderingEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("EndRenderEvent", this.getEndRenderEvent().SaveToJsonObject(mode));
        jObject.AddPropertyEnum("SizeMode", (Enum)this.getSizeMode(), (Enum)StiEmptySizeMode.AlignFooterToTop);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            StiEvent _event;
            if (property.Name.equals("EvenStyle")) {
                this.setEvenStyle((String)property.Value);
                continue;
            }
            if (property.Name.equals("OddStyle")) {
                this.setOddStyle((String)property.Value);
                continue;
            }
            if (property.Name.equals("BeginRenderEvent")) {
                _event = new StiBeginRenderEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setBeginRenderEvent((StiBeginRenderEvent)_event);
                continue;
            }
            if (property.Name.equals("RenderingEvent")) {
                _event = new StiRenderingEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setRenderingEvent((StiRenderingEvent)_event);
                continue;
            }
            if (property.Name.equals("EndRenderEvent")) {
                _event = new StiEndRenderEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setEndRenderEvent((StiEndRenderEvent)_event);
                continue;
            }
            if (!property.Name.equals("SizeMode")) continue;
            this.sizeMode = StiEmptySizeMode.valueOf((String)property.Value);
        }
    }
}

