/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.bands;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiDynamicBand;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.interfaces.IStiKeepChildTogether;
import com.stimulsoft.report.expressions.StiBookmarkExpression;
import com.stimulsoft.report.expressions.StiHyperlinkExpression;

public class StiChildBand
extends StiDynamicBand
implements IStiKeepChildTogether {
    private boolean keepChildTogether = true;
    private boolean printIfParentDisabled = false;

    public StiChildBand() {
        this(StiRectangle.empty());
    }

    public StiChildBand(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(false);
    }

    @Override
    public boolean getCanBreak() {
        return super.getCanBreak();
    }

    @Override
    public void setCanBreak(boolean value) {
        super.setCanBreak(value);
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="true")
    public boolean getKeepChildTogether() {
        return this.keepChildTogether;
    }

    @Override
    public void setKeepChildTogether(boolean value) {
        if (this.keepChildTogether != value) {
            this.CheckBlockedException("KeepChildTogether");
            this.keepChildTogether = value;
        }
    }

    @Override
    public StiBookmarkExpression getBookmark() {
        return super.getBookmark();
    }

    @Override
    public void setBookmark(StiBookmarkExpression value) {
        super.setBookmark(value);
    }

    @Override
    public StiHyperlinkExpression getHyperlink() {
        return super.getHyperlink();
    }

    @Override
    public void setHyperlink(StiHyperlinkExpression value) {
        super.setHyperlink(value);
    }

    @Override
    public StiColor getHeaderStartColor() {
        StiBand band = this.GetMaster();
        return band != null ? StiColorUtils.light((StiColor)band.getHeaderStartColor(), (int)50) : StiColor.White;
    }

    @Override
    public StiColor getHeaderEndColor() {
        StiBand band = this.GetMaster();
        return band != null ? StiColorUtils.light((StiColor)band.getHeaderStartColor(), (int)50) : StiColor.White;
    }

    @Override
    public StiComponentType getComponentType() {
        return StiComponentType.Detail;
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.ChildBand.getValue();
    }

    @Override
    public int getPriority() {
        return StiComponentPriority.ChildBand.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiChildBand");
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getPrintIfParentDisabled() {
        return this.printIfParentDisabled;
    }

    public void setPrintIfParentDisabled(boolean value) {
        if (this.printIfParentDisabled != value) {
            this.CheckBlockedException("PrintIfParentDisabled");
            this.printIfParentDisabled = value;
        }
    }

    public final StiBand GetMaster() {
        for (int index = this.getParent().getComponents().indexOf(this) - 1; index >= 0; --index) {
            if (!(this.getParent().getComponents().get(index) instanceof StiBand) || this.getParent().getComponents().get(index) instanceof StiChildBand) continue;
            return (StiBand)(this.getParent().getComponents().get(index) instanceof StiBand ? (StiComponent)this.getParent().getComponents().get(index) : null);
        }
        return null;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyBool("KeepChildTogether", this.getKeepChildTogether(), true);
        jObject.AddPropertyBool("PrintIfParentDisabled", this.getPrintIfParentDisabled());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("KeepChildTogether")) {
                this.keepChildTogether = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("PrintIfParentDisabled")) continue;
            this.printIfParentDisabled = (Boolean)property.Value;
        }
    }
}

