/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.base.system.geometry.StiRectangle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class StiShadowPanel
extends JPanel {
    private static final long serialVersionUID = -2654586972037481730L;
    public static final int SHADOW_SIZE = 4;
    private Image background;

    public StiShadowPanel(LayoutManager manager) {
        super(manager);
        this.setBorder(BorderFactory.createEmptyBorder(1, 0, 4, 4));
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                this.componentResized(e);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                JPanel panel = (JPanel)e.getComponent();
                if (panel.getRootPane() != null && panel.getRootPane().getContentPane() != null && panel.getRootPane().getContentPane().getComponents() != null) {
                    Component[] components = panel.getRootPane().getContentPane().getComponents();
                    components[0].repaint();
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.componentResized(e);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                this.componentResized(e);
            }
        });
    }

    public void updateBackground() {
        try {
            Robot rbt = new Robot();
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension dim = tk.getScreenSize();
            this.background = rbt.createScreenCapture(new Rectangle(0, 0, (int)dim.getWidth(), (int)dim.getHeight()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Point pos = this.getLocationOnScreen();
        Point offset = new Point(-pos.x, -pos.y);
        g.drawImage(this.background, offset.x, offset.y, null);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth() - 4, this.getHeight() - 4);
        g.setColor(new Color(100, 100, 100));
        g.drawRect(0, 0, this.getWidth() - 4, this.getHeight() - 4);
        this.paintBorderShadow((Graphics2D)g);
    }

    protected void paintBorderShadow(Graphics2D g2) {
        StiRectangle rect = new StiRectangle(0L, 0L, (long)(this.getWidth() - 4), (long)(this.getHeight() - 4));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape oldClip = g2.getClip();
        g2.setClip(this.getVisibleRect());
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.0f));
        for (int i = 0; i < 4; ++i) {
            GeneralPath path = new GeneralPath();
            path.moveTo(rect.getXi() + 4 - i, rect.getBi());
            path.lineTo(rect.getXi() + 4, rect.getBi() + i);
            path.lineTo(rect.getRi(), rect.getBi() + i);
            path.moveTo(rect.getRi() + i, rect.getBi());
            path.curveTo((float)rect.getRi() + (float)i, (float)((double)rect.getBi() + (double)i * 0.5522847498), (float)((double)rect.getRi() + (double)i * 0.5522847498), (float)rect.getBi() + (float)i, rect.getRi(), (float)rect.getBi() + (float)i);
            path.moveTo(rect.getRi() + i, rect.getBi());
            path.lineTo(rect.getRi() + i, 4 + rect.getYi());
            path.lineTo(rect.getRi(), 4 - i + rect.getYi());
            g2.setColor(new Color(0.4f, 0.4f, 0.4f, 1.0f - (float)i / 4.0f));
            g2.draw(path);
        }
        g2.setClip(oldClip);
        g2.setStroke(oldStroke);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }
}

