/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumnsCollection;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDataRelationsCollection;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataSourcesCollection;
import java.util.Hashtable;
import java.util.Iterator;

public class StiDataRetrieval {
    private Hashtable usedColumns = new Hashtable();
    private Hashtable usedRelations = new Hashtable();
    private Hashtable usedDataSources = new Hashtable();

    public final void dispose() {
        this.usedColumns.clear();
        this.usedColumns = null;
        this.usedRelations.clear();
        this.usedRelations = null;
        this.usedDataSources.clear();
        this.usedDataSources = null;
    }

    private Hashtable BuildTokens(String script) {
        Hashtable<String, String> scriptTokens = new Hashtable<String, String>();
        StiState st = StiState.Find;
        String lex = "";
        for (int pos = 0; pos < script.length(); ++pos) {
            char c = script.charAt(pos);
            if (st == StiState.Find) {
                int ps;
                if (Character.isLetter(c) || c == '_') {
                    st = StiState.Lexem;
                    lex = lex + c;
                }
                if (c != '\"' || (ps = script.indexOf(34, pos + 1)) == -1) continue;
                String s = script.substring(pos + 1, pos + 1 + ps - pos - 1);
                scriptTokens.put(s, s);
                pos = ps + 1;
                continue;
            }
            if (st != StiState.Lexem) continue;
            if (Character.isLetterOrDigit(c) || c == '_' || c == '.') {
                st = StiState.Lexem;
                lex = lex + c;
                continue;
            }
            if (lex.equals("")) continue;
            while (pos < script.length() && script.charAt(pos) != '.' && script.charAt(pos) == ' ') {
                ++pos;
            }
            if (pos < script.length() && script.charAt(pos) == '.') {
                lex = lex + '.';
                while (pos < script.length() && script.charAt(pos) == ' ') {
                    ++pos;
                }
                continue;
            }
            --pos;
            scriptTokens.put(lex, lex);
            lex = "";
            st = StiState.Find;
        }
        if (st == StiState.Lexem) {
            scriptTokens.put(lex, lex);
        }
        return scriptTokens;
    }

    public Hashtable getUsedColumns() {
        return this.usedColumns;
    }

    public Hashtable getUsedRelations() {
        return this.usedRelations;
    }

    public Hashtable getUsedDataSources() {
        return this.usedDataSources;
    }

    private void RetrievalFromCompiledReport(StiReport report) {
    }

    public void Retrieval(StiReport report) {
    }

    private static enum StiState {
        Lexem,
        Find;


        public int getValue() {
            return this.ordinal();
        }

        public static StiState forValue(int value) {
            return StiState.values()[value];
        }
    }

    private static class StiDictionaryBuilder {
        private int level;

        private StiDictionaryBuilder() {
        }

        private void buildColumns(Hashtable elements, StiDataColumnsCollection columns, String name) {
            Iterator iterator = columns.iterator();
            while (iterator.hasNext()) {
                StiDataColumn column = (StiDataColumn)iterator.next();
                String elStr = name + '.' + StiNameValidator.CorrectName(column.getName());
                elements.put(elStr, column);
            }
        }

        private void buildRelations(Hashtable elements, StiDataRelationsCollection relations, StiDataSourcesCollection datas, String name) {
            if (relations.size() > 0) {
                for (StiDataRelation relation : relations) {
                    String elStr = name + '.' + StiNameValidator.CorrectName(relation.getName());
                    elements.put(elStr, relation);
                    this.BuildData(elements, relation.getParentSource(), datas, elStr, true);
                    if (relation.getName() == relation.getNameInSource()) continue;
                    elStr = name + '.' + StiNameValidator.CorrectName(relation.getNameInSource());
                    elements.put(elStr, relation);
                    elements.put(StiNameValidator.CorrectName(relation.getNameInSource()), relation);
                    this.BuildData(elements, relation.getParentSource(), datas, elStr, true);
                }
            }
        }

        private void BuildData(Hashtable elements, StiDataSource dataSource, StiDataSourcesCollection datas, String name, boolean skipName) {
            String nm = "";
            if (!name.equals("")) {
                nm = name + '.' + StiNameValidator.CorrectName(dataSource.getName());
            } else if (name.equals("")) {
                nm = StiNameValidator.CorrectName(dataSource.getName());
            }
            ++this.level;
            if (!datas.contains(dataSource)) {
                datas.add(dataSource);
                if (skipName) {
                    this.buildRelations(elements, dataSource.GetParentRelations(), datas, name);
                } else {
                    this.buildRelations(elements, dataSource.GetParentRelations(), datas, nm);
                }
                datas.remove(dataSource);
            }
            if (skipName) {
                this.buildColumns(elements, dataSource.getColumns(), name);
            } else {
                this.buildColumns(elements, dataSource.getColumns(), nm);
            }
            --this.level;
        }

        public final void Build(Hashtable elements, StiDictionary dictionary) {
            StiDataSourcesCollection dataSources = dictionary.getDataSources();
            StiDataSourcesCollection datas = new StiDataSourcesCollection();
            Iterator iterator = dataSources.iterator();
            while (iterator.hasNext()) {
                StiDataSource data = (StiDataSource)iterator.next();
                String dataStr = StiNameValidator.CorrectName(data.getName());
                elements.put(dataStr, data);
                this.BuildData(elements, data, datas, "", false);
            }
        }
    }
}

