/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.report.components.StiShadowPanel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ButtonX
extends JButton
implements AncestorListener {
    private static final long serialVersionUID = 2047116370871532926L;
    private Boolean autoExpandOnClick = false;
    private List<JComponent> subItems = new ArrayList<JComponent>();
    private StiShadowPanel mainPanel = null;
    private JWindow popup;
    private Boolean val = false;
    private Boolean windowInFocus = false;
    private Timer lostFocusTimer;
    private ClosePopupEventable closePopupEventable;

    public ButtonX(ClosePopupEventable closePopupEventable) {
        this.closePopupEventable = closePopupEventable;
        this.setIcon(StiResourceUtil.loadIcon((String)"/ButtonX.png"));
        this.setIconTextGap(-150);
        this.mainPanel = new StiShadowPanel(null);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.setFocusable(false);
        this.lostFocusTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ButtonX.this.windowInFocus.booleanValue()) {
                    ButtonX.this.hidePopup();
                }
                ButtonX.this.lostFocusTimer.stop();
            }
        });
        this.bindEvents();
    }

    private void bindEvents() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ButtonX.this.popup == null) {
                    ButtonX.this.popup = new JWindow(ButtonX.this.getFrame(null));
                    ButtonX.this.popup.add(ButtonX.this.mainPanel);
                    ButtonX.this.popup.addWindowFocusListener(new WindowAdapter(){

                        @Override
                        public void windowLostFocus(WindowEvent evt) {
                            ButtonX.this.windowInFocus = false;
                            ButtonX.this.lostFocusTimer.stop();
                        }

                        @Override
                        public void windowGainedFocus(WindowEvent e) {
                            ButtonX.this.windowInFocus = true;
                        }
                    });
                }
                ButtonX.this.mainPanel.updateBackground();
                ButtonX.this.popup.setSize(ButtonX.this.getSizeControls());
                Point pt = ButtonX.this.getLocationOnScreen();
                pt.translate(0, ButtonX.this.getHeight());
                ButtonX.this.popup.setLocation(pt);
                ButtonX.this.popup.toFront();
                ButtonX.this.popup.setVisible(true);
                ButtonX.this.popup.requestFocusInWindow();
            }
        });
        this.addAncestorListener(this);
        final ButtonX this_ = this;
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent e) {
                MouseEvent event = (MouseEvent)e;
                if (e.getID() == 501 && ButtonX.this.popup != null && ButtonX.this.popup.isVisible() && !ButtonX.this.isChild((Component)event.getSource(), ButtonX.this.popup) && event.getSource() != this_) {
                    ButtonX.this.hidePopup();
                }
            }
        }, 16L);
    }

    private Dimension getSizeControls() {
        Dimension size = new Dimension();
        boolean onlyButtons = true;
        for (JComponent component : this.subItems) {
            Dimension cSize = component.getMaximumSize();
            if (!(component instanceof JButton)) {
                onlyButtons = false;
            }
            if ((double)cSize.width > size.getWidth()) {
                size.width = cSize.width;
            }
            size.height += cSize.height;
        }
        size.height += 5;
        if (!onlyButtons) {
            size.height += 8;
            size.width += 8;
        }
        return size;
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.hidePopup();
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.hidePopup();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
        if (event.getSource() != this.popup) {
            this.hidePopup();
        }
    }

    protected Frame getFrame(Component comp) {
        if (comp == null) {
            comp = this;
        }
        if (comp instanceof Frame) {
            return (Frame)comp;
        }
        return this.getFrame(comp.getParent());
    }

    private void hidePopup() {
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.setVisible(false);
            if (this.closePopupEventable != null) {
                this.closePopupEventable.poupClosed();
            }
        }
    }

    private boolean isChild(Component child, Component parent) {
        while (child.getParent() != null) {
            if ("buttonClose".equals(child.getName())) {
                return false;
            }
            if (child.getParent() == parent) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    public Boolean getAutoExpandOnClick() {
        return this.autoExpandOnClick;
    }

    public void setAutoExpandOnClick(Boolean autoExpandOnClick) {
        this.autoExpandOnClick = autoExpandOnClick;
    }

    public void addSubItem(JComponent component) {
        this.subItems.add(component);
        this.mainPanel.add(component);
        if (component instanceof JScrollPane) {
            component.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (ButtonX.this.popup != null && !ButtonX.this.val.booleanValue()) {
                        ButtonX.this.popup.setSize(ButtonX.this.getSizeControls());
                        ButtonX.this.val = true;
                        ButtonX.this.popup.validate();
                        ButtonX.this.val = false;
                    }
                }
            });
        }
        this.mainPanel.setSize(this.mainPanel.getPreferredSize());
    }

    public void addSubItems(List<JComponent> items) {
        for (JComponent component : items) {
            this.addSubItem(component);
        }
    }

    public List<JComponent> getSubItems() {
        return this.subItems;
    }

    public void setSubItems(List<JComponent> subItems) {
        this.subItems = subItems;
    }

    public static interface ClosePopupEventable {
        public void poupClosed();
    }
}

