/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.seriesLabels;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializeToCodeAsClass;
import com.stimulsoft.base.services.StiService;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.core.seriesLabels.StiSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.pie.StiPieSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiMarkerAlignment;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsValueType;
import com.stimulsoft.report.chart.interfaces.IStiChart;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.view.conditions.StiChartConditionsCollection;
import java.util.List;

public abstract class StiSeriesLabels
extends StiService
implements IStiSerializeToCodeAsClass,
IStiSeriesLabels {
    private boolean preventIntersection = false;
    private StiSeriesLabelsCoreXF core;
    private boolean allowApplyStyle = true;
    private boolean showZeros = false;
    private boolean showNulls = true;
    private boolean markerVisible = false;
    private StiSize markerSize = new StiSize(8, 6);
    private StiMarkerAlignment markerAlignment = StiMarkerAlignment.Left;
    private int step = 0;
    private StiSeriesLabelsValueType valueType = StiSeriesLabelsValueType.Value;
    private String valueTypeSeparator = "-";
    private StiSeriesLabelsValueType legendValueType = StiSeriesLabelsValueType.Value;
    private String textBefore = "";
    private String textAfter = "";
    private float angle = 0.0f;
    private String format = "";
    private boolean antialiasing = true;
    private boolean visible = true;
    private boolean drawBorder = true;
    private boolean useSeriesColor = false;
    private StiColor labelColor = StiColor.Black;
    private StiColor borderColor = StiColor.Black;
    private StiBrush brush = new StiSolidBrush(StiColor.White);
    private StiFont font = new StiFont("Arial", 7.0);
    private IStiChart chart = null;
    private boolean wordWrap = false;
    private int width = 0;

    @Override
    public Object clone() {
        Object tempVar = super.clone();
        IStiSeriesLabels labels = (IStiSeriesLabels)(tempVar instanceof IStiSeriesLabels ? tempVar : null);
        Object tempVar2 = this.getBrush().clone();
        labels.setBrush((StiBrush)(tempVar2 instanceof StiBrush ? tempVar2 : null));
        Object tempVar3 = this.getFont().clone();
        labels.setFont((StiFont)(tempVar3 instanceof StiFont ? tempVar3 : null));
        if (this.core != null) {
            Object tempVar4 = this.core.clone();
            labels.setCore((StiSeriesLabelsCoreXF)(tempVar4 instanceof StiSeriesLabelsCoreXF ? tempVar4 : null));
            labels.getCore().setSeriesLabels(labels);
        }
        return labels;
    }

    public String getServiceName() {
        return this.getCore().getLocalizedName();
    }

    public final String getServiceCategory() {
        return "Chart";
    }

    public final Class getServiceType() {
        return StiSeriesLabels.class;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getPreventIntersection() {
        return this.preventIntersection;
    }

    @Override
    public final void setPreventIntersection(boolean value) {
        this.preventIntersection = value;
    }

    @Override
    public final StiSeriesLabelsCoreXF getCore() {
        return this.core;
    }

    @Override
    public final void setCore(StiSeriesLabelsCoreXF value) {
        this.core = value;
    }

    public final StiAxisSeriesLabelsCoreXF getAxisCore() {
        StiSeriesLabelsCoreXF tempVar = this.getCore();
        return (StiAxisSeriesLabelsCoreXF)(tempVar instanceof StiAxisSeriesLabelsCoreXF ? tempVar : null);
    }

    public final StiPieSeriesLabelsCoreXF getPieCore() {
        StiSeriesLabelsCoreXF tempVar = this.getCore();
        return (StiPieSeriesLabelsCoreXF)(tempVar instanceof StiPieSeriesLabelsCoreXF ? tempVar : null);
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="true")
    public final boolean getAllowApplyStyle() {
        return this.allowApplyStyle;
    }

    @Override
    public final void setAllowApplyStyle(boolean value) {
        if (this.allowApplyStyle != value) {
            this.allowApplyStyle = value;
            if (value && this.getChart() != null) {
                this.getCore().applyStyle(this.getChart().getStyle());
            }
        }
    }

    public final StiChartConditionsCollection getConditions() {
        if (this.getChart() == null) {
            return null;
        }
        return this.getChart().getSeriesLabelsConditions();
    }

    public final void setConditions(StiChartConditionsCollection value) {
        if (this.getChart() == null) {
            return;
        }
        this.getChart().setSeriesLabelsConditions(value);
    }

    @Deprecated
    public final boolean getShowOnZeroValues() {
        return this.getShowZeros();
    }

    @Deprecated
    public final void setShowOnZeroValues(boolean value) {
        this.setShowZeros(value);
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getShowZeros() {
        return this.showZeros;
    }

    @Override
    public final void setShowZeros(boolean value) {
        this.showZeros = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getShowNulls() {
        return this.showNulls;
    }

    @Override
    public final void setShowNulls(boolean value) {
        this.showNulls = value;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getMarkerVisible() {
        return this.markerVisible;
    }

    @Override
    public final void setMarkerVisible(boolean value) {
        this.markerVisible = value;
    }

    @Override
    @StiSerializable
    public final StiSize getMarkerSize() {
        return this.markerSize;
    }

    @Override
    public final void setMarkerSize(StiSize value) {
        this.markerSize = value;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="Left")
    public StiMarkerAlignment getMarkerAlignment() {
        return this.markerAlignment;
    }

    @Override
    public void setMarkerAlignment(StiMarkerAlignment value) {
        this.markerAlignment = value;
    }

    @Override
    @StiDefaulValue(value="0")
    @StiSerializable
    public final int getStep() {
        return this.step;
    }

    @Override
    public final void setStep(int value) {
        this.step = value;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="Value")
    public StiSeriesLabelsValueType getValueType() {
        return this.valueType;
    }

    @Override
    public void setValueType(StiSeriesLabelsValueType value) {
        if (this.valueType != value) {
            if (this.valueType == this.legendValueType) {
                this.legendValueType = value;
            }
            this.valueType = value;
        }
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="")
    public String getValueTypeSeparator() {
        return this.valueTypeSeparator;
    }

    @Override
    public void setValueTypeSeparator(String value) {
        if (!this.valueTypeSeparator.equals(value)) {
            this.valueTypeSeparator = value;
        }
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="Value")
    public StiSeriesLabelsValueType getLegendValueType() {
        return this.legendValueType;
    }

    @Override
    public void setLegendValueType(StiSeriesLabelsValueType value) {
        this.legendValueType = value;
    }

    @Override
    @StiDefaulValue(value="")
    @StiSerializable
    public final String getTextBefore() {
        return this.textBefore;
    }

    @Override
    public final void setTextBefore(String value) {
        this.textBefore = value;
    }

    @Override
    @StiDefaulValue(value="")
    @StiSerializable
    public final String getTextAfter() {
        return this.textAfter;
    }

    @Override
    public final void setTextAfter(String value) {
        this.textAfter = value;
    }

    @Override
    @StiDefaulValue(value="0.0")
    @StiSerializable
    public float getAngle() {
        return this.angle;
    }

    @Override
    public void setAngle(float value) {
        this.angle = value;
    }

    @Override
    @StiDefaulValue(value="")
    @StiSerializable
    public final String getFormat() {
        return this.format;
    }

    @Override
    public final void setFormat(String value) {
        this.format = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getAntialiasing() {
        return this.antialiasing;
    }

    @Override
    public void setAntialiasing(boolean value) {
        this.antialiasing = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean value) {
        this.visible = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    @Override
    public void setDrawBorder(boolean value) {
        this.drawBorder = value;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getUseSeriesColor() {
        return this.useSeriesColor;
    }

    @Override
    public void setUseSeriesColor(boolean value) {
        this.useSeriesColor = value;
    }

    @Override
    @StiSerializable
    public StiColor getLabelColor() {
        return this.labelColor;
    }

    @Override
    public void setLabelColor(StiColor value) {
        this.labelColor = value;
    }

    @Override
    @StiSerializable
    public StiColor getBorderColor() {
        return this.borderColor;
    }

    @Override
    public void setBorderColor(StiColor value) {
        this.borderColor = value;
    }

    @Override
    @StiSerializable(shortName="bh")
    public StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public void setBrush(StiBrush value) {
        this.brush = value;
    }

    @Override
    @StiSerializable(shortName="fn")
    public StiFont getFont() {
        return this.font;
    }

    @Override
    public void setFont(StiFont value) {
        this.font = value;
    }

    @Override
    @StiSerializable(isRef=true)
    public final IStiChart getChart() {
        return this.chart;
    }

    @Override
    public final void setChart(IStiChart value) {
        this.chart = value;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean isWordWrap() {
        return this.wordWrap;
    }

    @Override
    public void setWordWrap(boolean wordWrap) {
        this.wordWrap = wordWrap;
    }

    @Override
    @StiDefaulValue(value="0.0")
    @StiSerializable
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String toString() {
        return this.getServiceName();
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyBool("PreventIntersection", this.preventIntersection);
        jObject.AddPropertyBool("AllowApplyStyle", this.getAllowApplyStyle(), true);
        jObject.AddPropertyJObject("Conditions", this.getConditions().SaveToJsonObject(mode));
        jObject.AddPropertyBool("ShowZeros", this.getShowZeros());
        jObject.AddPropertyBool("ShowNulls", this.showNulls, true);
        jObject.AddPropertyBool("MarkerVisible", this.markerVisible);
        jObject.AddPropertyJObject("MarkerSize", StiJsonReportObjectHelper.Serialize.size((StiSize)this.markerSize));
        jObject.AddPropertyEnum("MarkerAlignment", (Enum)this.getMarkerAlignment(), (Enum)StiMarkerAlignment.Left);
        jObject.AddPropertyInt("Step", this.step);
        jObject.AddPropertyEnum("ValueType", (Enum)this.getValueType(), (Enum)StiSeriesLabelsValueType.Value);
        jObject.AddPropertyStringNullOfEmpty("ValueTypeSeparator", this.getValueTypeSeparator());
        jObject.AddPropertyEnum("LegendValueType", (Enum)this.getLegendValueType(), (Enum)StiSeriesLabelsValueType.Value);
        jObject.AddPropertyStringNullOfEmpty("TextBefore", this.textBefore);
        jObject.AddPropertyStringNullOfEmpty("TextAfter", this.textAfter);
        jObject.AddPropertyFloat("Angle", (double)this.getAngle(), 0.0);
        jObject.AddPropertyStringNullOfEmpty("Format", this.format);
        jObject.AddPropertyBool("Antialiasing", this.getAntialiasing(), true);
        jObject.AddPropertyBool("Visible", this.getVisible(), true);
        jObject.AddPropertyBool("DrawBorder", this.getDrawBorder(), true);
        jObject.AddPropertyBool("UseSeriesColor", this.getUseSeriesColor());
        jObject.AddPropertyStringNullOfEmpty("LabelColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getLabelColor(), (StiColorEnum)StiColorEnum.Black));
        jObject.AddPropertyStringNullOfEmpty("BorderColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getBorderColor(), (StiColorEnum)StiColorEnum.Black));
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getBrush()));
        jObject.AddPropertyStringNullOfEmpty("Font", StiJsonReportObjectHelper.Serialize.font((StiFont)this.getFont(), (String)"Arial", (float)7.0f));
        jObject.AddPropertyBool("WordWrap", this.wordWrap);
        jObject.AddPropertyInt("Width", this.width);
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("PreventIntersection")) {
                this.preventIntersection = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AllowApplyStyle")) {
                this.setAllowApplyStyle((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("Conditions")) {
                this.getConditions().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("ShowZeros")) {
                this.showZeros = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ShowNulls")) {
                this.showNulls = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("MarkerVisible")) {
                this.markerVisible = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("MarkerSize")) {
                this.markerSize = StiJsonReportObjectHelper.Deserialize.SizeD((JProperty)property);
                continue;
            }
            if (property.Name.equals("MarkerAlignment")) {
                this.setMarkerAlignment(StiMarkerAlignment.valueOf((String)property.Value));
                continue;
            }
            if (property.Name.equals("Step")) {
                this.step = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("ValueType")) {
                this.setValueType(StiSeriesLabelsValueType.valueOf((String)property.Value));
                continue;
            }
            if (property.Name.equals("ValueTypeSeparator")) {
                this.setValueTypeSeparator((String)property.Value);
                continue;
            }
            if (property.Name.equals("LegendValueType")) {
                this.setLegendValueType(StiSeriesLabelsValueType.valueOf((String)property.Value));
                continue;
            }
            if (property.Name.equals("TextBefore")) {
                this.textBefore = (String)property.Value;
                continue;
            }
            if (property.Name.equals("TextAfter")) {
                this.textAfter = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Angle")) {
                this.setAngle(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("Format")) {
                this.format = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Antialiasing")) {
                this.setAntialiasing((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("Visible")) {
                this.setVisible((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("DrawBorder")) {
                this.setDrawBorder((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("UseSeriesColor")) {
                this.setUseSeriesColor((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("LabelColor")) {
                this.setLabelColor(StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value)));
                continue;
            }
            if (property.Name.equals("BorderColor")) {
                this.setBorderColor(StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value)));
                continue;
            }
            if (property.Name.equals("Brush")) {
                this.setBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if (property.Name.equals("Font")) {
                this.setFont(StiJsonReportObjectHelper.Deserialize.Font((JProperty)property, (StiFont)this.getFont()));
                continue;
            }
            if (property.Name.equals("WordWrap")) {
                this.wordWrap = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("Width")) continue;
            this.width = (Integer)property.Value;
        }
    }

    public static IStiSeriesLabels LoadFromJsonObjectInternal(JSONObject jObject, StiChart chart) throws JSONException {
        String ident = (String)jObject.Properties().FirstOrDefault((String)"Ident").Value;
        List<Class<?>> classes = StiOptions.Services.getChartSerieLabels();
        Class<?> clazz = null;
        for (Class<?> claz : classes) {
            String name = claz.getName();
            if (!name.substring(name.lastIndexOf(46) + 1).equals(ident)) continue;
            clazz = claz;
        }
        StiSeriesLabels seriesLabels = null;
        if (clazz != null) {
            try {
                seriesLabels = (StiSeriesLabels)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            seriesLabels.setChart(chart);
            seriesLabels.LoadFromJsonObject(jObject);
        }
        return seriesLabels;
    }
}

