/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.series.stackedColumn;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.chart.enums.StiMarkerType;
import com.stimulsoft.report.chart.interfaces.marker.IStiLineMarker;
import com.stimulsoft.report.chart.interfaces.marker.IStiMarker;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedColumn.IStiStackedBaseLineSeries;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;
import com.stimulsoft.report.chart.view.areas.stackedColumn.StiStackedColumnArea;
import com.stimulsoft.report.chart.view.conditions.StiChartConditionsCollection;
import com.stimulsoft.report.chart.view.marker.StiLineMarker;
import com.stimulsoft.report.chart.view.marker.StiMarker;
import com.stimulsoft.report.chart.view.series.StiSeries;

public abstract class StiStackedBaseLineSeries
extends StiSeries
implements IStiStackedBaseLineSeries {
    private boolean showNulls = true;
    private IStiMarker marker = new StiMarker();
    private IStiLineMarker lineMarker = new StiLineMarker();
    private boolean lighting = true;
    private StiColor lineColor = StiColorEnum.MediumBlue.color();
    private float lineWidth = 2.0f;
    private StiPenStyle lineStyle = StiPenStyle.Solid;
    private StiColor lineColorNegative = StiColorEnum.Firebrick.color();
    private boolean allowApplyColorNegative = false;

    @Override
    public IStiStackedBaseLineSeries clone() {
        IStiSeries tempVar = super.clone();
        IStiStackedBaseLineSeries series = (IStiStackedBaseLineSeries)(tempVar instanceof IStiStackedBaseLineSeries ? tempVar : null);
        series.setLineStyle(this.getLineStyle());
        return series;
    }

    @Override
    @StiSerializable(need=false)
    public IStiTrendLine getTrendLine() {
        return super.getTrendLine();
    }

    @Override
    public void setTrendLine(IStiTrendLine value) {
        super.setTrendLine(value);
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="true")
    public final boolean getShowNulls() {
        return this.showNulls;
    }

    @Override
    public final void setShowNulls(boolean value) {
        this.showNulls = value;
    }

    @Deprecated
    public final boolean getShowMarker() {
        return this.getMarker().getVisible();
    }

    @Deprecated
    public final void setShowMarker(boolean value) {
        this.getMarker().setVisible(value);
    }

    @Deprecated
    public final StiColor getMarkerColor() {
        return StiBrush.ToColor((StiBrush)this.getMarker().getBrush());
    }

    @Deprecated
    public final void setMarkerColor(StiColor value) {
        this.getMarker().setBrush((StiBrush)new StiSolidBrush(value));
        this.getMarker().setBorderColor(StiColorUtils.dark((StiColor)value, (int)50));
    }

    @Deprecated
    public final float getMarkerSize() {
        return this.getMarker().getSize();
    }

    @Deprecated
    public final void setMarkerSize(float value) {
        this.getMarker().setSize(value);
    }

    @Deprecated
    public final StiMarkerType getMarkerType() {
        return ((StiMarker)this.marker).getType();
    }

    @Deprecated
    public final void setMarkerType(StiMarkerType value) {
        ((StiMarker)this.marker).setType(value);
    }

    @Override
    @StiSerializable
    public final IStiMarker getMarker() {
        return this.marker;
    }

    @Override
    public final void setMarker(IStiMarker value) {
        this.marker = value;
    }

    @Override
    @StiSerializable
    public IStiLineMarker getLineMarker() {
        return this.lineMarker;
    }

    @Override
    public void setLineMarker(IStiLineMarker value) {
        this.lineMarker = value;
    }

    @Override
    @StiSerializable(need=false)
    public StiChartConditionsCollection getConditions() {
        return super.getConditions();
    }

    @Override
    public void setConditions(StiChartConditionsCollection value) {
        super.setConditions(value);
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getLighting() {
        return this.lighting;
    }

    @Override
    public final void setLighting(boolean value) {
        this.lighting = value;
    }

    @Override
    @StiSerializable
    public final StiColor getLineColor() {
        return this.lineColor;
    }

    @Override
    public final void setLineColor(StiColor value) {
        this.lineColor = value;
    }

    @Override
    @StiDefaulValue(value="2.0")
    @StiSerializable
    public final float getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public final void setLineWidth(float value) {
        if (value > 0.0f) {
            this.lineWidth = value;
        }
    }

    @Override
    @StiDefaulValue(value="Solid")
    @StiSerializable
    public final StiPenStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public final void setLineStyle(StiPenStyle value) {
        this.lineStyle = value;
    }

    @StiSerializable
    public StiColor getLineColorNegative() {
        return this.lineColorNegative;
    }

    public void setLineColorNegative(StiColor value) {
        this.lineColorNegative = value;
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getAllowApplyColorNegative() {
        return this.allowApplyColorNegative;
    }

    public final void setAllowApplyColorNegative(boolean value) {
        this.allowApplyColorNegative = value;
    }

    @Override
    public Class GetDefaultAreaType() {
        return StiStackedColumnArea.class;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("TrendLine");
        jObject.RemoveProperty("Conditions");
        jObject.AddPropertyBool("ShowNulls", this.showNulls, true);
        jObject.AddPropertyJObject("Marker", this.marker.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("LineMarker", this.getLineMarker().SaveToJsonObject(mode));
        jObject.AddPropertyBool("Lighting", this.lighting, true);
        jObject.AddPropertyStringNullOfEmpty("LineColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.lineColor, (StiColorEnum)StiColorEnum.MediumBlue));
        jObject.AddPropertyFloat("LineWidth", (double)this.lineWidth, 2.0);
        jObject.AddPropertyEnum("LineStyle", (Enum)this.lineStyle, (Enum)StiPenStyle.Solid);
        jObject.AddPropertyStringNullOfEmpty("LineColorNegative", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getLineColorNegative(), (StiColorEnum)StiColorEnum.Firebrick));
        jObject.AddPropertyBool("AllowApplyColorNegative", this.allowApplyColorNegative);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("ShowNulls")) {
                this.showNulls = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Marker")) {
                this.marker.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("LineMarker")) {
                this.getLineMarker().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Lighting")) {
                this.lighting = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("LineColor")) {
                this.lineColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("LineWidth")) {
                this.lineWidth = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("LineStyle")) {
                this.lineStyle = StiPenStyle.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("LineColorNegative")) {
                this.setLineColorNegative(StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value)));
                continue;
            }
            if (!property.Name.equals("AllowApplyColorNegative")) continue;
            this.allowApplyColorNegative = (Boolean)property.Value;
        }
    }
}

