/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.series.pie;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.series.pie.StiPie3dSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.pie.StiCenterPie3dLabelsCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.series.pie.StiPie3dMainSideSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.series.pie.StiPie3dSidesSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.series.pie.IStiPie3dSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.pie.IStiPieSeriesLabels;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import com.stimulsoft.report.chart.view.seriesLabels.StiNoneLabels;
import java.util.ArrayList;

public class StiPie3dSlice {
    private StiRectangle rectPieSlilce = new StiRectangle();
    private float pieHeight;
    private StiBrush seriesBrush;
    private StiColor borderColor = new StiColor();
    private IStiPie3dSeries series;
    private IStiArea area;
    private int colorCount;
    private float startAngle;
    private float sweepAngle;
    private double value;
    private String argumentText;
    private String tag;
    private int index;
    private int colorIndex;
    private StiPoint textPosition = new StiPoint();
    private ArrayList<StiSeriesElementGeom> childGeoms;
    private StiSeriesInteractionData interaction;
    private boolean startSideExists = true;
    private boolean endSideExists = true;

    public final int getColorCount() {
        return this.colorCount;
    }

    private void setColorCount(int value) {
        this.colorCount = value;
    }

    public final float getStartAngle() {
        return this.startAngle;
    }

    private void setStartAngle(float value) {
        this.startAngle = value;
    }

    public final float getSweepAngle() {
        return this.sweepAngle;
    }

    private void setSweepAngle(float value) {
        this.sweepAngle = value;
    }

    public final float getEndAngle() {
        return (this.getStartAngle() + this.getSweepAngle()) % 360.0f;
    }

    public final double getValue() {
        return this.value;
    }

    private void setValue(double value) {
        this.value = value;
    }

    public final String getArgumentText() {
        return this.argumentText;
    }

    private void setArgumentText(String value) {
        this.argumentText = value;
    }

    public final String getTag() {
        return this.tag;
    }

    private void setTag(String value) {
        this.tag = value;
    }

    public final int getIndex() {
        return this.index;
    }

    private void setIndex(int value) {
        this.index = value;
    }

    public final int getColorIndex() {
        return this.colorIndex;
    }

    private void setColorIndex(int value) {
        this.colorIndex = value;
    }

    public final StiPoint getTextPosition() {
        return this.textPosition;
    }

    private void setTextPosition(StiPoint value) {
        this.textPosition = value;
    }

    public final ArrayList<StiSeriesElementGeom> getChildGeoms() {
        return this.childGeoms;
    }

    private void setChildGeoms(ArrayList<StiSeriesElementGeom> value) {
        this.childGeoms = value;
    }

    public final StiSeriesInteractionData getInteraction() {
        return this.interaction;
    }

    private void setInteraction(StiSeriesInteractionData value) {
        this.interaction = value;
    }

    public final boolean getStartSideExists() {
        return this.startSideExists;
    }

    private void setStartSideExists(boolean value) {
        this.startSideExists = value;
    }

    public final boolean getEndSideExists() {
        return this.endSideExists;
    }

    private void setEndSideExists(boolean value) {
        this.endSideExists = value;
    }

    public final void drawLabels(StiAreaGeom areaGeom, StiContext context) {
        IStiPieSeriesLabels seriesLabels = ((StiPie3dSeriesCoreXF)this.series.getCore()).GetPieSeriesLabels();
        if (seriesLabels != null && !(seriesLabels instanceof StiNoneLabels) && seriesLabels.getVisible() && seriesLabels.getCore() instanceof StiCenterPie3dLabelsCoreXF) {
            StiCenterPie3dLabelsCoreXF core = (StiCenterPie3dLabelsCoreXF)seriesLabels.getCore();
            StiSeriesLabelsGeom geom = core.renderLabel(this.series, context, this);
            areaGeom.CreateChildGeoms();
            areaGeom.getChildGeoms().add(geom);
        }
    }

    public final void drawTopPieSliceGeom(StiAreaGeom areaGeom) {
        StiPie3dMainSideSeriesElementGeom geom = new StiPie3dMainSideSeriesElementGeom(this, areaGeom, this.getValue(), this.getIndex(), this.getColorCount(), this.series, this.rectPieSlilce, this.borderColor, this.seriesBrush, this.getStartAngle(), this.getSweepAngle());
        this.getChildGeoms().add(geom);
        areaGeom.CreateChildGeoms();
        areaGeom.getChildGeoms().add(geom);
    }

    public final void drawBottomPieSliceGeom(StiAreaGeom areaGeom) {
        StiRectangle bottomRectPieSlice = new StiRectangle(this.rectPieSlilce.x, this.rectPieSlilce.y + (double)this.pieHeight, this.rectPieSlilce.width, this.rectPieSlilce.height);
        StiPie3dMainSideSeriesElementGeom geom = new StiPie3dMainSideSeriesElementGeom(this, areaGeom, this.getValue(), this.getIndex(), this.getColorCount(), this.series, bottomRectPieSlice, this.borderColor, this.seriesBrush, this.getStartAngle(), this.getSweepAngle());
        areaGeom.CreateChildGeoms();
        areaGeom.getChildGeoms().add(geom);
    }

    public final void drawSides(StiAreaGeom areaGeom) {
        StiPie3dSidesSeriesElementGeom geom = new StiPie3dSidesSeriesElementGeom(this, areaGeom, this.getValue(), this.getColorIndex(), this.getColorCount(), this.series, this.rectPieSlilce, this.borderColor, this.seriesBrush, this.getStartAngle(), this.getSweepAngle(), this.pieHeight, this.getStartSideExists(), this.getEndSideExists());
        this.getChildGeoms().add(geom);
        this.setTextPosition(geom.getTextPosition());
        areaGeom.CreateChildGeoms();
        areaGeom.getChildGeoms().add(geom);
    }

    public final void initTextPosition(StiAreaGeom areaGeom) {
        StiPie3dSidesSeriesElementGeom geom = new StiPie3dSidesSeriesElementGeom(this, areaGeom, this.getValue(), this.getColorIndex(), this.getColorCount(), this.series, this.rectPieSlilce, this.borderColor, this.seriesBrush, this.getStartAngle(), this.getSweepAngle(), this.pieHeight, this.getStartSideExists(), this.getEndSideExists());
        this.setTextPosition(geom.getTextPosition());
    }

    public StiPie3dSlice clone() {
        return new StiPie3dSlice(this.area, this.value, this.argumentText, this.tag, this.index, this.series, this.rectPieSlilce, this.pieHeight, this.startAngle, this.sweepAngle, this.seriesBrush, this.borderColor, this.colorIndex, this.colorCount);
    }

    public final StiPie3dSlice[] split(float splitAngle) {
        if (this.getStartAngle() == splitAngle || this.getEndAngle() == splitAngle) {
            return new StiPie3dSlice[]{this.clone()};
        }
        float actualStartAngle = this.getStartAngle();
        float newSweepAngle = (splitAngle - actualStartAngle + 360.0f) % 360.0f;
        StiPie3dSlice pieSlice1 = this.getNewModified(actualStartAngle, newSweepAngle);
        pieSlice1.setStartSideExists(true);
        pieSlice1.setEndSideExists(false);
        newSweepAngle = this.getEndAngle() - splitAngle;
        StiPie3dSlice pieSlice2 = this.getNewModified(splitAngle, newSweepAngle);
        pieSlice2.setStartSideExists(false);
        pieSlice2.setEndSideExists(true);
        return new StiPie3dSlice[]{pieSlice1, pieSlice2};
    }

    private StiPie3dSlice getNewModified(float startAngle, float sweepAngle) {
        StiPie3dSlice slice = new StiPie3dSlice(this.area, this.getValue(), this.getArgumentText(), this.getTag(), this.getIndex(), this.series, this.rectPieSlilce, this.pieHeight, startAngle, sweepAngle, this.seriesBrush, this.borderColor, this.getColorIndex(), this.getColorCount());
        slice.setTextPosition(this.getTextPosition());
        return slice;
    }

    public StiPie3dSlice(IStiArea area, Double value, String argumentText, String tag, int index, IStiPie3dSeries series, StiRectangle rectPieSlilce, float pieHeight, float startAngle, float sweepAngle, StiBrush seriesBrush, StiColor borderColor, int colorIndex, int colorCount) {
        this.setValue(value == null ? 0.0 : value);
        this.setArgumentText(argumentText);
        this.setTag(tag);
        this.setIndex(index);
        this.setColorIndex(colorIndex);
        this.setColorCount(colorCount);
        this.area = area;
        this.series = series;
        this.rectPieSlilce = rectPieSlilce;
        this.pieHeight = pieHeight;
        this.setStartAngle(startAngle);
        this.setSweepAngle(sweepAngle);
        this.seriesBrush = seriesBrush;
        this.borderColor = borderColor;
        this.setChildGeoms(new ArrayList<StiSeriesElementGeom>());
        if (series.getCore().getInteraction() != null) {
            this.setInteraction(new StiSeriesInteractionData(area, series, this.getColorIndex()));
        }
    }
}

