/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.trendLines;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiBaseLineSeriesGeom;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;

public class StiTrendLineGeom
extends StiCellGeom {
    private final StiPoint pointStart;
    private final StiPoint pointEnd;
    private final IStiTrendLine trendLine;

    public StiTrendLineGeom(StiPoint pointStart, StiPoint pointEnd, IStiTrendLine trendLine) {
        super(StiBaseLineSeriesGeom.GetClientRectangle(StiTrendLineGeom.GetArray(pointStart, pointEnd), trendLine.getLineWidth()));
        this.pointStart = pointStart;
        this.pointEnd = pointEnd;
        this.trendLine = trendLine;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        IStiTrendLine line = this.trendLine;
        StiColor lineColor = this.trendLine.getLineColor();
        float lineWidth = this.trendLine.getLineWidth();
        StiPenStyle style = this.trendLine.getLineStyle();
        boolean showShadow = this.trendLine.getShowShadow();
        double scaledLineWidth = (double)lineWidth * context.Options.zoom;
        context.PushSmoothingModeToAntiAlias();
        if (showShadow) {
            StiPenGeom penShadow = new StiPenGeom(StiColor.fromArgb((int)50, (int)0, (int)0, (int)0), scaledLineWidth + 0.5 * context.Options.zoom);
            penShadow.setPenStyle(style);
            context.PushTranslateTransform(scaledLineWidth, scaledLineWidth);
            StiNullableDrawing.DrawLines(context, penShadow, StiTrendLineGeom.GetArray(this.pointStart, this.pointEnd));
            context.PopTransform();
        }
        StiPenGeom pen = new StiPenGeom(lineColor, (double)lineWidth * context.Options.zoom);
        pen.setPenStyle(style);
        context.DrawLine(pen, this.pointStart.x, this.pointStart.y, this.pointEnd.x, this.pointEnd.y);
        context.PopSmoothingMode();
    }

    private static StiPoint[] GetArray(StiPoint pointStart, StiPoint pointEnd) {
        StiPoint[] points = new StiPoint[]{pointStart, pointEnd};
        return points;
    }
}

