/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.stackedColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.enums.StiPenLineCap;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiPointHelper;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiBaseLineSeriesGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedColumn.IStiStackedBaseLineSeries;
import com.stimulsoft.report.chart.view.series.stackedColumn.StiStackedLineSeries;
import java.util.ArrayList;

public class StiStackedLineSeriesGeom
extends StiBaseLineSeriesGeom {
    @Override
    public boolean Contains(double x, double y) {
        if (this.getInvisible()) {
            return false;
        }
        for (int pointIndex = 0; pointIndex < this.getPoints().length - 1; ++pointIndex) {
            boolean result;
            StiPoint point1 = this.getPoints()[pointIndex];
            StiPoint point2 = this.getPoints()[pointIndex + 1];
            if (point1 == null || point2 == null || !(result = StiPointHelper.IsLineContainsPoint(point1.getValue(), point2.getValue(), StiMouseOverHelper.MouseOverLineDistance, new StiPoint(x, y)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        IStiSeries tempVar = this.getSeries();
        IStiStackedBaseLineSeries lineSeries = (IStiStackedBaseLineSeries)(tempVar instanceof IStiStackedBaseLineSeries ? tempVar : null);
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (this.getPoints().length == 0) {
            return;
        }
        if (this.getPoints().length > 1) {
            context.PushSmoothingModeToAntiAlias();
            StiPenStyle dashStyle = lineSeries.getLineStyle();
            float scaledLineWidth = lineSeries.getLineWidth();
            StiPenGeom pen = new StiPenGeom(lineSeries.getLineColor(), (double)scaledLineWidth);
            pen.setPenStyle(dashStyle);
            boolean lighting = lineSeries.getLighting();
            if (lineSeries.getShowShadow()) {
                StiPenGeom penShadow = new StiPenGeom(StiColor.fromArgb((int)50, (int)0, (int)0, (int)0), (double)(scaledLineWidth + 0.5f));
                penShadow.setPenStyle(dashStyle);
                context.PushTranslateTransform((double)scaledLineWidth, (double)scaledLineWidth);
                StiNullableDrawing.DrawLines(context, penShadow, this.getPoints(), chart.isAnimation);
                context.PopTransform();
            }
            if (this.getSeries().getCore().getIsMouseOver()) {
                float lineWidth = lineSeries.getLineWidth();
                double zoom = context.Options.zoom;
                float pointSize = 11.0f + lineWidth;
                for (StiPoint point : this.getPoints()) {
                    if (point == null) continue;
                    StiRectangle pointRect = new StiRectangle(point.getValue().x - (double)(pointSize / 2.0f) * zoom, point.getValue().y - (double)(pointSize / 2.0f) * zoom, (double)pointSize * zoom, (double)pointSize * zoom);
                    context.FillEllipse((Object)StiMouseOverHelper.GetLineMouseOverColor(), pointRect, null);
                }
                StiPenGeom penMouseOver = new StiPenGeom(StiMouseOverHelper.GetLineMouseOverColor(), (double)(4.0f + lineWidth));
                penMouseOver.setStartCap(StiPenLineCap.Round);
                penMouseOver.setEndCap(StiPenLineCap.Round);
                StiNullableDrawing.DrawLines(context, penMouseOver, this.getPoints());
            }
            StiColor coreLineColor = ((StiStackedLineSeries)this.getSeries()).getLineColor();
            if (((StiStackedLineSeries)this.getSeries()).getAllowApplyColorNegative()) {
                StiColor coreLineColorNegative = ((StiStackedLineSeries)this.getSeries()).getLineColorNegative();
                StiPenGeom penNegative = new StiPenGeom(coreLineColorNegative, (double)scaledLineWidth);
                penNegative.setPenStyle(dashStyle);
                IStiArea tempVar2 = this.getSeries().getChart().getArea();
                IStiAxisArea axisArea = (IStiAxisArea)(tempVar2 instanceof IStiAxisArea ? tempVar2 : null);
                double posY = axisArea.getAxisCore().GetDividerY();
                ArrayList<StiPoint> pointsNegative = new ArrayList<StiPoint>();
                ArrayList<StiPoint> pointsPositive = new ArrayList<StiPoint>();
                for (int index = 0; index < this.getPoints().length; ++index) {
                    StiPenGeom penLight;
                    StiPoint point0;
                    StiPoint pointNext;
                    StiPoint point = this.getPoints()[index].clone();
                    StiPoint stiPoint = pointNext = index != this.getPoints().length - 1 ? this.getPoints()[index + 1] : null;
                    if (point.getValue().y > posY) {
                        pointsNegative.add(point);
                        if (pointNext != null && !(pointNext.getValue().y < posY) && (pointNext.getValue().y != posY || index + 2 >= this.getPoints().length || !(this.getPoints()[index + 2].getValue().y <= posY))) continue;
                        if (pointNext != null) {
                            point0 = this.GetPointCross(point, this.getPoints()[index + 1], posY);
                            pointsNegative.add(point0);
                            if (pointNext.getValue().y == posY && index + 2 < this.getPoints().length && this.getPoints()[index + 2].getValue().y <= posY) {
                                pointsNegative.add(this.getPoints()[index + 2]);
                            }
                            pointsPositive.add(point0);
                        }
                        this.DrawLine(context, penNegative, pointsNegative);
                        if ((double)scaledLineWidth >= 2.0 * context.Options.zoom && lighting) {
                            double step = 0.5 * context.Options.zoom;
                            context.PushTranslateTransform(-step, -step);
                            penLight = new StiPenGeom(StiColorUtils.light((StiColor)coreLineColorNegative, (int)70), (double)scaledLineWidth);
                            penLight.setPenStyle(dashStyle);
                            this.DrawLine(context, penLight, pointsNegative);
                            context.PopTransform();
                        }
                        pointsNegative.clear();
                        continue;
                    }
                    pointsPositive.add(point);
                    if (pointNext != null && !(pointNext.getValue().y > posY)) continue;
                    if (pointNext != null) {
                        point0 = this.GetPointCross(point, this.getPoints()[index + 1], posY);
                        pointsNegative.add(point0);
                        pointsPositive.add(point0);
                        pointsPositive.add(pointNext);
                    }
                    this.DrawLine(context, pen, pointsPositive);
                    if ((double)scaledLineWidth >= 2.0 * context.Options.zoom && lighting) {
                        double step = 0.5 * context.Options.zoom;
                        context.PushTranslateTransform(-step, -step);
                        penLight = new StiPenGeom(StiColorUtils.light((StiColor)coreLineColor, (int)70), (double)scaledLineWidth);
                        penLight.setPenStyle(dashStyle);
                        this.DrawLine(context, penLight, pointsPositive);
                        context.PopTransform();
                    }
                    pointsPositive.clear();
                }
            } else {
                StiNullableDrawing.DrawLines(context, pen, this.getPoints(), chart.isAnimation);
                if ((double)scaledLineWidth >= 2.0 * context.Options.zoom && lineSeries.getLighting()) {
                    double step = 0.5 * context.Options.zoom;
                    context.PushTranslateTransform(-step, -step);
                    StiPenGeom penLight = new StiPenGeom(StiColorUtils.light((StiColor)coreLineColor, (int)70), (double)scaledLineWidth);
                    penLight.setPenStyle(dashStyle);
                    StiNullableDrawing.DrawLines(context, penLight, this.getPoints(), chart.isAnimation);
                    context.PopTransform();
                }
            }
            context.PopSmoothingMode();
        }
    }

    private StiPoint GetPointCross(StiPoint point1, StiPoint point2, double posY) {
        double y1 = point1.getValue().y;
        double x1 = point1.getValue().x;
        double y2 = point2.getValue().y;
        double x2 = point2.getValue().x;
        double x0 = Math.tan(Math.atan((x2 - x1) / (y1 - y2))) * (y1 - posY) + x1;
        return new StiPoint(x0, posY);
    }

    private void DrawLine(StiContext context, StiPenGeom pen, ArrayList<StiPoint> listPoints) {
        StiChart chart = (StiChart)this.getSeries().getChart();
        StiPoint[] points = new StiPoint[listPoints.size()];
        points = (StiPoint[])listPoints.clone();
        StiNullableDrawing.DrawLines(context, pen, points, chart.isAnimation);
    }

    public StiStackedLineSeriesGeom(StiAreaGeom areaGeom, StiPoint[] pointsStart, StiPoint[] points, IStiSeries series) {
        super(areaGeom, pointsStart, points, series);
    }
}

