/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.clusteredColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.animation.StiPointsAnimation;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLinesSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiSteppedLineSeriesGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiSteppedAreaSeries;
import java.util.ArrayList;
import java.util.List;

public class StiSteppedAreaSeriesGeom
extends StiSteppedLineSeriesGeom {
    @Override
    public boolean Contains(double x, double y) {
        IStiArea tempVar = this.getSeries().getChart().getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        double posY = axisArea.getAxisCore().GetDividerY();
        if (this.getInvisible()) {
            return false;
        }
        int pointIndex = 0;
        for (StiPoint point : this.getPoints()) {
            StiRectangle pointRect;
            StiPoint nextPoint = this.getPoints()[pointIndex + 1];
            if (point == null || nextPoint == null) continue;
            StiRectangle stiRectangle = pointRect = posY > point.getValue().y ? new StiRectangle(point.getValue().x, point.getValue().y, nextPoint.getValue().x - point.getValue().x, posY - point.getValue().y) : new StiRectangle(point.getValue().x, posY, nextPoint.getValue().x - point.getValue().x, point.getValue().y - posY);
            if (pointRect.contains(x, y)) {
                return true;
            }
            if (++pointIndex == this.getPoints().length - 1) break;
        }
        return false;
    }

    @Override
    public void Draw(StiContext context) {
        List<StiPoint[]> newPointsFrom;
        IStiSteppedAreaSeries areaSeries = (IStiSteppedAreaSeries)this.getSeries();
        StiChart chart = (StiChart)this.getSeries().getChart();
        IStiAxisArea axisArea = (IStiAxisArea)this.getSeries().getChart().getArea();
        double posY = axisArea.getAxisCore().GetDividerY();
        List<StiPoint[]> newPoints = this.GetSteppedPoints(this.getPoints());
        List<StiPoint[]> list = newPointsFrom = this.getPointsFrom() != null ? this.GetSteppedPoints(this.getPointsFrom()) : null;
        if (chart.isAnimationChangingValues() && newPoints.size() > 0) {
            StiPoint[] curPoints = newPoints.get(0);
            StiPoint[] curPointsFrom = newPointsFrom.get(0);
            ArrayList<Object> path = new ArrayList<Object>();
            StiLineSegmentGeom lineSegment1 = new StiLineSegmentGeom(new StiPoint(curPoints[0].x, posY), curPoints[0]);
            StiLinesSegmentGeom lineSegments = new StiLinesSegmentGeom(curPoints);
            StiLineSegmentGeom lineSegment2 = new StiLineSegmentGeom(curPoints[curPoints.length - 1], new StiPoint(curPoints[curPoints.length - 1].x, posY));
            path.add(lineSegment1);
            path.add(lineSegments);
            path.add(lineSegment2);
            lineSegment1.setAnimation((StiAnimation)new StiPointsAnimation(new StiPoint[]{new StiPoint(curPointsFrom[0].x, posY), curPointsFrom[0]}, StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement));
            lineSegments.setAnimation((StiAnimation)new StiPointsAnimation(curPointsFrom, StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement));
            lineSegment2.setAnimation((StiAnimation)new StiPointsAnimation(new StiPoint[]{curPointsFrom[curPointsFrom.length - 1], new StiPoint(curPointsFrom[curPointsFrom.length - 1].x, posY)}, StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement));
            context.FillDrawAnimationPath((Object)areaSeries.getBrush(), null, path, StiPathGeom.GetBoundsState, null, null, null);
        } else {
            for (StiPoint[] newPoints2 : newPoints) {
                ArrayList<Object> path = new ArrayList<Object>();
                path.add(new StiLineSegmentGeom(new StiPoint(newPoints2[0].x, posY), newPoints2[0]));
                path.add(new StiLinesSegmentGeom(newPoints2));
                path.add(new StiLineSegmentGeom(newPoints2[newPoints2.length - 1], new StiPoint(newPoints2[newPoints2.length - 1].x, posY)));
                if (areaSeries.getBrush() != null) {
                    if (chart.isAnimation) {
                        StiOpacityAnimation animation = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement);
                        context.FillDrawAnimationPath((Object)areaSeries.getBrush(), null, path, StiPathGeom.GetBoundsState, null, (StiAnimation)animation, null);
                    } else {
                        context.FillPath((Object)areaSeries.getBrush(), path, StiPathGeom.GetBoundsState, null);
                    }
                }
                if (areaSeries.getAllowApplyBrushNegative() && areaSeries.getBrushNegative() != null) {
                    if (chart.isAnimation) {
                        StiOpacityAnimation animation = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement);
                        context.FillDrawAnimationPath((Object)areaSeries.getBrushNegative(), null, path, StiPathGeom.GetBoundsState, null, (StiAnimation)animation, null);
                    } else {
                        double width = axisArea.getAxisCore().getScrollRangeX() * axisArea.getAxisCore().getScrollDpiX();
                        double height = axisArea.getAxisCore().getScrollRangeY() * axisArea.getAxisCore().getScrollDpiY() - posY;
                        StiRectangle clipRect = new StiRectangle(0.0, posY, width, height);
                        context.PushClip(clipRect);
                        context.FillPath((Object)areaSeries.getBrushNegative(), path, StiPathGeom.GetBoundsState, null);
                        context.PopClip();
                    }
                }
                if (!this.getIsMouseOver() && !this.getSeries().getCore().getIsMouseOver()) continue;
                context.FillPath((Object)StiMouseOverHelper.GetMouseOverColor(), path, StiPathGeom.GetBoundsState, null);
            }
        }
    }

    public StiSteppedAreaSeriesGeom(StiAreaGeom areaGeom, StiPoint[] pointsFrom, StiPoint[] points, IStiSeries series) {
        super(areaGeom, pointsFrom, points, series);
    }

    private List<StiPoint[]> GetSteppedPoints(StiPoint[] currentPoints) {
        IStiSteppedAreaSeries areaSeries = (IStiSteppedAreaSeries)(this.getSeries() instanceof IStiSteppedAreaSeries ? this.getSeries() : null);
        IStiArea tempVar2 = this.getSeries().getChart().getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar2 instanceof IStiAxisArea ? tempVar2 : null);
        double posY = axisArea.getAxisCore().GetDividerY();
        ArrayList<StiPoint> list = new ArrayList<StiPoint>();
        float distX = (float)((IStiAxisArea)this.getSeries().getChart().getArea()).getXAxis().getInfo().Dpi / 2.0f;
        for (int index = 0; index < this.getPoints().length - 1; ++index) {
            StiPoint point = this.getPoints()[index];
            StiPoint nextPoint = this.getPoints()[index + 1];
            if (point != null && nextPoint != null) {
                if (areaSeries.getPointAtCenter()) {
                    point = new StiPoint(point.getValue().x - (double)distX, point.getValue().y);
                    nextPoint = new StiPoint(nextPoint.getValue().x - (double)distX, nextPoint.getValue().y);
                }
                list.add(point);
                list.add(new StiPoint(nextPoint.getValue().x, point.getValue().y));
                continue;
            }
            list.add(null);
            list.add(null);
        }
        StiPoint pos = this.getPoints()[this.getPoints().length - 1];
        if (pos != null) {
            if (areaSeries.getPointAtCenter()) {
                pos = new StiPoint(pos.getValue().x - (double)distX, pos.getValue().y);
                list.add(pos);
                pos = new StiPoint(pos.getValue().x + (double)(distX * 2.0f), pos.getValue().y);
                list.add(pos);
            } else {
                list.add(pos);
            }
        } else {
            list.add(null);
        }
        ArrayList newPoints = new ArrayList();
        newPoints = (ArrayList)list.clone();
        return StiNullableDrawing.GetPointsList(newPoints);
    }
}

