/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.axis.scrollBars;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.interfaces.axis.IStiYAxis;

public class StiVertScrollBarGeom
extends StiCellGeom {
    private final IStiYAxis axis;

    @Override
    public void InvokeMouseDown(StiInteractionOptions options) {
        if (!this.getAxis().getInteraction().getRangeScrollEnabled()) {
            return;
        }
        StiAreaCoreXF tempVar = this.getAxis().getArea().getCore();
        StiAxisAreaCoreXF axisCore = (StiAxisAreaCoreXF)(tempVar instanceof StiAxisAreaCoreXF ? tempVar : null);
        axisCore.setBlockScrollValueY(true);
        double buttonSize = this.getClientRectangle().width;
        double mousePointY = options.getMousePoint().y - buttonSize;
        double height = this.getClientRectangle().height - buttonSize * 2.0;
        axisCore.setScrollValueY(mousePointY / height * axisCore.getScrollRangeY());
        if (axisCore.getScrollValueY() < 0.0) {
            axisCore.setScrollValueY(0.0);
        }
        if (axisCore.getScrollValueY() >= axisCore.getScrollRangeY() - axisCore.getScrollViewY()) {
            axisCore.setScrollValueY(axisCore.getScrollRangeY() - axisCore.getScrollViewY());
        }
        options.setUpdateContext(true);
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        StiPenGeom penLine = new StiPenGeom(this.getAxis().getLineColor());
        context.DrawRectangle(penLine, rect.x, rect.y, rect.width, rect.height);
    }

    public final IStiYAxis getAxis() {
        return this.axis;
    }

    public StiVertScrollBarGeom(IStiYAxis axis, StiRectangle clientRectangle) {
        super(clientRectangle);
        this.axis = axis;
    }
}

