/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.axis;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiArcSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiDateUtil;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.StiXAxisCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripPositionXF;
import com.stimulsoft.report.chart.enums.StiArrowStyle;
import com.stimulsoft.report.chart.enums.StiShowXAxis;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.axis.StiAxisLabelGeom;
import com.stimulsoft.report.chart.geoms.axis.StiXAxisViewGeom;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxisTicks;
import com.stimulsoft.report.chart.interfaces.axis.IStiXAxis;
import com.stimulsoft.report.chart.view.axis.StiXBottomAxis;
import java.util.ArrayList;
import java.util.Date;

public class StiXAxisGeom
extends StiCellGeom {
    private final IStiXAxis axis;
    private final boolean isCenterAxis;
    private StiXAxisViewGeom view;

    public final IStiXAxis getAxis() {
        return this.axis;
    }

    public final boolean getIsCenterAxis() {
        return this.isCenterAxis;
    }

    public final StiXAxisViewGeom getView() {
        return this.view;
    }

    public final void setView(StiXAxisViewGeom value) {
        this.view = value;
    }

    protected final void DrawArrow(StiContext context, StiRectangle rect) {
        double zoom = context.Options.zoom;
        StiPenGeom penLine = new StiPenGeom(this.getAxis().getLineColor(), (double)this.getAxis().getLineWidth());
        StiPenGeom penArrow = new StiPenGeom(this.getAxis().getLineColor());
        StiSolidBrush brushLine = new StiSolidBrush(this.getAxis().getLineColor());
        double posY = 0.0;
        if (((StiXAxisCoreXF)this.getAxis().getCore()).getIsBottomSide()) {
            posY = rect.y;
        }
        if (((StiXAxisCoreXF)this.getAxis().getCore()).getIsTopSide()) {
            posY = rect.getBottom();
        }
        StiPoint arrowStart = StiPoint.getEmpty();
        arrowStart = this.getAxis().getArea().getReverseHor() ? new StiPoint(rect.x, posY) : new StiPoint(rect.getRight(), posY);
        switch (this.getAxis().getArrowStyle()) {
            case Triangle: {
                context.DrawLine(penLine, arrowStart.x, arrowStart.y, arrowStart.x + (double)this.getAxis().getCore().getArrowHeight() * zoom, arrowStart.y);
                context.PushSmoothingModeToAntiAlias();
                ArrayList<StiLineSegmentGeom> path = new ArrayList<StiLineSegmentGeom>();
                path.add(new StiLineSegmentGeom(arrowStart.x + (double)this.getAxis().getCore().getArrowHeight() * zoom, arrowStart.y - (double)this.getAxis().getCore().getArrowWidth() * zoom, arrowStart.x + (double)(this.getAxis().getCore().getArrowHeight() * 4.0f) * zoom, arrowStart.y));
                path.add(new StiLineSegmentGeom(arrowStart.x + (double)(this.getAxis().getCore().getArrowHeight() * 4.0f) * zoom, arrowStart.y, arrowStart.x + (double)this.getAxis().getCore().getArrowHeight() * zoom, arrowStart.y + (double)this.getAxis().getCore().getArrowWidth() * zoom));
                context.FillPath((Object)brushLine, path, (Object)rect, null);
                context.PopSmoothingMode();
                break;
            }
            case Lines: {
                context.DrawLine(penLine, arrowStart.x, arrowStart.y, arrowStart.x + (double)(this.getAxis().getCore().getArrowHeight() * 4.0f) * zoom, arrowStart.y);
                context.PushSmoothingModeToAntiAlias();
                context.DrawLine(penArrow, arrowStart.x + (double)this.getAxis().getCore().getArrowHeight() * zoom, arrowStart.y - (double)this.getAxis().getCore().getArrowWidth() * zoom, arrowStart.x + (double)(this.getAxis().getCore().getArrowHeight() * 4.0f) * zoom, arrowStart.y);
                context.DrawLine(penArrow, arrowStart.x + (double)(this.getAxis().getCore().getArrowHeight() * 4.0f) * zoom, arrowStart.y, arrowStart.x + (double)this.getAxis().getCore().getArrowHeight() * zoom, arrowStart.y + (double)this.getAxis().getCore().getArrowWidth() * zoom);
                context.PopSmoothingMode();
                break;
            }
            case Circle: {
                double armCircle = (double)this.getAxis().getCore().getArrowHeight() * zoom;
                context.DrawLine(penLine, arrowStart.x, arrowStart.y, arrowStart.x + armCircle * 2.0, arrowStart.y);
                StiPoint pointCircle = new StiPoint(arrowStart.x + armCircle * 2.0, arrowStart.y - armCircle / 2.0);
                context.PushSmoothingModeToAntiAlias();
                StiRectangle rectCircle = new StiRectangle(pointCircle.x, pointCircle.y, armCircle, armCircle);
                context.DrawEllipse(penLine, rectCircle);
                context.PopSmoothingMode();
                break;
            }
            case Arc: 
            case ArcAndCircle: {
                StiPoint pointArc;
                double armArc = (double)this.getAxis().getCore().getArrowHeight() * zoom;
                context.DrawLine(penLine, arrowStart.x, arrowStart.y, arrowStart.x + armArc * 2.0, arrowStart.y);
                context.PushSmoothingModeToAntiAlias();
                ArrayList<StiArcSegmentGeom> pathArc = new ArrayList<StiArcSegmentGeom>();
                if (this.getAxis().getArea().getReverseHor()) {
                    pointArc = new StiPoint(arrowStart.x + armArc * 3.0, arrowStart.y + armArc / 2.0);
                    StiRectangle rectArc = new StiRectangle(pointArc.x, pointArc.y, Math.abs(armArc), Math.abs(armArc));
                    if (this.getAxis().getArrowStyle() == StiArrowStyle.ArcAndCircle) {
                        rectArc.x -= zoom;
                        rectArc.inflate(Double.valueOf(1.0), Double.valueOf(1.0));
                    }
                    pathArc.add(new StiArcSegmentGeom(rectArc, 270.0f, 180.0f));
                } else {
                    pointArc = new StiPoint(arrowStart.x + armArc * 2.0, arrowStart.y - armArc / 2.0);
                    StiRectangle rectArc = new StiRectangle(pointArc.x, pointArc.y, Math.abs(armArc), Math.abs(armArc));
                    if (this.getAxis().getArrowStyle() == StiArrowStyle.ArcAndCircle) {
                        rectArc.x += zoom;
                        rectArc.inflate(Double.valueOf(1.0), Double.valueOf(1.0));
                    }
                    pathArc.add(new StiArcSegmentGeom(rectArc, 90.0f, 180.0f));
                }
                context.DrawPath(penLine, pathArc, StiPathGeom.GetBoundsState);
                if (this.getAxis().getArrowStyle() == StiArrowStyle.ArcAndCircle) {
                    double armAC = (double)this.getAxis().getCore().getArrowHeight() * zoom;
                    StiPoint pointAC = new StiPoint(arrowStart.x + armAC * 2.0 + zoom, arrowStart.y - armAC / 2.0);
                    StiRectangle rectAC = new StiRectangle(pointAC.x, pointAC.y, armAC, armAC);
                    if (this.getAxis().getArea().getReverseHor()) {
                        rectAC.inflate(Double.valueOf(0.5 * zoom), Double.valueOf(0.5 * zoom));
                        rectAC.x -= zoom * 3.0;
                    } else {
                        rectAC.inflate(Double.valueOf(-0.5 * zoom), Double.valueOf(-0.5 * zoom));
                        rectAC.x += zoom;
                    }
                    context.FillEllipse((Object)brushLine, rectAC, null);
                }
                context.PopSmoothingMode();
            }
        }
    }

    private void DrawAxisLine(StiContext context, StiRectangle rect) {
        double posY = 0.0;
        if (((StiXAxisCoreXF)this.getAxis().getCore()).getIsTopSide()) {
            posY = rect.getBottom();
        }
        if (((StiXAxisCoreXF)this.getAxis().getCore()).getIsBottomSide()) {
            posY = rect.getTop();
        }
        StiPenGeom penLine = new StiPenGeom(this.getAxis().getLineColor(), (double)this.getAxis().getLineWidth());
        if (this.getIsCenterAxis()) {
            if (this.getAxis().getArea().getReverseVert()) {
                context.DrawLine(penLine, rect.x, posY, rect.getRight(), posY);
            } else {
                context.DrawLine(penLine, rect.x, posY + rect.getHeight(), rect.getRight(), posY + rect.height);
            }
        } else if (this.getAxis().getShowXAxis() == StiShowXAxis.Both || this.getAxis().getShowXAxis() == StiShowXAxis.Bottom) {
            context.DrawLine(penLine, rect.x, posY, rect.getRight(), posY);
        }
    }

    private void DrawMinorTicks(StiContext context, StiPenGeom pen, double posX1, double posX2, double posY, IStiAxisTicks ticks) {
        double step = posX2 - posX1;
        double minorStep = step / (double)(ticks.getMinorCount() + 1);
        double minorLength = (double)ticks.getMinorLength() * context.Options.zoom;
        for (int minorIndex = 1; minorIndex <= ticks.getMinorCount(); ++minorIndex) {
            double posY2;
            double posX = posX1 + minorStep * (double)minorIndex;
            double d = posY2 = ((StiXAxisCoreXF)this.getAxis().getCore()).getIsTopSide() || this.getIsCenterAxis() ? posY - minorLength : posY + minorLength;
            if (this.getAxis().getArea().getReverseVert() && this.getIsCenterAxis()) {
                posY2 = posY + minorLength;
            }
            context.DrawLine(pen, posX, posY, posX, posY2);
        }
    }

    private void DrawTicks(StiContext context, StiRectangle rect, IStiAxisTicks ticks, StiPenGeom penLine) {
        ArrayList<StiStripPositionXF> infos;
        double posY2;
        if (!ticks.getVisible()) {
            return;
        }
        double ticksLength = (double)ticks.getLength() * context.Options.zoom;
        double posY1 = ((StiXAxisCoreXF)this.getAxis().getCore()).getIsTopSide() || this.getIsCenterAxis() ? rect.getBottom() : rect.getTop();
        double d = posY2 = ((StiXAxisCoreXF)this.getAxis().getCore()).getIsTopSide() || this.getIsCenterAxis() ? posY1 - ticksLength : posY1 + ticksLength;
        if (this.getIsCenterAxis() && this.getAxis().getArea().getReverseVert()) {
            posY2 = posY1 + ticksLength;
        }
        if (this.IsArgumentDateTime(infos = this.getAxis().getInfo().TicksCollection)) {
            Date date = new Date(0L);
            Date dateNext = new Date(0L);
            boolean startTick = true;
            String text = "";
            double startX = 0.0;
            for (int index = 0; index < infos.size(); ++index) {
                if (startTick) {
                    startX = infos.get((int)index).Position;
                    startTick = false;
                }
                if (infos.get((int)index).StripLine.getValueObject() == null) continue;
                date = (Date)infos.get((int)index).StripLine.getValueObject();
                dateNext = index < infos.size() - 2 ? (Date)infos.get((int)(index + 1)).StripLine.getValueObject() : date;
                switch (((StiXBottomAxis)this.getAxis().getArea().getXAxis()).getDateTimeStep().getStep()) {
                    case Day: {
                        if (StiDateUtil.format((Date)date, (String)"yyyyMMMMdd").equals(StiDateUtil.format((Date)dateNext, (String)"yyyyMMMMdd")) && index != infos.size() - 2) break;
                        text = StiDateUtil.format((Date)date);
                        break;
                    }
                    case Hour: {
                        if (StiDateUtil.format((Date)date, (String)"yyyyMMMMddHH").equals(StiDateUtil.format((Date)dateNext, (String)"yyyyMMMMddHH")) && index != infos.size() - 2) break;
                        text = StiDateUtil.format((Date)date, (String)"HH");
                        break;
                    }
                    case Minute: {
                        if (StiDateUtil.format((Date)date, (String)"yyyyMMMMddhhmm").equals(StiDateUtil.format((Date)dateNext, (String)"yyyyMMMMddhhmm")) && index != infos.size() - 2) break;
                        text = StiDateUtil.format((Date)date, (String)"mm");
                        break;
                    }
                    case Month: {
                        if (StiDateUtil.format((Date)date, (String)"yyyyMMMM").equals(StiDateUtil.format((Date)dateNext, (String)"yyyyMMMM")) && index != infos.size() - 2) break;
                        text = StiDateUtil.format((Date)date, (String)"MMMM");
                        break;
                    }
                    case Second: {
                        if (StiDateUtil.format((Date)date, (String)"yyyyMMMMddHHmmss").equals(StiDateUtil.format((Date)dateNext, (String)"yyyyMMMMddHHmmss")) && index != infos.size() - 2) break;
                        text = StiDateUtil.format((Date)date, (String)"ss");
                        break;
                    }
                    case Year: {
                        if (StiDateUtil.format((Date)date, (String)"yyyy").equals(StiDateUtil.format((Date)dateNext, (String)"yyyy")) && index != infos.size() - 2) break;
                        text = StiDateUtil.format((Date)date, (String)"yyyy");
                    }
                }
                if (text.equals("")) continue;
                double endX = 0.0;
                endX = index == infos.size() - 2 ? infos.get((int)(index + 1)).Position : infos.get((int)index).Position + (infos.get((int)(index + 1)).Position - infos.get((int)index).Position) / 2.0;
                context.DrawRectangle(penLine, startX, posY1, endX - startX, posY2);
                text = "";
                startX = endX;
            }
        } else {
            int index = 0;
            for (StiStripPositionXF strip : this.getAxis().getInfo().TicksCollection) {
                double posX = strip.Position;
                context.DrawLine(penLine, posX, posY1, posX, posY2);
                if (ticks.getMinorVisible() && index != this.getAxis().getInfo().TicksCollection.size() - 1) {
                    double posX2 = this.getAxis().getInfo().TicksCollection.get((int)(index + 1)).Position;
                    this.DrawMinorTicks(context, penLine, posX, posX2, posY1, ticks);
                }
                ++index;
            }
        }
    }

    private boolean IsArgumentDateTime(ArrayList<StiStripPositionXF> infos) {
        for (StiStripPositionXF info : infos) {
            if (!(info.StripLine.getValueObject() instanceof Date)) continue;
            return true;
        }
        return false;
    }

    private void DrawAxis(StiContext context, StiRectangle rect) {
        StiPenGeom penLine = new StiPenGeom(this.getAxis().getLineColor(), (double)this.getAxis().getLineWidth());
        penLine.setPenStyle(this.getAxis().getLineStyle());
        if (this.getIsCenterAxis()) {
            this.DrawTicks(context, rect, this.getAxis().getTicks(), penLine);
        } else {
            if (((StiXAxisCoreXF)this.getAxis().getCore()).getIsTopSide()) {
                this.DrawTicks(context, rect, this.getAxis().getTicks(), penLine);
            }
            if (((StiXAxisCoreXF)this.getAxis().getCore()).getIsBottomSide() && (this.getAxis().getShowXAxis() == StiShowXAxis.Both || this.getAxis().getShowXAxis() == StiShowXAxis.Bottom)) {
                this.DrawTicks(context, rect, this.getAxis().getTicks(), penLine);
            }
        }
        this.DrawAxisLine(context, rect);
    }

    private StiRectangle GetViewClipRect() {
        StiRectangle clipRect = this.getView().getClientRectangle();
        clipRect.x = (float)((StiAxisAreaCoreXF)this.getAxis().getArea().getCore()).getScrollDistanceX();
        clipRect.y = 0.0;
        clipRect.inflate(Double.valueOf(1.0), Double.valueOf(1.0));
        if (this.getIsCenterAxis()) {
            clipRect.inflate(Double.valueOf(0.0), Double.valueOf(2.0));
        }
        return clipRect;
    }

    @Override
    protected boolean AllowChildDrawing(StiCellGeom cellGeom) {
        StiAxisLabelGeom geom = (StiAxisLabelGeom)(cellGeom instanceof StiAxisLabelGeom ? cellGeom : null);
        if (geom == null) {
            return true;
        }
        if (this.getView() == null) {
            return true;
        }
        StiRectangle clipRect = this.GetViewClipRect();
        StiRectangle geomRect = geom.getClientRectangle();
        return !(geomRect.getRight() < clipRect.x) && !(geomRect.x > clipRect.getRight());
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        if (rect.width <= 0.0 || rect.height <= 0.0) {
            return;
        }
        if (this.getView() != null) {
            StiRectangle clipRect = this.GetViewClipRect();
            context.PushClip(clipRect);
        }
        this.DrawAxis(context, rect);
        if (this.getView() != null) {
            context.PopClip();
        }
    }

    public StiXAxisGeom(IStiXAxis axis, StiRectangle clientRectangle, boolean isCenterAxis) {
        super(clientRectangle);
        this.axis = axis;
        this.isCenterAxis = isCenterAxis;
    }
}

