/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiPointsAnimation;
import com.stimulsoft.base.context.chart.animation.StiTranslationAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.chart.StiChartHelper;
import java.util.ArrayList;
import java.util.List;

public final class StiNullableDrawing {
    public static void DrawLines(StiContext context, StiPenGeom penGeom, StiPoint[] points) {
        StiNullableDrawing.DrawLines(context, penGeom, points, true);
    }

    public static void DrawLines(StiContext context, StiPenGeom penGeom, StiPoint[] points, boolean isAnimation) {
        StiNullableDrawing.DrawLines(context, penGeom, null, points, isAnimation);
    }

    public static void DrawLines(StiContext context, StiPenGeom penGeom, StiPoint[] pointsStart, StiPoint[] points, boolean isAnimation) {
        ArrayList<StiPoint> newPoints = new ArrayList<StiPoint>();
        ArrayList<StiPoint> newPointsStart = new ArrayList<StiPoint>();
        for (int index = 0; index < points.length; ++index) {
            if (points[index] != null) {
                newPoints.add(points[index].getValue());
                if (pointsStart == null || pointsStart.length <= index) continue;
                newPointsStart.add(pointsStart[index].getValue());
                continue;
            }
            if (newPoints.size() > 1) {
                StiNullableDrawing.DrawLines(context, penGeom, newPointsStart, newPoints, isAnimation, pointsStart != null);
            }
            newPoints.clear();
        }
        if (newPoints.size() > 1) {
            StiNullableDrawing.DrawLines(context, penGeom, newPointsStart, newPoints, isAnimation, pointsStart != null);
        }
    }

    private static void DrawLines(StiContext context, StiPenGeom penGeom, List<StiPoint> newPointsStart, List<StiPoint> newPoints, boolean isAnimation, boolean isAnimationChangingValues) {
        if (isAnimation) {
            Object animation = null;
            animation = isAnimationChangingValues ? new StiPointsAnimation(newPointsStart.toArray(new StiPoint[newPointsStart.size()]), StiChartHelper.GlobalDurationElement, Integer.valueOf(0)) : new StiTranslationAnimation(StiChartHelper.GlobalDurationElement, Integer.valueOf(0));
            context.DrawAnimationLines(penGeom, newPoints.toArray(new StiPoint[newPoints.size()]), (StiAnimation)animation);
        } else {
            context.DrawLines(penGeom, newPoints.toArray(new StiPoint[newPoints.size()]));
        }
    }

    public static void DrawCurve(StiContext context, StiPenGeom penGeom, StiPoint[] points, float tension) {
        StiNullableDrawing.DrawCurve(context, penGeom, points, tension, false);
    }

    public static void DrawCurve(StiContext context, StiPenGeom penGeom, StiPoint[] points, float tension, boolean isAnimation) {
        StiNullableDrawing.DrawCurve(context, penGeom, null, points, tension, isAnimation);
    }

    public static void DrawCurve(StiContext context, StiPenGeom penGeom, StiPoint[] pointsStart, StiPoint[] points, float tension, boolean isAnimation) {
        ArrayList<StiPoint> newPoints = new ArrayList<StiPoint>();
        ArrayList<StiPoint> newPointsStart = new ArrayList<StiPoint>();
        for (int index = 0; index < points.length; ++index) {
            if (points[index] != null) {
                newPoints.add(points[index].getValue());
                if (pointsStart == null || pointsStart.length <= index) continue;
                newPointsStart.add(pointsStart[index].getValue());
                continue;
            }
            if (newPoints.size() > 1) {
                StiNullableDrawing.DrawCurve(context, penGeom, newPointsStart, newPoints, tension, isAnimation, pointsStart != null);
            }
            newPoints.clear();
        }
        if (newPoints.size() > 1) {
            StiNullableDrawing.DrawCurve(context, penGeom, newPointsStart, newPoints, tension, isAnimation, pointsStart != null);
        }
    }

    private static void DrawCurve(StiContext context, StiPenGeom penGeom, List<StiPoint> newPointsStart, List<StiPoint> newPoints, float tension, boolean isAnimation, boolean isAnimationChangingValues) {
        if (isAnimation) {
            Object animation = null;
            animation = isAnimationChangingValues ? new StiPointsAnimation(newPointsStart.toArray(new StiPoint[newPointsStart.size()]), StiChartHelper.GlobalDurationElement, Integer.valueOf(0)) : new StiTranslationAnimation(StiChartHelper.GlobalDurationElement, Integer.valueOf(0));
            context.DrawAnimationCurve(penGeom, newPoints.toArray(new StiPoint[newPoints.size()]), tension, (StiAnimation)animation);
        } else {
            context.DrawCurve(penGeom, newPoints.toArray(new StiPoint[newPoints.size()]), tension, false);
        }
    }

    public static ArrayList<StiPoint[]> GetPointsList(StiPoint[] points) {
        ArrayList<StiPoint[]> list = new ArrayList<StiPoint[]>();
        ArrayList<StiPoint> newPoints = new ArrayList<StiPoint>();
        for (StiPoint point : points) {
            if (point != null) {
                newPoints.add(point.getValue());
                continue;
            }
            if (newPoints.size() > 1) {
                list.add(newPoints.toArray(new StiPoint[0]));
            }
            newPoints.clear();
        }
        if (newPoints.size() > 1) {
            list.add(newPoints.toArray(new StiPoint[0]));
        }
        return list;
    }

    public static ArrayList<StiPoint[]> GetNullablePointsList(StiPoint[] points) {
        ArrayList<StiPoint[]> list = new ArrayList<StiPoint[]>();
        ArrayList<StiPoint> newPoints = new ArrayList<StiPoint>();
        for (StiPoint point : points) {
            if (point != null) {
                newPoints.add(point);
                continue;
            }
            if (newPoints.size() > 1) {
                list.add(newPoints.toArray(new StiPoint[0]));
            }
            newPoints.clear();
        }
        if (newPoints.size() >= 1) {
            list.add(newPoints.toArray(new StiPoint[0]));
        }
        return list;
    }

    public static void GetPointsList(StiPoint[] points1, StiPoint[] points2, StiRefObject<ArrayList<StiPoint[]>> list1, StiRefObject<ArrayList<StiPoint[]>> list2) {
        list1.argvalue = new ArrayList();
        list2.argvalue = new ArrayList();
        ArrayList<StiPoint> newPoints1 = new ArrayList<StiPoint>();
        ArrayList<StiPoint> newPoints2 = new ArrayList<StiPoint>();
        int index = 0;
        for (StiPoint point1 : points1) {
            StiPoint point2 = points2[index];
            if (point1 != null && point2 != null) {
                newPoints1.add(point1.getValue());
                newPoints2.add(point2.getValue());
            } else {
                if (newPoints1.size() > 1) {
                    ((ArrayList)list1.argvalue).add(newPoints1.toArray(new StiPoint[0]));
                    ((ArrayList)list2.argvalue).add(newPoints2.toArray(new StiPoint[0]));
                }
                newPoints1.clear();
                newPoints2.clear();
            }
            ++index;
        }
        if (newPoints1.size() > 1) {
            ((ArrayList)list1.argvalue).add(newPoints1.toArray(new StiPoint[0]));
            ((ArrayList)list2.argvalue).add(newPoints2.toArray(new StiPoint[0]));
        }
    }

    public static List<StiPoint[]> GetPointsList(ArrayList<StiPoint> points) {
        ArrayList<StiPoint[]> list = new ArrayList<StiPoint[]>();
        ArrayList<StiPoint> newPoints = new ArrayList<StiPoint>();
        for (StiPoint point : points) {
            if (point != null) {
                newPoints.add(point.getValue());
                continue;
            }
            if (newPoints.size() > 1) {
                list.add(newPoints.toArray(new StiPoint[newPoints.size()]));
            }
            newPoints.clear();
        }
        if (newPoints.size() > 1) {
            list.add(newPoints.toArray(new StiPoint[newPoints.size()]));
        }
        return list;
    }
}

