/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.trendLines;

import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyle;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;

public abstract class StiTrendLineCoreXF
implements Cloneable,
IStiApplyStyle {
    private IStiTrendLine trendLine;

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void applyStyle(IStiChartStyle style) {
        if (this.getTrendLine().getAllowApplyStyle()) {
            this.getTrendLine().setLineColor(style.getCore().getTrendLineColor());
            this.getTrendLine().setShowShadow(style.getCore().getTrendLineShowShadow());
        }
    }

    public abstract String getLocalizedName();

    public final IStiTrendLine getTrendLine() {
        return this.trendLine;
    }

    public final void setTrendLine(IStiTrendLine value) {
        this.trendLine = value;
    }

    public void RenderTrendLine(StiAreaGeom geom, StiPoint[] points, double posY) {
    }

    protected final float Sum(double[] values) {
        float sum = 0.0f;
        for (double value : values) {
            sum = (float)((double)sum + value);
        }
        return sum;
    }

    protected final float SumSqr(double[] values) {
        float sum = 0.0f;
        for (double value : values) {
            sum = (float)((double)sum + value * value);
        }
        return sum;
    }

    protected final float SumProductions(double[] valuesX, double[] valuesY) {
        float sum = 0.0f;
        for (int index = 0; index < valuesX.length; ++index) {
            sum = (float)((double)sum + valuesX[index] * valuesY[index]);
        }
        return sum;
    }

    protected final float SumProductionsXLogY(double[] valuesX, double[] valuesY) {
        float sum = 0.0f;
        for (int index = 0; index < valuesX.length; ++index) {
            sum = (float)((double)sum + valuesX[index] * (double)((float)Math.log(valuesY[index])));
        }
        return sum;
    }

    protected final float SumLn(double[] values) {
        float sum = 0.0f;
        for (double value : values) {
            sum += (float)Math.log(value);
        }
        return sum;
    }

    public StiTrendLineCoreXF(IStiTrendLine trendLine) {
        this.trendLine = trendLine;
    }
}

