/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.table;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.table.StiChartTableGeom;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyle;
import com.stimulsoft.report.chart.interfaces.areas.candlestick.IStiCandlestickArea;
import com.stimulsoft.report.chart.interfaces.areas.clusteredBar.IStiClusteredBarArea;
import com.stimulsoft.report.chart.interfaces.areas.clusteredColumn.IStiClusteredColumnArea;
import com.stimulsoft.report.chart.interfaces.areas.range.IStiRangeArea;
import com.stimulsoft.report.chart.interfaces.areas.scatter.IStiScatterArea;
import com.stimulsoft.report.chart.interfaces.areas.stock.IStiStockArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.interfaces.table.IStiChartTable;

public class StiChartTableCore
implements Cloneable,
IStiApplyStyle {
    private IStiChartTable chartTable;

    public StiChartTableCore(IStiChartTable table) {
        this.chartTable = table;
    }

    @Override
    public void applyStyle(IStiChartStyle style) {
        if (this.chartTable.isAllowApplyStyle()) {
            this.chartTable.setGridLineColor(style.getCore().getLegendBorderColor().clone());
            this.chartTable.setTextColor(style.getCore().getLegendLabelsColor().clone());
        }
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean ShowTable() {
        return this.chartTable.getChart().getArea() instanceof IStiClusteredColumnArea && !(this.chartTable.getChart().getArea() instanceof IStiCandlestickArea) && !(this.chartTable.getChart().getArea() instanceof IStiClusteredBarArea) && !(this.chartTable.getChart().getArea() instanceof IStiRangeArea) && !(this.chartTable.getChart().getArea() instanceof IStiScatterArea) && !(this.chartTable.getChart().getArea() instanceof IStiStockArea) && this.chartTable.isVisible();
    }

    public double GetHeightTable(StiContext context) {
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.chartTable.getFont(), (double)(this.chartTable.getFont().getSize() * context.Options.zoom));
        StiSize size = context.MeasureString("HeightText", font);
        return size.height * (double)(this.chartTable.getChart().getSeries().size() + 1);
    }

    public double GetWidthCellLegend(StiContext context) {
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.chartTable.getFont(), (double)(this.chartTable.getFont().getSize() * context.Options.zoom));
        double widthCell = 0.0;
        for (IStiSeries series : this.chartTable.getChart().getSeries()) {
            StiSize size = context.MeasureString(series.getCoreTitle(), font);
            widthCell = Math.max(size.width, widthCell);
        }
        if (this.chartTable.isMarkerVisible()) {
            widthCell += this.GetHeightTable(context) / (double)(this.chartTable.getChart().getSeries().size() + 1);
        }
        return Math.round(widthCell);
    }

    public StiCellGeom Render(StiContext context, StiRectangle rect, String[][] table) {
        return new StiChartTableGeom(StiRectangle.round((StiRectangle)rect), table, this.GetWidthCellLegend(context), this.chartTable);
    }

    public IStiChartTable getChartTable() {
        return this.chartTable;
    }

    public void setChartTable(IStiChartTable chartTable) {
        this.chartTable = chartTable;
    }
}

