/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.seriesLabels.pie;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.seriesLabels.pie.StiOutsidePieLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsPosition;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsType;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.pie.StiTwoColumnsPieLabelsGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.pie.IStiTwoColumnsPieLabels;

public class StiTwoColumnsPieLabelsCoreXF
extends StiOutsidePieLabelsCoreXF {
    @Override
    public StiSeriesLabelsGeom RenderLabel(IStiSeries series, StiContext context, StiPoint centerPie, double radius, double radius2, double pieAngle, int pointIndex, Double value, Double labelValue, String argumentText, String tag, boolean measure, int colorIndex, int colorCount, double percentPerValue, StiRefObject<StiRectangle> measureRect, boolean drawValue, double deltaY) {
        this.percentPerValue = percentPerValue;
        measureRect.argvalue = StiRectangle.getEmpty();
        if (labelValue == null && !this.getSeriesLabels().getShowNulls()) {
            return null;
        }
        if (labelValue != null && labelValue == 0.0 && !this.getSeriesLabels().getShowZeros()) {
            return null;
        }
        if (value == null) {
            value = 0.0;
        }
        if (labelValue == null) {
            labelValue = 0.0;
        }
        if (Double.isNaN(radius) || Double.isNaN(radius2)) {
            return null;
        }
        if (drawValue) {
            return super.RenderLabel(series, context, centerPie, radius, radius2, pieAngle, pointIndex, value, labelValue, this.GetFormattedValue(series, labelValue), tag, measure, colorIndex, colorCount, percentPerValue, measureRect, drawValue, deltaY);
        }
        String labelText = this.GetLabelText(series, labelValue, argumentText, tag, series.getCoreTitle());
        float angleRad = (float)(Math.PI * pieAngle / 180.0);
        StiPoint arcPoint = this.GetLabelPoint(centerPie, radius, angleRad);
        StiPoint startPoint = this.GetLabelPoint(centerPie, radius + (double)((IStiTwoColumnsPieLabels)this.getSeriesLabels()).getLineLength() * context.Options.zoom, angleRad);
        float dist = 0.0f;
        dist = arcPoint.x > startPoint.x ? -1.0f : 1.0f;
        StiPoint endPoint = new StiPoint(centerPie.x + radius * (double)dist + (double)(((IStiTwoColumnsPieLabels)this.getSeriesLabels()).getLineLength() * dist) + (double)(10.0f * dist), startPoint.y);
        if (((IStiTwoColumnsPieLabels)this.getSeriesLabels()).getPreventIntersection()) {
            endPoint.y = arcPoint.y;
        }
        endPoint.y += deltaY * Math.min(context.Options.zoom, 1.0);
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.getSeriesLabels().getFont(), (double)(this.getSeriesLabels().getFont().size * context.Options.zoom));
        StiSize labelSize = context.MeasureString(labelText, font).round();
        StiRectangle labelRect = StiRectangle.getEmpty();
        labelRect = dist < 0.0f ? StiRectangle.round((StiRectangle)new StiRectangle(endPoint.x - labelSize.width, endPoint.y - labelSize.height / 2.0, labelSize.width, labelSize.height)) : StiRectangle.round((StiRectangle)new StiRectangle(endPoint.x, endPoint.y - labelSize.height / 2.0, labelSize.width, labelSize.height));
        if (measure) {
            measureRect.argvalue = labelRect;
            return null;
        }
        measureRect.argvalue = StiRectangle.getEmpty();
        StiColor borderColor = this.GetBorderColor(series, colorIndex, colorCount);
        StiColor seriesBorderColor = (StiColor)series.getCore().GetSeriesBorderColor(colorIndex, colorCount);
        StiBrush seriesBrush = series.getCore().GetSeriesBrush(colorIndex, colorCount);
        seriesBrush = this.ProcessSeriesColors(pointIndex, seriesBrush, series);
        StiSolidBrush labelBrush = new StiSolidBrush(this.GetLabelColor(series, colorIndex, colorCount));
        StiColor lineColor = this.GetLineColor(series, colorIndex, colorCount);
        StiBrush seriesLabelsBrush = this.ProcessSeriesColors(pointIndex, this.getSeriesLabels().getBrush(), series);
        return new StiTwoColumnsPieLabelsGeom(this.getSeriesLabels(), series, pointIndex, value, labelRect, labelText, seriesBrush, (StiBrush)labelBrush, seriesLabelsBrush, borderColor, seriesBorderColor, labelRect, lineColor, startPoint, endPoint, arcPoint);
    }

    @Override
    public StiSeriesLabelsType getSeriesLabelsType() {
        return StiSeriesLabelsType.Pie;
    }

    @Override
    public int getPosition() {
        return StiSeriesLabelsPosition.TwoColumnsPie.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"LabelsTwoColumns");
    }

    public StiTwoColumnsPieLabelsCoreXF(IStiSeriesLabels seriesLabels) {
        super(seriesLabels);
    }
}

