/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.seriesLabels.pie;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.series.pie.StiPieSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.StiSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsPosition;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsType;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.pie.StiCenterPieLabelsGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.pie.IStiPieSeriesLabels;
import com.stimulsoft.report.chart.view.series.pie.StiPie3dSlice;
import com.stimulsoft.report.chart.view.series.pie.StiPieSeries;
import java.util.ArrayList;

public class StiCenterPie3dLabelsCoreXF
extends StiSeriesLabelsCoreXF {
    public float percentPerValue = 0.0f;

    @Override
    public StiSeriesLabelsType getSeriesLabelsType() {
        return StiSeriesLabelsType.Pie3d;
    }

    @Override
    public int getPosition() {
        return StiSeriesLabelsPosition.CenterPie3d.getValue();
    }

    @Override
    public String getLocalizedName() {
        return String.format("3D %1$s", StiLocalization.Get((String)"Chart", (String)"LabelsCenter"));
    }

    public final StiSeriesLabelsGeom renderLabel(IStiSeries series, StiContext context, StiPie3dSlice pie3dSlice) {
        String labelText = this.GetLabelText(series, pie3dSlice.getValue(), pie3dSlice.getArgumentText(), pie3dSlice.getTag(), series.getCoreTitle());
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.getSeriesLabels().getFont(), (double)(this.getSeriesLabels().getFont().size * context.Options.zoom));
        StiStringFormatGeom sf = this.GetStringFormatGeom(context);
        StiRectangle labelRect = StiRectangle.round((StiRectangle)this.getLabelRect(context, pie3dSlice.getTextPosition(), labelText, font, sf));
        StiRectangle rect = labelRect.clone();
        rect.x = -rect.width / 2.0;
        rect.y = -rect.height / 2.0;
        StiColor borderColor = this.GetBorderColor(series, pie3dSlice.getColorIndex(), pie3dSlice.getColorCount());
        StiColor seriesBorderColor = (StiColor)series.getCore().GetSeriesBorderColor(pie3dSlice.getColorIndex(), pie3dSlice.getColorCount());
        StiBrush seriesBrush = series.getCore().GetSeriesBrush(pie3dSlice.getColorIndex(), pie3dSlice.getColorCount());
        StiSolidBrush labelBrush = new StiSolidBrush(this.GetLabelColor(series, pie3dSlice.getColorIndex(), pie3dSlice.getColorCount()));
        seriesBrush = this.ProcessSeriesColors(pie3dSlice.getColorIndex(), seriesBrush, series);
        StiBrush seriesLabelsBrush = this.ProcessSeriesColors(pie3dSlice.getColorIndex(), this.getSeriesLabels().getBrush(), series);
        return new StiCenterPieLabelsGeom(this.getSeriesLabels(), series, pie3dSlice.getIndex(), pie3dSlice.getValue(), rect, labelText, seriesBrush, (StiBrush)labelBrush, seriesLabelsBrush, borderColor, seriesBorderColor, StiRotationMode.CenterCenter, labelRect, this.getSeriesLabels().getAngle(), null);
    }

    public StiRectangle getLabelRect(StiContext context, StiPoint labelPoint, String labelText, StiFontGeom font, StiStringFormatGeom sf) {
        return context.MeasureRotatedString(labelText, font, labelPoint, sf, StiRotationMode.CenterCenter, 0.0, (double)((int)((double)this.getSeriesLabels().getWidth() * context.Options.zoom)));
    }

    @Override
    public double RecalcValue(double value, int signs) {
        if (((IStiPieSeriesLabels)this.getSeriesLabels()).getShowInPercent()) {
            ArrayList<IStiSeries> seriesCollection = this.getSeriesLabels().getChart().getArea().getCore().GetSeries();
            if (!seriesCollection.isEmpty()) {
                IStiSeries[] seriesArray = new IStiSeries[seriesCollection.size()];
                seriesCollection.toArray(seriesArray);
                if (seriesArray.length > 0 && seriesArray[0] instanceof StiPieSeries) {
                    this.percentPerValue = ((StiPieSeriesCoreXF)seriesArray[0].getCore()).GetPercentPerValue(seriesArray);
                }
            }
            return Double.isNaN(value * (double)this.percentPerValue) ? Double.NaN : (double)Math.round(value * (double)this.percentPerValue * Math.pow(10.0, signs)) / Math.pow(10.0, signs);
        }
        return value;
    }

    public StiCenterPie3dLabelsCoreXF(IStiSeriesLabels seriesLabels) {
        super(seriesLabels);
    }
}

