/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.stackedBar;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.series.StiSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaGeom;
import com.stimulsoft.report.chart.geoms.series.stackedBar.StiStackedBarSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.series.stackedBar.StiStackedBarSeriesShadowElementGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.fullStackedBar.IStiFullStackedBarSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedBar.IStiStackedBarSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import java.util.ArrayList;

public class StiStackedBarSeriesCoreXF
extends StiSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        IStiSeries tempVar = this.getSeries();
        IStiStackedBarSeries barSeries = (IStiStackedBarSeries)(tempVar instanceof IStiStackedBarSeries ? tempVar : null);
        if (barSeries.getAllowApplyStyle()) {
            barSeries.setBrush(style.getCore().GetColumnBrush(color));
            if (barSeries.getBrush() instanceof StiGradientBrush) {
                ((StiGradientBrush)barSeries.getBrush()).angle += 90.0;
            }
            if (barSeries.getBrush() instanceof StiGlareBrush) {
                ((StiGlareBrush)barSeries.getBrush()).angle += 90.0;
            }
            barSeries.setBorderColor(style.getCore().GetColumnBorder(color));
        }
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] series) {
        if (series == null || series.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        ArrayList<StiSeriesLabelsGeom> labelList = new ArrayList<StiSeriesLabelsGeom>();
        ArrayList<StiStackedBarSeriesElementGeom> seriesList = new ArrayList<StiStackedBarSeriesElementGeom>();
        IStiArea area = geom.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(area instanceof IStiAxisArea ? area : null);
        IStiSeries tempVar = this.getSeries();
        IStiStackedBarSeries barSeries = (IStiStackedBarSeries)(tempVar instanceof IStiStackedBarSeries ? tempVar : null);
        double posX = axisArea.getAxisCore().GetDividerX();
        int colorIndex = 0;
        int colorCount = axisArea.getAxisCore().ValuesCount * series.length;
        double dpiX = (float)axisArea.getXAxis().getInfo().Dpi;
        int pointCount = axisArea.getAxisCore().ValuesCount;
        for (int pointIndex = 0; pointIndex < pointCount; ++pointIndex) {
            IStiSeries currentSeries;
            int seriesIndex;
            double totalPositiveWidth = 0.0;
            double totalNegativeWidth = 0.0;
            StiRefObject tempRef_totalPositiveWidth = new StiRefObject((Object)totalPositiveWidth);
            StiRefObject tempRef_totalNegativeWidth = new StiRefObject((Object)totalNegativeWidth);
            this.CalculateTotalWidth(series, pointIndex, (StiRefObject<Double>)tempRef_totalPositiveWidth, (StiRefObject<Double>)tempRef_totalNegativeWidth);
            totalPositiveWidth = (Double)tempRef_totalPositiveWidth.argvalue;
            totalNegativeWidth = (Double)tempRef_totalNegativeWidth.argvalue;
            double posY = axisArea.getYAxis().getInfo().StripPositions[pointIndex + 1] - axisArea.getYAxis().getInfo().Step / 2.0;
            double seriesHeight = axisArea.getYAxis().getInfo().Step - axisArea.getYAxis().getInfo().Step * (double)(1.0f - barSeries.getWidth());
            double seriesTopPos = posY + (axisArea.getYAxis().getInfo().Step - seriesHeight) / 2.0;
            float posXMax = 0.0f;
            float posXMin = 0.0f;
            if (series.length == 0) {
                return;
            }
            boolean showShadow = ((IStiStackedBarSeries)series[0]).getShowShadow();
            if (showShadow) {
                for (seriesIndex = 0; seriesIndex < series.length; ++seriesIndex) {
                    Double value;
                    if (pointIndex >= series[seriesIndex].getValues().length) continue;
                    currentSeries = series[seriesIndex];
                    Double d = value = axisArea.getReverseVert() ? currentSeries.getValues()[pointIndex] : currentSeries.getValues()[currentSeries.getValues().length - pointIndex - 1];
                    if (axisArea.getReverseHor() && value != null) {
                        value = -value.doubleValue();
                    }
                    if (value > 0.0) {
                        posXMax += (float)(value == null ? 0.0 : value);
                        continue;
                    }
                    posXMin += (float)(value == null ? 0.0 : value);
                }
                if (this.getSeries() instanceof IStiFullStackedBarSeries) {
                    StiStackedBarSeriesShadowElementGeom shadowGeom;
                    StiRectangle shadowRect;
                    double totalNegativeWidth2;
                    double totalPositiveWidth2 = axisArea.getReverseHor() ? totalNegativeWidth : totalPositiveWidth;
                    double d = totalNegativeWidth2 = axisArea.getReverseHor() ? totalPositiveWidth : totalNegativeWidth;
                    if (totalPositiveWidth2 > 0.0 && totalNegativeWidth2 > 0.0) {
                        shadowRect = new StiRectangle(-8.0, seriesTopPos, rect.width + 8.0, seriesHeight);
                        shadowGeom = new StiStackedBarSeriesShadowElementGeom(series[0], shadowRect, false, false);
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(shadowGeom);
                    } else if (totalPositiveWidth2 > 0.0) {
                        shadowRect = new StiRectangle(axisArea.getAxisCore().GetDividerX() - 8.0, seriesTopPos, rect.width - axisArea.getAxisCore().GetDividerX() + 8.0, seriesHeight);
                        shadowGeom = new StiStackedBarSeriesShadowElementGeom(series[0], shadowRect, false, false);
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(shadowGeom);
                    } else if (totalNegativeWidth2 > 0.0) {
                        shadowRect = new StiRectangle(-8.0, seriesTopPos, axisArea.getAxisCore().GetDividerX() + 8.0, seriesHeight);
                        shadowGeom = new StiStackedBarSeriesShadowElementGeom(series[0], shadowRect, false, false);
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(shadowGeom);
                    }
                } else {
                    StiStackedBarSeriesShadowElementGeom shadowGeom;
                    if (posXMax > 0.0f) {
                        StiRectangle shadowRect = new StiRectangle(posX, seriesTopPos, (double)posXMax * dpiX, seriesHeight);
                        shadowRect.x -= 7.0;
                        shadowRect.width += 7.0;
                        shadowGeom = new StiStackedBarSeriesShadowElementGeom(series[0], shadowRect, false, true);
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(shadowGeom);
                    }
                    if (posXMin < 0.0f) {
                        StiRectangle shadowRect = new StiRectangle(posX + (double)posXMin * dpiX, seriesTopPos, (double)(-posXMin) * dpiX, seriesHeight);
                        shadowGeom = new StiStackedBarSeriesShadowElementGeom(series[0], shadowRect, true, false);
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(shadowGeom);
                    }
                }
            }
            posXMax = 0.0f;
            posXMin = 0.0f;
            for (seriesIndex = 0; seriesIndex < series.length; ++seriesIndex) {
                currentSeries = (IStiStackedBarSeries)(series[seriesIndex] instanceof IStiStackedBarSeries ? series[seriesIndex] : null);
                if (pointIndex >= currentSeries.getValues().length) continue;
                Double originalValue = axisArea.getReverseVert() ? currentSeries.getValues()[pointIndex] : currentSeries.getValues()[currentSeries.getValues().length - pointIndex - 1];
                Double value = originalValue != null ? -originalValue.doubleValue() : originalValue;
                if (this.getSeries() instanceof IStiFullStackedBarSeries && (totalPositiveWidth != 0.0 || totalNegativeWidth != 0.0) && value != null) {
                    dpiX = value > 0.0 ? axisArea.getAxisCore().GetDividerX() / (double)((float)totalNegativeWidth) : (double)((float)(rect.width - axisArea.getAxisCore().GetDividerX()) / (float)totalPositiveWidth);
                }
                if (axisArea.getReverseHor() && value != null) {
                    value = -value.doubleValue();
                }
                double seriesWidth = (float)((value == null ? 0.0 : value) * dpiX);
                double seriesLeftPos = -seriesWidth + posX;
                if (value > 0.0) {
                    seriesLeftPos -= (double)posXMax;
                } else {
                    seriesLeftPos = (double)posXMin + posX;
                    seriesWidth = -seriesWidth;
                }
                if (currentSeries.getShowZeros() && (value.equals(0) || value == null)) {
                    seriesWidth = Math.max(context.Options.zoom, 1.0);
                    if (!axisArea.getReverseHor()) {
                        seriesLeftPos -= seriesWidth;
                    }
                }
                StiRectangle columnRect = new StiRectangle(seriesLeftPos, seriesTopPos, seriesWidth, seriesHeight);
                columnRect = this.CorrectRect(columnRect, rect);
                StiRectangle clipRect = ((StiAxisAreaGeom)geom).getView().getClientRectangle();
                clipRect.x = 0.0;
                clipRect.y = 0.0;
                StiRectangle columnRectCheck = columnRect;
                columnRectCheck.x += geom.getClientRectangle().x;
                columnRectCheck.y += geom.getClientRectangle().y;
                if (columnRectCheck.getBottom() > clipRect.y && columnRectCheck.y < clipRect.getBottom() || ((IStiAxisArea)this.getSeries().getChart().getArea()).getYAxis().getRange().getAuto()) {
                    IStiAxisSeriesLabels labels;
                    StiBrush seriesBrush = currentSeries.getCore().GetSeriesBrush(colorIndex, colorCount);
                    if (currentSeries.getAllowApplyBrushNegative() && value > 0.0) {
                        seriesBrush = currentSeries.getBrushNegative();
                    }
                    seriesBrush = currentSeries.ProcessSeriesColors(pointCount - 1 - pointIndex, seriesBrush);
                    Integer time = StiChartHelper.GlobalBeginTimeElement;
                    if (columnRect.height != 0.0 && (double)Math.round(columnRect.width * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0) > 0.0 && seriesBrush != null) {
                        StiColor seriesBorderColor = (StiColor)currentSeries.getCore().GetSeriesBorderColor(colorIndex, colorCount);
                        StiStackedBarSeriesElementGeom seriesColumnGeom = new StiStackedBarSeriesElementGeom(geom, value == null ? 0.0 : value, pointIndex, seriesBrush, seriesBorderColor, currentSeries, columnRect, time / ((StiAxisAreaCoreXF)axisArea.getCore()).ValuesCount * pointIndex);
                        if (currentSeries.getCore().getInteraction() != null) {
                            StiSeriesInteractionData data = new StiSeriesInteractionData();
                            data.Fill(axisArea, currentSeries, pointIndex);
                            seriesColumnGeom.setInteraction(data);
                        }
                        seriesList.add(seriesColumnGeom);
                    }
                    if ((labels = currentSeries.getCore().GetSeriesLabels()) != null && labels.getVisible() && (double)Math.round(columnRect.width * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0) > 0.0) {
                        StiPoint endPoint = new StiPoint(columnRect.x, columnRect.y + columnRect.height / 2.0);
                        StiPoint startPoint = new StiPoint(columnRect.getRight(), columnRect.y + columnRect.height / 2.0);
                        if (value < 0.0) {
                            startPoint.x = columnRect.x;
                            endPoint.x = columnRect.getRight();
                        }
                        if (value < 0.0) {
                            startPoint.x = columnRect.x;
                            endPoint.x = columnRect.getRight();
                        }
                        if (labels.getStep() == 0 || pointIndex % labels.getStep() == 0) {
                            StiStripLineXF stripLine = axisArea.getXAxis().getInfo().StripLines.size() > pointIndex ? (StiStripLineXF)axisArea.getXAxis().getInfo().StripLines.get(pointIndex) : null;
                            StiSeriesLabelsGeom seriesLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currentSeries, context, endPoint, startPoint, pointIndex, value, originalValue, axisArea.getAxisCore().GetArgumentLabel(stripLine, currentSeries), this.GetTag(pointIndex), colorIndex, colorCount, rect, null);
                            if (seriesLabelsGeom != null) {
                                labelList.add(seriesLabelsGeom);
                            }
                        }
                    }
                }
                if (value > 0.0) {
                    posXMax = (float)((double)posXMax + seriesWidth);
                } else {
                    posXMin = (float)((double)posXMin + seriesWidth);
                }
                ++colorIndex;
            }
        }
        for (int index = seriesList.size() - 1; index >= 0; --index) {
            StiStackedBarSeriesElementGeom seriesGeom = (StiStackedBarSeriesElementGeom)seriesList.get(index);
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesGeom);
        }
        for (StiSeriesLabelsGeom seriesLabelsGeom : labelList) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesLabelsGeom);
            seriesLabelsGeom.setClientRectangle(this.CheckLabelsRect(seriesLabelsGeom.getSeriesLabels(), geom, seriesLabelsGeom.getClientRectangle()));
        }
    }

    private void CalculateTotalWidth(IStiSeries[] series, int pointIndex, StiRefObject<Double> totalPositiveWidth, StiRefObject<Double> totalNegativeWidth) {
        totalPositiveWidth.argvalue = 0.0;
        totalNegativeWidth.argvalue = 0.0;
        if (this.getSeries() instanceof IStiFullStackedBarSeries) {
            for (IStiSeries currentSeries : series) {
                if (pointIndex >= currentSeries.getValues().length) continue;
                Double value = ((IStiAxisArea)this.getSeries().getChart().getArea()).getReverseVert() ? currentSeries.getValues()[pointIndex] : currentSeries.getValues()[currentSeries.getValues().length - pointIndex - 1];
                Double argvaluePositiveWidth = (Double)totalPositiveWidth.argvalue;
                Double argvalueNegativeWidth = (Double)totalNegativeWidth.argvalue;
                if (value != null && value > 0.0) {
                    argvaluePositiveWidth = argvaluePositiveWidth + (value == null ? 0.0 : value);
                } else {
                    argvalueNegativeWidth = argvalueNegativeWidth + Math.abs(value == null ? 0.0 : value);
                }
                totalPositiveWidth.argvalue = argvaluePositiveWidth;
                totalNegativeWidth.argvalue = argvalueNegativeWidth;
            }
        }
    }

    private StiRectangle CorrectRect(StiRectangle columnRect, StiRectangle rect) {
        double dist;
        if (columnRect.x > rect.width || columnRect.getRight() < 0.0) {
            columnRect.width = 0.0;
            return columnRect;
        }
        if (columnRect.x < 0.0) {
            dist = -columnRect.x;
            columnRect.x += dist;
            columnRect.width -= dist;
        }
        if (columnRect.getRight() > rect.width) {
            dist = columnRect.getRight() - rect.width;
            columnRect.width -= dist;
        }
        return columnRect;
    }

    @Override
    public StiBrush GetSeriesBrush(int colorIndex, int colorCount) {
        IStiSeries tempVar = this.getSeries();
        IStiStackedBarSeries barSeries = (IStiStackedBarSeries)(tempVar instanceof IStiStackedBarSeries ? tempVar : null);
        StiBrush brush = super.GetSeriesBrush(colorIndex, colorCount);
        if (brush == null) {
            return barSeries.getBrush();
        }
        return brush;
    }

    @Override
    public Object GetSeriesBorderColor(int colorIndex, int colorCount) {
        IStiSeries tempVar = this.getSeries();
        IStiStackedBarSeries barSeries = (IStiStackedBarSeries)(tempVar instanceof IStiStackedBarSeries ? tempVar : null);
        Object color = super.GetSeriesBorderColor(colorIndex, colorCount);
        if (color == null) {
            return barSeries.getBorderColor();
        }
        return color;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"StackedBar");
    }

    public StiStackedBarSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

