/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.range;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.series.clusteredColumn.StiSteppedLineSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesYAxis;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaGeom;
import com.stimulsoft.report.chart.geoms.marker.StiMarkerGeom;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiSteppedLineSeriesGeom;
import com.stimulsoft.report.chart.geoms.series.range.StiSteppedRangeSeriesGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.areas.range.IStiSteppedRangeArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiBaseLineSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiSteppedLineSeries;
import com.stimulsoft.report.chart.interfaces.series.range.IStiSteppedRangeSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;

public class StiSteppedRangeSeriesCoreXF
extends StiSteppedLineSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        IStiSeries tempVar = this.getSeries();
        IStiSteppedRangeSeries areaSeries = (IStiSteppedRangeSeries)(tempVar instanceof IStiSteppedRangeSeries ? tempVar : null);
        if (areaSeries.getAllowApplyStyle()) {
            areaSeries.setBrush(style.getCore().GetAreaBrush(color));
        }
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] series) {
        if (series == null || series.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        IStiArea tempVar = geom.getArea();
        IStiSteppedRangeArea rangeArea = (IStiSteppedRangeArea)(tempVar instanceof IStiSteppedRangeArea ? tempVar : null);
        for (IStiSeries currentSeries1 : series) {
            IStiSteppedRangeSeries currentSeries = (IStiSteppedRangeSeries)currentSeries1;
            int valuesCount = currentSeries.getValues().length;
            StiPoint[] points = new StiPoint[valuesCount];
            StiPoint[] pointsEnd = new StiPoint[valuesCount];
            if (currentSeries.getValuesEnd().length < valuesCount) {
                valuesCount = currentSeries.getValuesEnd().length;
            }
            for (int pointIndex = 0; pointIndex < valuesCount; ++pointIndex) {
                Double value = rangeArea.getReverseHor() ? currentSeries.getValues()[currentSeries.getValues().length - pointIndex - 1] : currentSeries.getValues()[pointIndex];
                Double valueEnd = rangeArea.getReverseHor() ? currentSeries.getValuesEnd()[currentSeries.getValues().length - pointIndex - 1] : currentSeries.getValuesEnd()[pointIndex];
                points[pointIndex] = this.GetYPoint(value, currentSeries, rangeArea, pointIndex);
                pointsEnd[pointIndex] = this.GetYPoint(valueEnd, currentSeries, rangeArea, pointIndex);
            }
            this.RenderAreas(context, geom, points, pointsEnd, currentSeries);
            this.RenderLines(context, geom, points, currentSeries.getValues(), currentSeries);
            this.RenderLines(context, geom, pointsEnd, currentSeries.getValuesEnd(), currentSeries);
            double posY = 0.0;
            IStiAxisSeriesLabels labels = currentSeries.getCore().GetSeriesLabels();
            if (labels == null || !labels.getVisible()) continue;
            for (int pointIndex = 0; pointIndex < valuesCount; ++pointIndex) {
                StiSeriesLabelsGeom seriesLabelsGeom;
                StiPoint startPoint;
                Double value = currentSeries.getValues()[pointIndex];
                Double valueEnd = currentSeries.getValuesEnd()[pointIndex];
                if (value == null && currentSeries.getShowNulls()) {
                    value = 0.0;
                }
                if (valueEnd == null && currentSeries.getShowNulls()) {
                    value = 0.0;
                }
                Double seriesValue = value;
                if (rangeArea.getReverseVert() && value != null) {
                    seriesValue = -seriesValue.doubleValue();
                }
                Double seriesValueEnd = valueEnd;
                if (rangeArea.getReverseVert() && valueEnd != null) {
                    seriesValueEnd = -seriesValueEnd.doubleValue();
                }
                posY = currentSeries.getYAxis() == StiSeriesYAxis.LeftYAxis ? rangeArea.getAxisCore().GetDividerY() : rangeArea.getAxisCore().GetDividerRightY();
                StiPoint endPoint = points[pointIndex];
                StiPoint endPointEnd = pointsEnd[pointIndex];
                if (endPoint != null) {
                    startPoint = new StiPoint(endPoint.getValue().x, posY);
                    if ((labels.getStep() == 0 || pointIndex % labels.getStep() == 0) && (seriesLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currentSeries, context, this.CorrectPoint(endPoint.getValue(), rect, (double)currentSeries.getLabelsOffset() * context.Options.zoom), this.CorrectPoint(startPoint, rect, (double)currentSeries.getLabelsOffset() * context.Options.zoom), pointIndex, seriesValue, value, rangeArea.getAxisCore().GetArgumentLabel((StiStripLineXF)rangeArea.getXAxis().getInfo().StripLines.get(pointIndex), currentSeries), this.GetTag(pointIndex), 0, 1, rect, null)) != null) {
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(seriesLabelsGeom);
                        seriesLabelsGeom.setClientRectangle(this.CheckLabelsRect((IStiSeriesLabels)labels, geom, seriesLabelsGeom.getClientRectangle()));
                    }
                }
                if (endPointEnd == null) continue;
                startPoint = new StiPoint(endPointEnd.getValue().x, posY);
                if (labels.getStep() != 0 && pointIndex % labels.getStep() != 0 || (seriesLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currentSeries, context, this.CorrectPoint(endPointEnd.getValue(), rect, (double)currentSeries.getLabelsOffset() * context.Options.zoom), this.CorrectPoint(startPoint, rect, (double)currentSeries.getLabelsOffset() * context.Options.zoom), pointIndex, seriesValueEnd, valueEnd, rangeArea.getAxisCore().GetArgumentLabel((StiStripLineXF)rangeArea.getXAxis().getInfo().StripLines.get(pointIndex), currentSeries), this.GetTag(pointIndex), 0, 1, rect, null)) == null) continue;
                geom.CreateChildGeoms();
                geom.getChildGeoms().add(seriesLabelsGeom);
                seriesLabelsGeom.setClientRectangle(this.CheckLabelsRect((IStiSeriesLabels)labels, geom, seriesLabelsGeom.getClientRectangle()));
            }
        }
    }

    private void RenderAreas(StiContext context, StiAreaGeom geom, StiPoint[] points, StiPoint[] pointsEnd, IStiSteppedRangeSeries series) {
        if (points == null || points.length <= 1) {
            return;
        }
        if (pointsEnd == null || pointsEnd.length <= 1) {
            return;
        }
        StiSteppedRangeSeriesGeom seriesGeom = new StiSteppedRangeSeriesGeom(geom, points, pointsEnd, series);
        if (seriesGeom != null) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesGeom);
        }
    }

    private void RenderLines(StiContext context, StiAreaGeom geom, StiPoint[] points, Double[] values, IStiSteppedRangeSeries series) {
        IStiSteppedRangeSeries lineSeries;
        IStiSteppedRangeSeries iStiSteppedRangeSeries = lineSeries = series instanceof IStiSteppedLineSeries ? series : null;
        if (points.length > 1 || lineSeries.getPointAtCenter() && points.length > 0) {
            StiSteppedLineSeriesGeom seriesGeom = new StiSteppedLineSeriesGeom(geom, null, points, series);
            if (seriesGeom != null) {
                geom.CreateChildGeoms();
                geom.getChildGeoms().add(seriesGeom);
            }
            if (this.getInteraction() != null) {
                seriesGeom.setInteractions(this.GetInteractions(context, geom, points));
            }
        }
        this.RenderMarkers(context, geom, points, values, series);
    }

    private void RenderMarkers(StiContext context, StiAreaGeom geom, StiPoint[] points, Double[] values, IStiSteppedRangeSeries series) {
        IStiSteppedRangeSeries lineSeries;
        IStiArea tempVar = geom.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        IStiSteppedRangeSeries iStiSteppedRangeSeries = lineSeries = series instanceof IStiBaseLineSeries ? series : null;
        if (points.length == 0) {
            return;
        }
        if (lineSeries.getMarker() != null && lineSeries.getMarker().getVisible()) {
            int index = 0;
            for (StiPoint point : points) {
                if (point != null) {
                    StiMarkerGeom markerGeom;
                    Double value;
                    Double d = value = axisArea.getReverseHor() ? values[lineSeries.getValues().length - index - 1] : values[index];
                    if (value == null && lineSeries.getShowNulls()) {
                        value = 0.0;
                    }
                    StiRectangle clipRect = ((StiAxisAreaGeom)geom).getView().getClientRectangle();
                    clipRect.x = 0.0;
                    clipRect.y = 0.0;
                    clipRect.inflate(10, 10);
                    StiPoint valuePoint = point.getValue();
                    valuePoint.x += geom.getClientRectangle().x;
                    valuePoint.y += geom.getClientRectangle().y;
                    if (clipRect.contains(valuePoint) && (markerGeom = new StiMarkerGeom(series, index, value == null ? 0.0 : value, point.getValue(), lineSeries.getMarker(), lineSeries.getShowShadow(), context.Options.zoom)) != null) {
                        if (lineSeries.getCore().getInteraction() != null) {
                            StiSeriesInteractionData data = new StiSeriesInteractionData();
                            data.Fill(axisArea, lineSeries, index);
                            markerGeom.setInteraction(data);
                        }
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(markerGeom);
                    }
                }
                ++index;
            }
        }
    }

    private StiPoint GetYPoint(Double value, IStiSteppedRangeSeries currentSeries, IStiSteppedRangeArea axisArea, int index) {
        StiPoint point;
        double posX;
        double d = posX = axisArea.getXAxis().getCore().GetStartFromZero() ? axisArea.getXAxis().getInfo().StripPositions[index + 1] : axisArea.getXAxis().getInfo().StripPositions[index];
        if (value == null && !currentSeries.getShowNulls()) {
            point = null;
        } else {
            if (value == null && currentSeries.getShowNulls()) {
                value = 0.0;
            }
            if (axisArea.getReverseVert() && value != null) {
                value = -value.doubleValue();
            }
            double srY = 0.0;
            srY = currentSeries.getYAxis() == StiSeriesYAxis.LeftYAxis ? -(value == null ? 0.0 : value) * (double)((float)axisArea.getYAxis().getInfo().Dpi) + axisArea.getAxisCore().GetDividerY() : -(value == null ? 0.0 : value) * (double)((float)axisArea.getYRightAxis().getInfo().Dpi) + axisArea.getAxisCore().GetDividerRightY();
            point = new StiPoint(posX, (double)((float)srY));
        }
        return point;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"SteppedRange");
    }

    public StiSteppedRangeSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

