/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.range;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.series.clusteredColumn.StiClusteredColumnSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.range.StiRangeBarElementGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.range.IStiRangeBarArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.range.IStiRangeBarSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import java.util.ArrayList;

public class StiRangeBarSeriesCoreXF
extends StiClusteredColumnSeriesCoreXF {
    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] series) {
        ArrayList<StiSeriesLabelsGeom> seriesLabelsList = new ArrayList<StiSeriesLabelsGeom>();
        if (series == null || series.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        IStiArea tempVar = geom.getArea();
        IStiRangeBarArea rangeArea = (IStiRangeBarArea)(tempVar instanceof IStiRangeBarArea ? tempVar : null);
        IStiSeries tempVar2 = this.getSeries();
        double posX = rangeArea.getAxisCore().GetDividerX();
        double posY = rangeArea.getAxisCore().GetDividerY();
        Integer time = StiChartHelper.GlobalBeginTimeElement;
        for (IStiSeries currSeries1 : series) {
            IStiRangeBarSeries currSeries = (IStiRangeBarSeries)currSeries1;
            int valuesCount = currSeries.getValues().length;
            if (currSeries.getValuesEnd().length < valuesCount) {
                valuesCount = currSeries.getValuesEnd().length;
            }
            int argumentsCount = currSeries.getArguments().length;
            int count = Math.min(valuesCount, argumentsCount);
            for (int index = 0; index < count; ++index) {
                Double nullableValue = currSeries.getValues()[index];
                Double nullableValueEnd = currSeries.getValuesEnd()[index];
                if (nullableValue == null) {
                    nullableValue = 0.0;
                }
                if (nullableValueEnd == null) {
                    nullableValueEnd = 0.0;
                }
                double seriesHeight = Math.abs(nullableValue - nullableValueEnd) * rangeArea.getYAxis().getInfo().Dpi;
                double seriesTopPos = posY;
                double value = Math.max(nullableValue, nullableValueEnd);
                seriesTopPos = rangeArea.getReverseVert() ? (seriesTopPos += Math.min(nullableValue, nullableValueEnd) * rangeArea.getYAxis().getInfo().Dpi) : (seriesTopPos -= value * rangeArea.getYAxis().getInfo().Dpi);
                int argumentIndex = rangeArea.getXAxis().getInfo().StripLines.size() - 1;
                for (StiStripLineXF line : rangeArea.getXAxis().getInfo().StripLines) {
                    if (currSeries.getArguments()[index].toString().equals(line.getValueObject().toString())) break;
                    --argumentIndex;
                }
                argumentIndex = rangeArea.getXAxis().getInfo().StripLines.size() - 1 - argumentIndex;
                double seriesWidth = (rangeArea.getXAxis().getInfo().Step - rangeArea.getXAxis().getInfo().Step * (double)(1.0f - currSeries.getWidth())) / (double)series.length;
                double seriesLeftPos = posX - seriesWidth / 2.0;
                StiRectangle seriesRect = new StiRectangle(seriesLeftPos += rangeArea.getXAxis().getInfo().Step * (double)argumentIndex, seriesTopPos, seriesWidth, seriesHeight);
                StiRangeBarElementGeom seriesGeom = new StiRangeBarElementGeom(geom, value, index, (IStiSeries)currSeries, seriesRect, time / count * index);
                if (currSeries.getCore().getInteraction() != null) {
                    StiSeriesInteractionData data = new StiSeriesInteractionData();
                    data.Fill(rangeArea, currSeries, index);
                    seriesGeom.setInteraction(data);
                }
                geom.CreateChildGeoms();
                geom.getChildGeoms().add(seriesGeom);
                IStiAxisSeriesLabels labels = currSeries.getCore().GetSeriesLabels();
                if (labels == null || !labels.getVisible()) continue;
                StiPoint pointValueEndLabels = new StiPoint(seriesLeftPos + seriesWidth / 2.0, (double)((float)seriesTopPos));
                StiPoint pointValueLabels = new StiPoint(seriesLeftPos + seriesWidth / 2.0, (double)((float)seriesTopPos + (float)seriesHeight));
                if (labels.getStep() != 0 && index % labels.getStep() != 0) continue;
                if (nullableValueEnd < nullableValue) {
                    Double temp = nullableValue;
                    nullableValue = nullableValueEnd;
                    nullableValueEnd = temp;
                }
                StiSeriesLabelsGeom seriesValueLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currSeries, context, pointValueLabels, pointValueLabels, index, nullableValue, nullableValue, currSeries.getArguments()[index].toString(), this.GetTag(index), 0, 1, rect, null);
                StiSeriesLabelsGeom seriesValueEndLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currSeries, context, pointValueEndLabels, pointValueEndLabels, index, nullableValueEnd, nullableValueEnd, currSeries.getArguments()[index].toString(), this.GetTag(index), 0, 1, rect, null);
                if (seriesValueEndLabelsGeom != null) {
                    seriesLabelsList.add(seriesValueEndLabelsGeom);
                    seriesValueEndLabelsGeom.setClientRectangle(this.CheckLabelsRect((IStiSeriesLabels)labels, geom, seriesValueEndLabelsGeom.getClientRectangle()));
                }
                if (seriesValueLabelsGeom == null) continue;
                seriesLabelsList.add(seriesValueLabelsGeom);
                seriesValueLabelsGeom.setClientRectangle(this.CheckLabelsRect((IStiSeriesLabels)labels, geom, seriesValueLabelsGeom.getClientRectangle()));
            }
        }
        for (StiSeriesLabelsGeom seriesLabelsGeom : seriesLabelsList) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesLabelsGeom);
        }
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"RangeBar");
    }

    public StiRangeBarSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

