/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.funnel;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiCloseFigureSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLinesSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiSegmentGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.series.StiSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.funnel.StiFunnelSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.funnel.StiFunnelSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.funnel.IStiFunnelSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.funnel.IStiFunnelSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import com.stimulsoft.report.chart.view.seriesLabels.funnel.StiOutsideLeftFunnelLabels;
import java.util.ArrayList;

public class StiFunnelSeriesCoreXF
extends StiSeriesCoreXF {
    private IStiFunnelSeriesLabels labels;

    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        IStiSeries tempVar = this.getSeries();
        IStiFunnelSeries funnelSeries = (IStiFunnelSeries)(tempVar instanceof IStiFunnelSeries ? tempVar : null);
        if (funnelSeries.getAllowApplyStyle()) {
            funnelSeries.setBrush(style.getCore().GetColumnBrush(color));
            funnelSeries.setBorderColor(style.getCore().GetColumnBorder(color));
        }
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] seriesArray) {
        if (seriesArray == null || seriesArray.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        int colorCount = 0;
        for (IStiSeries ser : seriesArray) {
            if (ser.getValues() == null) continue;
            colorCount += ser.getValues().length;
        }
        if (colorCount == 0) {
            return;
        }
        int colorIndex = 0;
        for (IStiSeries ser : seriesArray) {
            double value;
            IStiFunnelSeries funnelSeries = (IStiFunnelSeries)(ser instanceof IStiFunnelSeries ? ser : null);
            ArrayList<Double> valuesTemp = this.GetValues(funnelSeries);
            Double[] values = new Double[valuesTemp.size()];
            values = valuesTemp.toArray(values);
            IStiSeriesLabels tempVar = this.getSeries().getChart().getSeriesLabels();
            this.labels = (IStiFunnelSeriesLabels)(tempVar instanceof IStiFunnelSeriesLabels ? tempVar : null);
            double singleValueHeight = this.GetSingleValueHeight(values, rect);
            double singleValueWidth = this.GetSingleValueWidth(funnelSeries, rect);
            StiRectangle measureRect = rect.clone();
            StiRectangle measureRectTemp = rect.clone();
            if (this.labels != null && this.labels.getVisible()) {
                colorIndex = 0;
                for (int pointIndex = 0; pointIndex < values.length; ++pointIndex) {
                    if (ser.getValues().length > pointIndex) {
                        double valueNext;
                        double value2 = values[pointIndex];
                        double d = valueNext = pointIndex == values.length - 1 ? value2 : values[pointIndex + 1];
                        if (this.labels.getStep() == 0 || pointIndex % this.labels.getStep() == 0) {
                            StiRefObject tempRef_measureRect = new StiRefObject((Object)measureRect);
                            StiSeriesLabelsGeom seriesLabelsGeom = ((StiFunnelSeriesLabelsCoreXF)this.labels.getCore()).RenderLabel(ser, context, pointIndex, value2, valueNext, this.GetArgumentText(ser, pointIndex), this.GetTag(pointIndex), colorIndex, colorCount, rect, singleValueHeight, singleValueWidth, 1.0, (StiRefObject<StiRectangle>)tempRef_measureRect);
                            measureRect = ((StiRectangle)tempRef_measureRect.argvalue).clone();
                            measureRectTemp = measureRect.width < measureRectTemp.width ? measureRect : measureRectTemp;
                        }
                    }
                    ++colorIndex;
                }
                measureRect = measureRectTemp.clone();
            }
            colorIndex = 0;
            singleValueHeight = this.GetSingleValueHeight(values, measureRect);
            singleValueWidth = this.GetSingleValueWidth(funnelSeries, measureRect);
            double centerAxis = this.labels instanceof StiOutsideLeftFunnelLabels ? measureRect.width / 2.0 + measureRect.x : measureRect.width / 2.0;
            Integer beginTime = StiChartHelper.GlobalBeginTimeElement;
            for (int index = 0; index < values.length; ++index) {
                StiFunnelSeriesElementGeom funnelElementGeom;
                value = values[index];
                double valueNext = index == values.length - 1 ? value : values[index + 1];
                StiBrush seriesBrush = funnelSeries.getBrush();
                if (funnelSeries.getAllowApplyBrush()) {
                    seriesBrush = funnelSeries.getCore().GetSeriesBrush(colorIndex, colorCount);
                    seriesBrush = funnelSeries.ProcessSeriesColors(colorIndex, seriesBrush);
                }
                StiColor borderColor = funnelSeries.getBorderColor();
                if (funnelSeries.getAllowApplyBorderColor()) {
                    borderColor = (StiColor)funnelSeries.getCore().GetSeriesBorderColor(colorIndex, colorCount);
                }
                if ((funnelElementGeom = this.RenderFunnelElement(context, borderColor, seriesBrush, value, valueNext, index, ser, geom, measureRect, singleValueHeight, singleValueWidth, beginTime / ser.getValues().length * index)) != null) {
                    if (ser.getCore().getInteraction() != null) {
                        StiSeriesInteractionData data = new StiSeriesInteractionData();
                        data.Fill(geom.getArea(), ser, index);
                        funnelElementGeom.setInteraction(data);
                    }
                    geom.CreateChildGeoms();
                    geom.getChildGeoms().add(funnelElementGeom);
                }
                ++colorIndex;
            }
            if (this.labels == null || !this.labels.getVisible()) continue;
            colorIndex = 0;
            for (int pointIndex = 0; pointIndex < values.length; ++pointIndex) {
                if (ser.getValues().length > pointIndex) {
                    double valueNext;
                    value = values[pointIndex];
                    double d = valueNext = pointIndex == values.length - 1 ? value : values[pointIndex + 1];
                    if (this.labels.getStep() == 0 || pointIndex % this.labels.getStep() == 0) {
                        StiRefObject tempRef_measureRect2 = new StiRefObject((Object)measureRect);
                        StiSeriesLabelsGeom seriesLabelsGeom = ((StiFunnelSeriesLabelsCoreXF)this.labels.getCore()).RenderLabel(ser, context, pointIndex, value, valueNext, this.GetArgumentText(ser, pointIndex), this.GetTag(pointIndex), colorIndex, colorCount, rect, singleValueHeight, singleValueWidth, centerAxis, (StiRefObject<StiRectangle>)tempRef_measureRect2);
                        measureRect = ((StiRectangle)tempRef_measureRect2.argvalue).clone();
                        if (seriesLabelsGeom != null) {
                            geom.CreateChildGeoms();
                            geom.getChildGeoms().add(seriesLabelsGeom);
                            seriesLabelsGeom.setClientRectangle(this.CheckLabelsRect((IStiSeriesLabels)this.labels, geom, seriesLabelsGeom.getClientRectangle()));
                        }
                    }
                }
                ++colorIndex;
            }
        }
    }

    private ArrayList<Double> GetValues(IStiFunnelSeries funnelSeries) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (Double value : funnelSeries.getValues()) {
            if (!funnelSeries.getShowZeros() && (value == null ? 0.0 : value) == 0.0) continue;
            values.add(value == null ? 0.0 : value);
        }
        return values;
    }

    private String GetArgumentText(IStiSeries series, int index) {
        if (series.getArguments().length > index && series.getArguments()[index] != null) {
            return series.getArguments()[index].toString();
        }
        return "";
    }

    private StiFunnelSeriesElementGeom RenderFunnelElement(StiContext context, StiColor borderColor, StiBrush brush, double value, double valueNext, int index, IStiSeries currentSeries, StiAreaGeom geom, StiRectangle rect, double singleValueHeight, double singleValueWidth, Integer beginTime) {
        ArrayList path = null;
        StiRefObject tempRef_path = new StiRefObject(path);
        this.MeasureFunnelElementCore((StiRefObject<ArrayList<StiSegmentGeom>>)tempRef_path, value, valueNext, index, rect, singleValueHeight, singleValueWidth);
        path = (ArrayList)tempRef_path.argvalue;
        return new StiFunnelSeriesElementGeom(geom, value, index, currentSeries, rect, brush, borderColor, path, beginTime);
    }

    private double GetSingleValueHeight(Double[] values, StiRectangle rect) {
        int count = 0;
        Double[] doubleArray = values;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double value = doubleArray[i];
            ++count;
        }
        return rect.height * (double)0.9f / (double)count;
    }

    private double GetSingleValueWidth(IStiFunnelSeries funnelSeries, StiRectangle rect) {
        float maxValue = 0.0f;
        for (Double value : funnelSeries.getValues()) {
            maxValue = (double)maxValue > (value == null ? 0.0 : value) ? maxValue : (float)(value == null ? 0.0 : value);
        }
        return rect.width * (double)0.9f / (double)maxValue;
    }

    private void MeasureFunnelElementCore(StiRefObject<ArrayList<StiSegmentGeom>> path, double value, double valueNext, int index, StiRectangle rect, double singleValueHeight, double singleValueWidth) {
        path.argvalue = new ArrayList();
        double indent = rect.height * (double)0.05f;
        double center = this.labels instanceof StiOutsideLeftFunnelLabels ? rect.width / 2.0 + rect.x : rect.width / 2.0;
        StiPoint pointLeftTop = new StiPoint(center - (double)((float)value / 2.0f) * singleValueWidth, singleValueHeight * (double)index + indent);
        StiPoint pointRightTop = new StiPoint(center + (double)((float)value / 2.0f) * singleValueWidth, singleValueHeight * (double)index + indent);
        StiPoint pointRightBottom = new StiPoint(center + (double)((float)valueNext / 2.0f) * singleValueWidth, singleValueHeight * (double)(index + 1) + indent);
        StiPoint pointLeftBottom = new StiPoint(center - (double)((float)valueNext / 2.0f) * singleValueWidth, singleValueHeight * (double)(index + 1) + indent);
        StiPoint[] points = new StiPoint[]{pointLeftTop, pointRightTop, pointRightBottom, pointLeftBottom};
        ((ArrayList)path.argvalue).add(new StiLinesSegmentGeom(points));
        ((ArrayList)path.argvalue).add(new StiCloseFigureSegmentGeom());
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"Funnel");
    }

    public StiFunnelSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

