/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.clusteredColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.chart.core.series.clusteredColumn.StiSplineSeriesCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiSplineAreaSeriesGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiSplineAreaSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;

public class StiSplineAreaSeriesCoreXF
extends StiSplineSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        IStiSeries tempVar = this.getSeries();
        IStiSplineAreaSeries areaSeries = (IStiSplineAreaSeries)(tempVar instanceof IStiSplineAreaSeries ? tempVar : null);
        if (areaSeries.getAllowApplyStyle()) {
            areaSeries.setBrush(style.getCore().GetAreaBrush(color));
        }
    }

    @Override
    protected void RenderAreas(StiContext context, StiAreaGeom geom, StiPoint[] pointsFrom, StiPoint[] points) {
        if (points == null || points.length <= 1) {
            return;
        }
        StiSplineAreaSeriesGeom seriesGeom = new StiSplineAreaSeriesGeom(geom, pointsFrom, points, this.getSeries());
        if (seriesGeom != null) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesGeom);
        }
    }

    @Override
    public StiBrush GetSeriesBrush(int colorIndex, int colorCount) {
        IStiSeries tempVar = this.getSeries();
        IStiSplineAreaSeries areaSeries = (IStiSplineAreaSeries)(tempVar instanceof IStiSplineAreaSeries ? tempVar : null);
        StiBrush brush = super.GetSeriesBrush(colorIndex, colorCount);
        if (brush == null) {
            return areaSeries.getBrush();
        }
        return brush;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"SplineArea");
    }

    public StiSplineAreaSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

