/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.chartTitle;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.drawing.enums.StiStringAlignment;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.chartTitle.StiChartTitleGeom;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyle;
import com.stimulsoft.report.chart.interfaces.chartTitle.IStiChartTitle;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;

public class StiChartTitleCoreXF
implements Cloneable,
IStiApplyStyle {
    private IStiChartTitle chartTitle;

    public StiChartTitleCoreXF(IStiChartTitle chartTitle) {
        this.chartTitle = chartTitle;
    }

    public final void setChartTitle(IStiChartTitle value) {
        this.chartTitle = value;
    }

    @Override
    public void applyStyle(IStiChartStyle style) {
        if (this.getChartTitle().getAllowApplyStyle()) {
            this.getChartTitle().setBrush((StiBrush)new StiSolidBrush(style.getCore().getAxisTitleColor()));
        }
    }

    public final StiCellGeom Render(StiContext context, IStiChartTitle chartTitle, StiRectangle rect) {
        if (!chartTitle.getVisible()) {
            return null;
        }
        StiFontGeom font = new StiFontGeom(chartTitle.getFont());
        StiStringFormatGeom sf = context.GetDefaultStringFormat();
        sf.setAlignment(chartTitle.getAlignment());
        StiRectangle fullRectangle = context.MeasureRotatedString(chartTitle.getText(), font, rect, sf, StiRotationMode.CenterCenter, (double)chartTitle.getDock().getValue());
        switch (chartTitle.getDock()) {
            case Top: {
                fullRectangle.height += (double)chartTitle.getSpacing();
                fullRectangle.height *= context.Options.zoom;
                fullRectangle.y = rect.y;
                if (chartTitle.getAlignment() != StiStringAlignment.Center) {
                    fullRectangle.width *= context.Options.zoom;
                }
                if (chartTitle.getAlignment() == StiStringAlignment.Near) {
                    fullRectangle.x = rect.x;
                }
                if (chartTitle.getAlignment() != StiStringAlignment.Far) break;
                fullRectangle.x = rect.x + rect.width - fullRectangle.width;
                break;
            }
            case Right: {
                fullRectangle.width += (double)chartTitle.getSpacing();
                fullRectangle.width *= context.Options.zoom;
                fullRectangle.x = rect.x + rect.width - fullRectangle.width;
                if (chartTitle.getAlignment() != StiStringAlignment.Center) {
                    fullRectangle.height *= context.Options.zoom;
                }
                if (chartTitle.getAlignment() == StiStringAlignment.Near) {
                    fullRectangle.y = rect.y;
                }
                if (chartTitle.getAlignment() != StiStringAlignment.Far) break;
                fullRectangle.y = rect.y + rect.height - fullRectangle.height;
                break;
            }
            case Bottom: {
                fullRectangle.height += (double)chartTitle.getSpacing();
                fullRectangle.height *= context.Options.zoom;
                fullRectangle.y = rect.y + rect.height - fullRectangle.height;
                if (chartTitle.getAlignment() != StiStringAlignment.Center) {
                    fullRectangle.width *= context.Options.zoom;
                }
                if (chartTitle.getAlignment() == StiStringAlignment.Near) {
                    fullRectangle.x = rect.x + rect.width - fullRectangle.width;
                }
                if (chartTitle.getAlignment() != StiStringAlignment.Far) break;
                fullRectangle.x = rect.x;
                break;
            }
            case Left: {
                fullRectangle.width += (double)chartTitle.getSpacing();
                fullRectangle.width *= context.Options.zoom;
                fullRectangle.x = rect.x;
                if (chartTitle.getAlignment() != StiStringAlignment.Center) {
                    fullRectangle.height *= context.Options.zoom;
                }
                if (chartTitle.getAlignment() == StiStringAlignment.Near) {
                    fullRectangle.y = rect.y + rect.height - fullRectangle.height;
                }
                if (chartTitle.getAlignment() != StiStringAlignment.Far) break;
                fullRectangle.y = rect.y;
            }
        }
        return new StiChartTitleGeom(chartTitle, fullRectangle);
    }

    public final IStiChartTitle getChartTitle() {
        return this.chartTitle;
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

