/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.area.range;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.chart.core.area.clusteredColumn.StiClusteredColumnAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.enums.StiChartAreaPosition;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxis;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.range.IStiRangeBarSeries;
import java.util.ArrayList;

public class StiRangeBarAreaCoreXF
extends StiClusteredColumnAreaCoreXF {
    @Override
    protected void CreateStripLinesXAxis(IStiAxis axis) {
        axis.getInfo().StripLines.clear();
        axis.getInfo().StripLines.add(new StiStripLineXF(0, 0.0));
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        for (IStiSeries series : seriesCollection) {
            for (Object argument : series.getArguments()) {
                boolean notExist = true;
                for (StiStripLineXF line : axis.getInfo().StripLines) {
                    if (!line.getValueObject().toString().equals(argument.toString())) continue;
                    notExist = false;
                }
                if (!notExist) continue;
                axis.getInfo().StripLines.add(new StiStripLineXF(argument, axis.getInfo().StripLines.size()));
            }
        }
        axis.getInfo().StripLines.add(new StiStripLineXF("", axis.getInfo().StripLines.size()));
        if (axis.getInfo().StripLines.size() > 0 && !axis.getArea().getXAxis().getShowEdgeValues()) {
            ((StiStripLineXF)axis.getInfo().StripLines.get(0)).setValueObject("");
            ((StiStripLineXF)axis.getInfo().StripLines.get(axis.getInfo().StripLines.size() - 1)).setValueObject("");
        }
    }

    @Override
    protected void PrepareRange(IStiAxis specXAxis, IStiAxis specXTopAxis, IStiAxis specYAxis, IStiAxis specYRightAxis) {
        specXAxis.getInfo().Maximum = 0.0;
        specXAxis.getInfo().Minimum = 0.0;
        specYAxis.getInfo().Maximum = 0.0;
        specYAxis.getInfo().Minimum = 0.0;
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        boolean first = true;
        for (IStiSeries series1 : seriesCollection) {
            IStiRangeBarSeries series = (IStiRangeBarSeries)series1;
            for (Double value : series.getValues()) {
                if (value == null) continue;
                if (first) {
                    first = false;
                    specYAxis.getInfo().Maximum = value;
                    specYAxis.getInfo().Minimum = value;
                    continue;
                }
                specYAxis.getInfo().Maximum = Math.max(specYAxis.getInfo().Maximum, value);
                specYAxis.getInfo().Minimum = Math.min(specYAxis.getInfo().Minimum, value);
            }
            for (Double value : series.getValuesEnd()) {
                if (value == null) continue;
                specYAxis.getInfo().Maximum = Math.max(specYAxis.getInfo().Maximum, value);
                specYAxis.getInfo().Minimum = Math.min(specYAxis.getInfo().Minimum, value);
            }
        }
        specYRightAxis.getInfo().Maximum = specYAxis.getInfo().Maximum;
        specYRightAxis.getInfo().Minimum = specYAxis.getInfo().Minimum;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"RangeBar");
    }

    @Override
    public int getPosition() {
        return StiChartAreaPosition.RangeBar.getValue();
    }

    public StiRangeBarAreaCoreXF(IStiArea area) {
        super(area);
    }
}

