/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.area.radar;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineCalculatorXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripPositionXF;
import com.stimulsoft.report.chart.core.radarAxis.StiXRadarAxisCoreXF;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.areas.StiRadarAreaGeom;
import com.stimulsoft.report.chart.geoms.radarAxis.StiRadarAxisGeom;
import com.stimulsoft.report.chart.geoms.radarAxis.StiXRadarAxisLabelGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.radar.IStiRadarArea;
import com.stimulsoft.report.chart.interfaces.radarAxis.IStiYRadarAxis;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.series.StiSeriesCollection;
import java.util.ArrayList;
import java.util.Hashtable;

public abstract class StiRadarAreaCoreXF
extends StiAreaCoreXF {
    public int ValuesCount = 0;
    public ArrayList<StiPoint> Points = new ArrayList();
    public ArrayList<Object> Arguments = new ArrayList();
    public StiPoint CenterPoint = StiPoint.getEmpty();

    @Override
    public void applyStyle(IStiChartStyle style) {
        super.applyStyle(style);
        IStiArea tempVar = this.getArea();
        IStiRadarArea radarArea = (IStiRadarArea)(tempVar instanceof IStiRadarArea ? tempVar : null);
        if (radarArea.getAllowApplyStyle()) {
            if (radarArea.getInterlacingHor() != null) {
                radarArea.getInterlacingHor().getCore().applyStyle(style);
            }
            if (radarArea.getInterlacingVert() != null) {
                radarArea.getInterlacingVert().getCore().applyStyle(style);
            }
            if (radarArea.getGridLinesHor() != null) {
                radarArea.getGridLinesHor().getCore().applyStyle(style);
            }
            if (radarArea.getGridLinesVert() != null) {
                radarArea.getGridLinesVert().getCore().applyStyle(style);
            }
            if (radarArea.getXAxis() != null) {
                radarArea.getXAxis().getCore().applyStyle(style);
            }
            if (radarArea.getYAxis() != null) {
                radarArea.getYAxis().getCore().applyStyle(style);
            }
            radarArea.setBrush((StiBrush)new StiEmptyBrush());
        }
    }

    @Override
    public StiCellGeom Render(StiContext context, StiRectangle areaRect) {
        IStiArea tempVar = this.getArea();
        IStiRadarArea radarArea = (IStiRadarArea)(tempVar instanceof IStiRadarArea ? tempVar : null);
        StiRectangle rect = areaRect.clone();
        rect = StiRadarAreaCoreXF.CenterArea(rect);
        this.PrepareInfo(rect);
        rect = this.MeasureLabels(context, rect);
        rect = StiRadarAreaCoreXF.CenterArea(rect);
        rect = new StiRectangle(areaRect.x + (areaRect.width - rect.width) / 2.0, areaRect.y + (areaRect.height - rect.height) / 2.0, rect.width, rect.height);
        this.PrepareInfo(rect);
        StiRadarAreaGeom areaGeom = new StiRadarAreaGeom(this.getArea(), rect, this.ValuesCount);
        StiCellGeom tempVar2 = radarArea.getYAxis().getYCore().Render(context, rect);
        StiRadarAxisGeom axisGeom = (StiRadarAxisGeom)(tempVar2 instanceof StiRadarAxisGeom ? tempVar2 : null);
        if (axisGeom != null) {
            areaGeom.CreateChildGeoms();
            areaGeom.getChildGeoms().add(axisGeom);
        }
        if (this.getArea().getChart().getSeries().size() > 0) {
            StiSeriesCollection tempVar3 = this.getArea().getChart().getSeries();
            this.RenderArguments(context, areaGeom, (IStiSeries)((Object)(tempVar3 instanceof IStiSeries ? tempVar3 : null)));
        }
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        this.RenderSeries(context, rect, areaGeom, seriesCollection);
        return areaGeom;
    }

    private static StiRectangle CenterArea(StiRectangle rect) {
        if (rect.width > rect.height) {
            rect.width = rect.height;
        } else {
            rect.height = rect.width;
        }
        return rect;
    }

    public final StiRectangle MeasureLabels(StiContext context, StiRectangle rect) {
        if (this.ValuesCount == 0) {
            return rect;
        }
        IStiArea tempVar = this.getArea();
        IStiRadarArea radarArea = (IStiRadarArea)(tempVar instanceof IStiRadarArea ? tempVar : null);
        if (radarArea.getXAxis() != null && radarArea.getXAxis().getVisible()) {
            double radius = radarArea.getYAxis().getInfo().StripPositions[radarArea.getYAxis().getInfo().StripPositions.length - 1] + 4.0 * context.Options.zoom;
            int pointIndex = 0;
            float arc = 360 / this.ValuesCount;
            float angle = 0.0f;
            StiRectangle areaRect = rect.clone();
            for (StiPoint curPoint : this.Points) {
                Object argument = pointIndex < this.Arguments.size() ? this.Arguments.get(pointIndex) : null;
                StiPoint point = new StiPoint(this.CenterPoint.x + radius * curPoint.x, this.CenterPoint.y + radius * curPoint.y);
                String argumentText = ((StiXRadarAxisCoreXF)radarArea.getXAxis().getCore()).GetLabelText(argument);
                StiRectangle labelRect = radarArea.getXAxis().getXCore().GetLabelRect(context, point, argumentText, angle);
                if (!labelRect.isEmpty().booleanValue()) {
                    areaRect = StiRectangle.union((StiRectangle)areaRect, (StiRectangle)labelRect);
                }
                angle += arc;
                ++pointIndex;
            }
            double distLeft = rect.getLeft() - areaRect.getLeft();
            double distRight = areaRect.getRight() - rect.getRight();
            double distTop = rect.getTop() - areaRect.getTop();
            double distBottom = areaRect.getBottom() - rect.getBottom();
            if (distLeft > 0.0) {
                rect.width -= distLeft;
            }
            if (distRight > 0.0) {
                rect.width -= distRight;
            }
            if (distTop > 0.0) {
                rect.height -= distTop;
            }
            if (distBottom > 0.0) {
                rect.height -= distBottom;
            }
        }
        return rect;
    }

    public final void RenderArguments(StiContext context, StiRadarAreaGeom geom, IStiSeries series) {
        IStiArea tempVar = this.getArea();
        IStiRadarArea radarArea = (IStiRadarArea)(tempVar instanceof IStiRadarArea ? tempVar : null);
        if (radarArea.getXAxis() != null && radarArea.getXAxis().getVisible() && radarArea.getYAxis().getInfo().StripPositions != null) {
            double radius = radarArea.getYAxis().getInfo().StripPositions[radarArea.getYAxis().getInfo().StripPositions.length - 1] + 4.0 * context.Options.zoom;
            int pointIndex = 0;
            float arc = 360 / this.ValuesCount;
            float angle = 0.0f;
            for (StiPoint curPoint : this.Points) {
                Object argument = pointIndex < this.Arguments.size() ? this.Arguments.get(pointIndex) : null;
                StiPoint point = new StiPoint(this.CenterPoint.x + radius * curPoint.x, this.CenterPoint.y + radius * curPoint.y);
                point.x -= geom.getClientRectangle().x;
                point.y -= geom.getClientRectangle().y;
                StiXRadarAxisLabelGeom labelGeom = radarArea.getXAxis().getXCore().RenderLabel(context, series, point, argument, angle, pointIndex, this.ValuesCount);
                if (labelGeom != null) {
                    geom.CreateChildGeoms();
                    geom.getChildGeoms().add(labelGeom);
                }
                angle += arc;
                ++pointIndex;
            }
        }
    }

    public final void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, ArrayList<IStiSeries> seriesCollection) {
        ArrayList<ArrayList<IStiSeries>> seriesTypes = new ArrayList<ArrayList<IStiSeries>>();
        Hashtable seriesTypesHash = new Hashtable();
        for (IStiSeries iStiSeries : seriesCollection) {
            ArrayList<IStiSeries> list = seriesTypesHash.get(iStiSeries.getClass()) instanceof ArrayList ? seriesTypesHash.get(iStiSeries.getClass()) : null;
            if (list == null) {
                list = new ArrayList<IStiSeries>();
                seriesTypes.add(list);
                seriesTypesHash.put(iStiSeries.getClass(), list);
            }
            list.add(iStiSeries);
        }
        for (ArrayList arrayList : seriesTypes) {
            IStiSeries[] seriesArray = new IStiSeries[arrayList.size()];
            seriesArray = arrayList.toArray(seriesArray);
            seriesArray[0].getCore().RenderSeries(context, rect, geom, seriesArray);
        }
    }

    @Override
    protected void PrepareInfo(StiRectangle rect) {
        IStiArea tempVar = this.getArea();
        IStiRadarArea radarArea = (IStiRadarArea)(tempVar instanceof IStiRadarArea ? tempVar : null);
        this.ValuesCount = 0;
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        if (seriesCollection.size() > 0) {
            for (int index = 0; index < seriesCollection.size(); ++index) {
                Double[] values = seriesCollection.get(index).getValues();
                if (values == null) continue;
                this.ValuesCount = Math.max(values.length, this.ValuesCount);
            }
        }
        this.Arguments = new ArrayList();
        if (seriesCollection.size() > 0) {
            IStiSeries curSeries = seriesCollection.get(0);
            for (IStiSeries series : seriesCollection) {
                if (series.getArguments().length != this.ValuesCount) continue;
                curSeries = series;
                break;
            }
            for (int index = 0; index < this.ValuesCount; ++index) {
                if (index >= curSeries.getArguments().length) continue;
                this.Arguments.add(curSeries.getArguments()[index].toString());
            }
        } else {
            this.Arguments.add("1");
            this.Arguments.add("2");
            this.Arguments.add("3");
            this.Arguments.add("4");
            this.Arguments.add("5");
        }
        this.CenterPoint = new StiPoint(rect.x + rect.width / 2.0, rect.y + rect.height / 2.0);
        double arc = 0.0;
        arc = this.ValuesCount > 0 ? (double)(360 / this.ValuesCount) : 72.0;
        this.Points = new ArrayList();
        double radius = rect.width / 2.0;
        for (double angle = 0.0; angle < 360.0; angle += arc) {
            float radAngle = (float)((double)((float)angle - 90.0f) * Math.PI / 180.0);
            StiPoint endPoint = new StiPoint((double)((float)Math.cos(radAngle)), (double)((float)Math.sin(radAngle)));
            this.Points.add(endPoint);
            if (this.Points.size() != this.ValuesCount) continue;
            break;
        }
        double minimum = 0.0;
        double maximum = 0.0;
        boolean firstValue = true;
        for (int index = 0; index < seriesCollection.size(); ++index) {
            Double[] values = seriesCollection.get(index).getValues();
            if (values == null) continue;
            for (Double value : values) {
                if (value == null) continue;
                if (firstValue) {
                    minimum = value;
                    maximum = value;
                    firstValue = false;
                    continue;
                }
                minimum = Math.min(minimum, value);
                maximum = Math.max(maximum, value);
            }
        }
        if (seriesCollection.isEmpty()) {
            maximum = 1.0;
        }
        minimum = 0.0;
        this.CreateStripLinesAxis(radarArea.getYAxis(), (float)minimum, (float)maximum);
        if (radarArea.getYAxis().getInfo().StripLines != null && radarArea.getYAxis().getInfo().StripLines.size() > 0) {
            radarArea.getYAxis().getInfo().Minimum = ((StiStripLineXF)radarArea.getYAxis().getInfo().StripLines.get(radarArea.getYAxis().getInfo().StripLines.size() - 1)).getValue();
            radarArea.getYAxis().getInfo().Maximum = ((StiStripLineXF)radarArea.getYAxis().getInfo().StripLines.get(0)).getValue();
        }
        radarArea.getYAxis().getInfo().Dpi = rect.height * 0.5 / radarArea.getYAxis().getInfo().getRange();
        this.CalculateStep(radarArea.getYAxis(), 0.0, rect.height / 2.0);
        StiRefObject tempRef_LabelsCollection = new StiRefObject(radarArea.getYAxis().getInfo().LabelsCollection);
        this.CalculatePositions(radarArea.getYAxis(), (StiRefObject<ArrayList<StiStripPositionXF>>)tempRef_LabelsCollection, radarArea.getYAxis().getLabels().getStep() > 0.0 ? (int)radarArea.getYAxis().getLabels().getStep() : 1);
        radarArea.getYAxis().getInfo().LabelsCollection = (ArrayList)tempRef_LabelsCollection.argvalue;
        StiRefObject tempRef_TicksCollection = new StiRefObject(radarArea.getYAxis().getInfo().TicksCollection);
        this.CalculatePositions(radarArea.getYAxis(), (StiRefObject<ArrayList<StiStripPositionXF>>)tempRef_TicksCollection, radarArea.getYAxis().getTicks().getStep() > 0 ? radarArea.getYAxis().getTicks().getStep() : 1);
        radarArea.getYAxis().getInfo().TicksCollection = (ArrayList)tempRef_TicksCollection.argvalue;
    }

    protected void CreateStripLinesAxis(IStiYRadarAxis axis, float minimum, float maximum) {
        IStiArea tempVar = this.getArea();
        IStiRadarArea radarArea = (IStiRadarArea)(tempVar instanceof IStiRadarArea ? tempVar : null);
        double step = radarArea.getYAxis().getLabels().getStep();
        if (step == 0.0) {
            step = StiStripLineCalculatorXF.GetInterval(minimum, maximum, 6);
        }
        radarArea.getYAxis().getInfo().StripLines = StiStripLineCalculatorXF.GetStripLines(minimum, maximum, step, false);
        for (StiStripLineXF stripLine : radarArea.getYAxis().getInfo().StripLines) {
            stripLine.setValueObject(StiTextUtil.toString((Object)stripLine.getValueObject()));
        }
    }

    private void CalculateStep(IStiYRadarAxis axis, double topPosition, double bottomPosition) {
        if (axis.getInfo().StripLines.size() >= 2) {
            axis.getInfo().Step = Math.abs((float)((((StiStripLineXF)axis.getInfo().StripLines.get(1)).getValue() - ((StiStripLineXF)axis.getInfo().StripLines.get(0)).getValue()) * axis.getInfo().Dpi));
            axis.getYCore().CalculateStripPositions(topPosition, bottomPosition);
        } else {
            axis.getInfo().Step = 1.0;
        }
    }

    public final void CalculatePositions(IStiYRadarAxis axis, StiRefObject<ArrayList<StiStripPositionXF>> collection, int step) {
        collection.argvalue = new ArrayList();
        IStiArea tempVar = this.getArea();
        IStiRadarArea radarArea = (IStiRadarArea)(tempVar instanceof IStiRadarArea ? tempVar : null);
        int stepIndex = 0;
        if (axis.getInfo().StripPositions != null) {
            int length = axis.getInfo().StripPositions.length;
            for (int index = 0; index < length; ++index) {
                if (stepIndex == 0) {
                    StiStripPositionXF label = new StiStripPositionXF();
                    int stripIndex = index;
                    label.StripLine = (StiStripLineXF)axis.getInfo().StripLines.get(stripIndex);
                    label.Position = axis.getInfo().StripPositions[stripIndex];
                    ((ArrayList)collection.argvalue).add(label);
                }
                if (++stepIndex != step) continue;
                stepIndex = 0;
            }
        }
    }

    public StiRadarAreaCoreXF(IStiArea area) {
        super(area);
    }
}

