/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.area.pie;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.enums.StiChartAreaPosition;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.areas.StiPieAreaGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import java.util.ArrayList;
import java.util.Hashtable;

public class StiPieAreaCoreXF
extends StiAreaCoreXF {
    public int ValuesCount = 0;

    @Override
    public StiCellGeom Render(StiContext context, StiRectangle rect) {
        this.PrepareInfo(rect);
        StiPieAreaGeom pieAreaGeom = new StiPieAreaGeom(this.getArea(), rect);
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        this.RenderSeries(context, rect, pieAreaGeom, seriesCollection);
        return pieAreaGeom;
    }

    public final void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, ArrayList<IStiSeries> seriesCollection) {
        ArrayList<ArrayList<IStiSeries>> seriesTypes = new ArrayList<ArrayList<IStiSeries>>();
        Hashtable seriesTypesHash = new Hashtable();
        for (IStiSeries iStiSeries : seriesCollection) {
            ArrayList<IStiSeries> list = seriesTypesHash.get(iStiSeries.getClass()) instanceof ArrayList ? seriesTypesHash.get(iStiSeries.getClass()) : null;
            if (list == null) {
                list = new ArrayList<IStiSeries>();
                seriesTypes.add(list);
                seriesTypesHash.put(iStiSeries.getClass(), list);
            }
            list.add(iStiSeries);
        }
        for (ArrayList arrayList : seriesTypes) {
            IStiSeries[] seriesArray = new IStiSeries[arrayList.size()];
            seriesArray = arrayList.toArray(seriesArray);
            seriesArray[0].getCore().RenderSeries(context, rect, geom, seriesArray);
        }
    }

    @Override
    protected void PrepareInfo(StiRectangle rect) {
        this.ValuesCount = 0;
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        if (seriesCollection.size() > 0) {
            for (int index = 0; index < seriesCollection.size(); ++index) {
                Double[] values = seriesCollection.get(index).getValues();
                if (values == null) continue;
                this.ValuesCount = Math.max(values.length, this.ValuesCount);
            }
        }
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"Pie");
    }

    @Override
    public int getPosition() {
        return StiChartAreaPosition.Pie.getValue();
    }

    public StiPieAreaCoreXF(IStiArea area) {
        super(area);
    }
}

