/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;

public class StiPostnetBarCodeType
extends StiBarCodeTypeService {
    protected String PostnetSymbols = "0123456789";
    private final String[] PostnetTable = new String[]{"11000", "00011", "00101", "00110", "01001", "01010", "01100", "10001", "10010", "10100"};
    private final String PostnetStartCode = "1";
    private final String PostnetStopCode = "1";
    private double module = 20.0;
    private double space = 26.0;
    private double height = 1.0;
    protected static final double PostnetSpaceLeft = 1.0;
    protected static final double PostnetSpaceRight = 1.0;
    protected static final double PostnetSpaceTop = 0.0;
    protected static final double PostnetSpaceBottom = 1.0;
    protected static final double PostnetLineHeightLong = 6.25;
    protected static final double PostnetLineHeightShort = 2.5;
    protected static final double PostnetTextPosition = 7.25;
    protected static final double PostnetTextHeight = 5.0;
    protected static final double PostnetMainHeight = 14.0;
    protected static final double PostnetLineHeightForCut = 6.25;

    public StiPostnetBarCodeType() {
        this(20.0, 1.0, 26.0);
    }

    public StiPostnetBarCodeType(double module, double height, double space) {
        this.module = module;
        this.height = height;
        this.space = space;
    }

    public String getServiceName() {
        return "Postnet";
    }

    @Override
    @StiDefaulValue(value="20.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 20.0) {
            this.module = 20.0;
        }
        if (value > 20.0) {
            this.module = 20.0;
        }
    }

    @StiDefaulValue(value="26.0")
    @StiSerializable
    public final double getSpace() {
        return this.space;
    }

    public final void setSpace(double value) {
        this.space = value;
        if (value < 12.0) {
            this.space = 12.0;
        }
        if (value > 40.0) {
            this.space = 40.0;
        }
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 1.0) {
            this.height = 1.0;
        }
        if (value > 4.0) {
            this.height = 4.0;
        }
    }

    @Override
    public double getLabelFontHeight() {
        return 5.0;
    }

    private String CodeToBar(String inputCode) {
        StringBuilder outputBar = new StringBuilder();
        for (int index = 0; index < inputCode.length(); ++index) {
            StringBuilder currentsym = new StringBuilder();
            if (inputCode.charAt(index) == '1') {
                currentsym.append("81");
            } else {
                currentsym.append("e1");
            }
            outputBar.append((CharSequence)currentsym);
        }
        return outputBar.toString();
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        if ((code = this.CheckCodeSymbols(code, this.PostnetSymbols)).length() > 11) {
            code = code.substring(0, 11);
        }
        switch (code.length()) {
            case 0: {
                code = "00000";
                break;
            }
            case 1: {
                code = code + "0000";
                break;
            }
            case 2: 
            case 6: {
                code = code + "000";
                break;
            }
            case 3: 
            case 7: {
                code = code + "00";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                code = code + "0";
            }
        }
        StringBuilder codeText = new StringBuilder(code);
        if (code.length() == 11) {
            codeText.insert(9, "-");
        }
        if (code.length() > 5) {
            codeText.insert(5, "-");
        }
        int[] fullCode = new int[code.length() + 1];
        for (int index = 0; index < code.length(); ++index) {
            fullCode[index] = this.PostnetSymbols.indexOf(code.charAt(index));
        }
        int sum = 0;
        for (int index = 0; index < code.length(); ++index) {
            sum += fullCode[index];
        }
        if ((sum %= 10) != 0) {
            sum = 10 - sum;
        }
        fullCode[code.length()] = sum;
        StringBuilder tempBarsArray = new StringBuilder();
        tempBarsArray.append("1");
        for (int index = 0; index < fullCode.length; ++index) {
            tempBarsArray.append(this.PostnetTable[fullCode[index]]);
        }
        tempBarsArray.append("1");
        StringBuilder barsArray = new StringBuilder(this.CodeToBar(tempBarsArray.toString()));
        this.CalculateSizeFull(1.0, 1.0, 0.0, 1.0, 2.5, 6.25, 7.25, 5.0, 14.0, 6.25, this.getSpace() / this.getModule(), zoom, code, codeText.toString(), barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 20.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        jObject.AddPropertyFloat("Space", this.getSpace(), 26.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Height")) {
                this.height = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("Space")) continue;
            this.space = property.floatValue().floatValue();
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "12345";
    }
}

