/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.enums.StiPlesseyCheckSum;

public class StiPlesseyBarCodeType
extends StiBarCodeTypeService {
    protected String PlesseySymbols = "0123456789ABCDEF";
    private final String[] PlesseyTable = new String[]{"0000", "1000", "0100", "1100", "0010", "1010", "0110", "1110", "0001", "1001", "0101", "1101", "0011", "1011", "0111", "1111"};
    private final String PlesseyStartCode = "1101";
    private final String PlesseyStopCode = "11";
    private double module = 8.0;
    private double height = 1.0;
    private StiPlesseyCheckSum checkSum1 = StiPlesseyCheckSum.None;
    private StiPlesseyCheckSum checkSum2 = StiPlesseyCheckSum.None;
    protected static final double PlesseySpaceLeft = 20.0;
    protected static final double PlesseySpaceRight = 20.0;
    protected static final double PlesseySpaceTop = 0.0;
    protected static final double PlesseySpaceBottom = 1.0;
    protected static final double PlesseyLineHeightShort = 70.0;
    protected static final double PlesseyLineHeightLong = 70.0;
    protected static final double PlesseyTextPosition = 71.0;
    protected static final double PlesseyTextHeight = 11.5;
    protected static final double PlesseyMainHeight = 84.0;
    protected static final double PlesseyLineHeightForCut = 70.0;

    public StiPlesseyBarCodeType() {
        this(8.0, 1.0, StiPlesseyCheckSum.None, StiPlesseyCheckSum.None);
    }

    public StiPlesseyBarCodeType(double module, double height, StiPlesseyCheckSum checkSum1, StiPlesseyCheckSum checkSum2) {
        this.module = module;
        this.height = height;
        this.checkSum1 = checkSum1;
        this.checkSum2 = checkSum2;
    }

    public String getServiceName() {
        return "Plessey";
    }

    @Override
    @StiDefaulValue(value="8.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 1.0) {
            this.module = 1.0;
        }
        if (value > 40.0) {
            this.module = 40.0;
        }
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 0.5) {
            this.height = 0.5;
        }
        if (value > 2.0) {
            this.height = 2.0;
        }
    }

    @StiDefaulValue(value="None")
    @StiSerializable
    public final StiPlesseyCheckSum getCheckSum1() {
        return this.checkSum1;
    }

    public final void setCheckSum1(StiPlesseyCheckSum value) {
        this.checkSum1 = value;
        if (this.checkSum1 == StiPlesseyCheckSum.None) {
            this.setCheckSum2(StiPlesseyCheckSum.None);
        }
    }

    @StiDefaulValue(value="None")
    @StiSerializable
    public final StiPlesseyCheckSum getCheckSum2() {
        return this.checkSum2;
    }

    public final void setCheckSum2(StiPlesseyCheckSum value) {
        this.checkSum2 = value;
        if (this.checkSum2 != StiPlesseyCheckSum.None && this.getCheckSum1() == StiPlesseyCheckSum.None) {
            this.setCheckSum1(StiPlesseyCheckSum.Modulo10);
        }
    }

    @Override
    public double getLabelFontHeight() {
        return 11.5;
    }

    private String CodeToBar(String inputCode) {
        StringBuilder outputBar = new StringBuilder();
        for (int index = 0; index < inputCode.length(); ++index) {
            StringBuilder currentsym = new StringBuilder();
            if (inputCode.charAt(index) == '1') {
                currentsym.append("71");
            } else {
                currentsym.append("53");
            }
            outputBar.append((CharSequence)currentsym);
        }
        return outputBar.toString();
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        int multiplier;
        long sum3;
        boolean odd;
        long multiplier2;
        long sum2;
        int sum;
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, this.PlesseySymbols);
        StringBuilder codeText = new StringBuilder(code);
        int codeLength = code.length();
        if (this.getCheckSum1() != StiPlesseyCheckSum.None) {
            ++codeLength;
        }
        if (this.getCheckSum2() != StiPlesseyCheckSum.None) {
            ++codeLength;
        }
        int[] fullCode = new int[codeLength];
        for (int index = 0; index < code.length(); ++index) {
            fullCode[index] = this.PlesseySymbols.indexOf(code.charAt(index));
        }
        if (this.getCheckSum1() != StiPlesseyCheckSum.None) {
            sum = 0;
            if (this.getCheckSum1() == StiPlesseyCheckSum.Modulo10) {
                long sum1 = 0L;
                sum2 = 0L;
                multiplier2 = 1L;
                odd = false;
                for (int index = code.length() - 1; index >= 0; --index) {
                    if (!odd) {
                        sum1 += (long)fullCode[index] * multiplier2;
                        multiplier2 *= 10L;
                    } else {
                        sum2 += (long)fullCode[index];
                    }
                    odd = !odd;
                }
                sum1 *= 2L;
                sum3 = 0L;
                while (sum1 >= 10L) {
                    sum3 += sum1 % 10L;
                    sum1 /= 10L;
                }
                sum = (int)(((sum3 += sum1) + sum2) % 10L);
                if (sum != 0) {
                    sum = 10 - sum;
                }
            }
            if (this.getCheckSum1() == StiPlesseyCheckSum.Modulo11) {
                int sum1 = 0;
                multiplier = 2;
                for (int index = code.length() - 1; index >= 0; --index) {
                    sum1 += fullCode[index] * multiplier;
                    if (++multiplier <= 7) continue;
                    multiplier = 2;
                }
                sum = sum1 % 11;
                if (sum != 0) {
                    sum = 11 - sum;
                }
            }
            fullCode[code.length()] = sum;
            codeText.append(this.PlesseySymbols.charAt(sum));
        }
        if (this.getCheckSum2() != StiPlesseyCheckSum.None) {
            sum = 0;
            if (this.getCheckSum2() == StiPlesseyCheckSum.Modulo10) {
                long sum1 = 0L;
                sum2 = 0L;
                multiplier2 = 1L;
                odd = false;
                for (int index = code.length(); index >= 0; --index) {
                    if (!odd) {
                        sum1 += (long)fullCode[index] * multiplier2;
                        multiplier2 *= 10L;
                    } else {
                        sum2 += (long)fullCode[index];
                    }
                    odd = !odd;
                }
                sum1 *= 2L;
                sum3 = 0L;
                while (sum1 >= 10L) {
                    sum3 += sum1 % 10L;
                    sum1 /= 10L;
                }
                sum = (int)(((sum3 += sum1) + sum2) % 10L);
                if (sum != 0) {
                    sum = 10 - sum;
                }
            }
            if (this.getCheckSum2() == StiPlesseyCheckSum.Modulo11) {
                int sum1 = 0;
                multiplier = 2;
                for (int index = code.length(); index >= 0; --index) {
                    sum1 += fullCode[index] * multiplier;
                    if (++multiplier <= 7) continue;
                    multiplier = 2;
                }
                sum = sum1 % 11;
                if (sum != 0) {
                    sum = 11 - sum;
                }
            }
            fullCode[code.length() + 1] = sum;
            codeText.append(this.PlesseySymbols.charAt(sum));
        }
        StringBuilder tempBarsArray = new StringBuilder();
        tempBarsArray.append("1101");
        for (int index = 0; index < fullCode.length; ++index) {
            tempBarsArray.append(this.PlesseyTable[fullCode[index]]);
        }
        tempBarsArray.append("11");
        StringBuilder barsArray = new StringBuilder(this.CodeToBar(tempBarsArray.toString()));
        this.CalculateSizeFull(20.0, 20.0, 0.0, 1.0, 70.0, 70.0, 71.0, 11.5, 84.0, 70.0, 1.667f, zoom, code, codeText.toString(), barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 8.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        jObject.AddPropertyEnum("CheckSum1", (Enum)this.getCheckSum1(), (Enum)StiPlesseyCheckSum.None);
        jObject.AddPropertyEnum("CheckSum2", (Enum)this.getCheckSum2(), (Enum)StiPlesseyCheckSum.None);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Height")) {
                this.height = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("CheckSum1")) {
                this.checkSum1 = StiPlesseyCheckSum.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("CheckSum2")) continue;
            this.checkSum2 = StiPlesseyCheckSum.valueOf((String)property.Value);
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "1234567";
    }
}

