/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.enums.StiMaxicodeMode;
import com.stimulsoft.report.barCodes.maxicode.StiMaxicode;
import com.stimulsoft.report.enums.StiComponentId;

public class StiMaxicodeBarCodeType
extends StiBarCodeTypeService {
    private StiMaxicodeMode mode = StiMaxicodeMode.Mode4;
    private boolean processTilde = true;
    private int structuredAppendPosition = 1;
    private int structuredAppendTotal = 1;
    private boolean trimExcessData = true;

    public StiMaxicodeBarCodeType() {
        this(StiMaxicodeMode.Mode4, 1, 1, true, true);
    }

    public StiMaxicodeBarCodeType(StiMaxicodeMode mode, int structuredAppendPosition, int structuredAppendTotal, boolean processTilde, boolean trimExcessData) {
        this.mode = mode;
        this.structuredAppendPosition = structuredAppendPosition;
        this.structuredAppendTotal = structuredAppendTotal;
        this.processTilde = processTilde;
        this.trimExcessData = trimExcessData;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyEnum("Mode", (Enum)mode, (Enum)StiMaxicodeMode.Mode2);
        jObject.AddPropertyInt("StructuredAppendPosition", this.getStructuredAppendPosition(), 1);
        jObject.AddPropertyInt("StructuredAppendTotal", this.getStructuredAppendTotal(), 1);
        jObject.AddPropertyBool("ProcessTilde", this.isProcessTilde());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Mode")) {
                this.mode = StiMaxicodeMode.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("StructuredAppendPosition")) {
                this.structuredAppendPosition = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("StructuredAppendTotal")) {
                this.structuredAppendTotal = (Integer)property.Value;
                continue;
            }
            if (!property.Name.equals("ProcessTilde")) continue;
            this.processTilde = (Boolean)property.Value;
        }
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiMaxicodeBarCodeType;
    }

    public String getServiceName() {
        return "Maxicode";
    }

    @Override
    public String getDefaultCodeValue() {
        return "ABC abc 123";
    }

    @Override
    public double getModule() {
        return 10.0;
    }

    @Override
    public double getHeight() {
        return 1.0;
    }

    @StiSerializable
    public StiMaxicodeMode getMode() {
        return this.mode;
    }

    public void setMode(StiMaxicodeMode value) {
        this.mode = value;
    }

    @StiSerializable
    public boolean isProcessTilde() {
        return this.processTilde;
    }

    public void setProcessTilde(boolean processTilde) {
        this.processTilde = processTilde;
    }

    @StiSerializable
    public int getStructuredAppendPosition() {
        return this.structuredAppendPosition;
    }

    public void setStructuredAppendPosition(int structuredAppendPosition) {
        this.structuredAppendPosition = structuredAppendPosition;
    }

    @StiSerializable
    public int getStructuredAppendTotal() {
        return this.structuredAppendTotal;
    }

    public void setStructuredAppendTotal(int structuredAppendTotal) {
        this.structuredAppendTotal = structuredAppendTotal;
    }

    @StiSerializable
    public boolean isTrimExcessData() {
        return this.trimExcessData;
    }

    public void setTrimExcessData(boolean trimExcessData) {
        this.trimExcessData = trimExcessData;
    }

    @Override
    public double getLabelFontHeight() {
        return 8.0;
    }

    public Boolean[] getVisibleProperties() {
        Boolean[] props = new Boolean[27];
        props[9] = true;
        props[12] = true;
        props[13] = true;
        props[21] = true;
        return props;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code;
        this.getBarCodeData().Code = code = this.GetCode(barCode);
        StiMaxicode mc = new StiMaxicode(code, this.mode, this.structuredAppendPosition, this.structuredAppendTotal, this.processTilde, this.trimExcessData);
        this.getBarCodeData().MatrixGrid = mc.getMatrix();
        if (mc.getErrorMessage() == null) {
            this.drawMaxicode(context, rect, barCode, zoom);
        } else {
            this.drawBarCodeError(context, rect, barCode, mc.getErrorMessage());
        }
    }

    public StiBarCodeTypeService CreateNew() {
        return new StiMaxicodeBarCodeType();
    }

    @Override
    public void setModule(double value) {
    }

    @Override
    public void setHeight(double value) {
    }
}

