/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiGraphicsUnit;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.enums.StiEanSupplementType;
import com.stimulsoft.report.components.enums.StiAngle;
import java.util.ArrayList;
import java.util.HashMap;

public class StiEAN13BarCodeType
extends StiBarCodeTypeService {
    private double module = 13.0;
    private double height = 1.0;
    private StiEanSupplementType supplementType = StiEanSupplementType.None;
    private String supplementCodeValue = null;
    private boolean showQuietZoneIndicator = true;
    protected String[] symComboSet = new String[]{"000000", "001011", "001101", "001110", "010011", "011001", "011100", "010101", "010110", "011010"};
    protected String[] symParitySetAdd2 = new String[]{"oo", "oe", "eo", "ee"};
    protected String[] symParitySetAdd5 = new String[]{"eeooo", "eoeoo", "eooeo", "eoooe", "oeeoo", "ooeeo", "oooee", "oeoeo", "oeooe", "ooeoe"};
    protected String[] ean13SymData = new String[]{"2504", "1514", "1415", "0704", "0425", "0524", "0407", "0605", "0506", "2405", "0416", "0515", "1505", "0434", "1604", "0614", "3404", "1424", "2414", "1406", "6140", "5150", "5051", "4340", "4061", "4160", "4043", "4241", "4142", "6041", "808", "08080", "808", "080808", "809", "08", "x", "y", "z"};

    public StiEAN13BarCodeType() {
        this(13.0, 1.0, StiEanSupplementType.None, null, true);
    }

    public StiEAN13BarCodeType(double module, double height, StiEanSupplementType supplementType, String supplementCodeValue, boolean showQuietZoneIndicator) {
        this.module = module;
        this.height = height;
        this.supplementType = supplementType;
        this.supplementCodeValue = supplementCodeValue;
        this.showQuietZoneIndicator = showQuietZoneIndicator;
    }

    public String getServiceName() {
        return "EAN-13";
    }

    @Override
    @StiDefaulValue(value="13.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < (double)10.4f) {
            this.module = 10.4f;
        }
        if (value > 26.0) {
            this.module = 26.0;
        }
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 0.5) {
            this.height = 0.5;
        }
        if (value > 1.0) {
            this.height = 1.0;
        }
    }

    @StiDefaulValue(value="None")
    @StiSerializable
    public StiEanSupplementType getSupplementType() {
        return this.supplementType;
    }

    public void setSupplementType(StiEanSupplementType value) {
        this.supplementType = value;
    }

    @StiSerializable
    public String getSupplementCode() {
        return this.supplementCodeValue;
    }

    public void setSupplementCode(String value) {
        this.supplementCodeValue = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getShowQuietZoneIndicator() {
        return this.showQuietZoneIndicator;
    }

    public void setShowQuietZoneIndicator(boolean value) {
        this.showQuietZoneIndicator = value;
    }

    @Override
    public double getLabelFontHeight() {
        return this.getEanTextHeight();
    }

    protected double getEanSpaceLeft() {
        return 11.0;
    }

    protected double getEanSpaceRight() {
        return 8.0;
    }

    protected double getEanSpaceTop() {
        return 0.0;
    }

    protected double getEanSpaceBottom() {
        return 1.0;
    }

    protected double getEanSpaceBeforeAdd() {
        return 10.0;
    }

    protected double getEanSpaceTextTop() {
        return 10.0;
    }

    protected double getEanLineHeightShort() {
        return 69.2f;
    }

    protected double getEanLineHeightLong() {
        return this.getEanLineHeightShort() + 5.0;
    }

    protected double getEanTextPositionTop() {
        return 0.5;
    }

    protected double getEanTextPositionBottom() {
        return this.getEanLineHeightShort() + this.getEanSpaceBottom();
    }

    protected double getEanTextHeight() {
        return 8.33f;
    }

    protected double getEanMainHeight() {
        return 78.58f;
    }

    protected double getEanLineHeightForCut() {
        return this.getEanLineHeightShort();
    }

    protected double getEanWideToNarrowRatio() {
        return 2.0;
    }

    protected final void CalculateSizeEan(double offsetY, double Zoom, ArrayList<EanBarInfo> BarsArray, StiRectangle rect, StiBarCode barCode) {
        double fullZoomX;
        this.getBarCodeData().WideToNarrowRatio = 2.0;
        this.getBarCodeData().EanBarsArray = BarsArray;
        StringBuilder sb = new StringBuilder();
        for (EanBarInfo barInfo : BarsArray) {
            sb.append(this.ean13SymData[barInfo.SymbolType.intValue]);
        }
        double barsWidth = this.GetSymbolsStringWidth(sb.toString());
        this.RectWindow = new StiRectangle(0.0, 0.0, rect.getWidth(), rect.getHeight());
        if (barCode.getAngle() == StiAngle.Angle90 || barCode.getAngle() == StiAngle.Angle270) {
            this.RectWindow = new StiRectangle(0.0, 0.0, rect.getHeight(), rect.getWidth());
        }
        double fontAddSize = barCode.getFont().getSize() - 8.0 + 0.5;
        double MainHeight = this.getEanMainHeight() + fontAddSize;
        double TextHeight = this.getEanTextHeight() + fontAddSize;
        double fullZoomY = fullZoomX = this.getModule() / 10.0 * Zoom;
        double cutHeight = this.getEanLineHeightForCut() * (1.0 - this.getHeight());
        double spaceTextTop = this.getEanSpaceTextTop() + fontAddSize;
        if (barCode.getAutoScale()) {
            fullZoomX = this.RectWindow.getWidth() / barsWidth;
            cutHeight = -(this.RectWindow.getHeight() / fullZoomY - (MainHeight + offsetY));
            if (!barCode.getShowLabelText()) {
                cutHeight -= this.getEanTextHeight();
                spaceTextTop -= this.getEanTextHeight();
            }
        }
        this.getBarCodeData().FullZoomY = fullZoomY;
        this.getBarCodeData().SpaceLeft = this.getEanSpaceLeft() * fullZoomX;
        this.getBarCodeData().SpaceRight = this.getEanSpaceRight() * fullZoomX;
        this.getBarCodeData().SpaceBeforeAdd = this.getEanSpaceBeforeAdd() * fullZoomX;
        this.getBarCodeData().LineWidth = 1.0 * fullZoomX;
        this.getBarCodeData().MainWidth = barsWidth * fullZoomX;
        this.getBarCodeData().SpaceTop = this.getEanSpaceTop() * fullZoomY;
        this.getBarCodeData().SpaceBottom = this.getEanSpaceBottom() * fullZoomY;
        this.getBarCodeData().SpaceTextTop = spaceTextTop * fullZoomY;
        this.getBarCodeData().LineHeightShort = (this.getEanLineHeightShort() - cutHeight) * fullZoomY;
        this.getBarCodeData().LineHeightLong = (this.getEanLineHeightLong() - cutHeight) * fullZoomY;
        this.getBarCodeData().TextPositionTop = this.getEanTextPositionTop() * fullZoomY;
        this.getBarCodeData().TextPositionBottom = (this.getEanTextPositionBottom() - cutHeight) * fullZoomY;
        this.getBarCodeData().MainHeight = (MainHeight + offsetY - cutHeight) * fullZoomY;
        this.getBarCodeData().TextHeight = TextHeight * fullZoomY;
        this.getBarCodeData().OffsetY = offsetY * fullZoomY;
    }

    protected final void drawEanBars(StiGraphics context, ArrayList<EanBarInfo> barsArray, StiBarCode barCode) throws Exception {
        Double zoom = barCode.getReport().getInfo().getZoom();
        Double pageZoom = barCode.getReport().getInfo().getPageZoom();
        StiSolidBrush backBrush = new StiSolidBrush(barCode.getBackColor());
        StiSolidBrush foreBrush = new StiSolidBrush(barCode.getForeColor());
        this.baseFillRectangle(context, (StiBrush)backBrush, 0.0, 0.0, this.getBarCodeData().MainWidth, this.getBarCodeData().MainHeight, zoom, pageZoom);
        double binOffsetX = 0.0;
        double binOffsetY = this.getBarCodeData().OffsetY + this.getBarCodeData().SpaceTop;
        StiFont barCodeFont = new StiFont(barCode.getFont().getName(), barCode.getFont().getSize() * barCode.getBarCodeType().getLabelFontHeight() * this.getModule() / 104.0, barCode.getFont().getStyle(), StiGraphicsUnit.Point);
        for (EanBarInfo barInfo : barsArray) {
            double inSymPosition = 0.0;
            String sym = this.ean13SymData[barInfo.SymbolType.intValue];
            if (barInfo.MakeLonger) {
                sym = this.makeLonger(sym);
            }
            for (int index = 0; index < sym.length(); ++index) {
                char currentChar = sym.charAt(index);
                if (!this.IsSymbolSpace(currentChar)) {
                    double binHeight = this.getBarCodeData().LineHeightShort;
                    if (this.IsSymbolLong(currentChar) || barInfo.TextAtTop) {
                        binHeight = this.getBarCodeData().LineHeightLong;
                    }
                    double binTopOffset = 0.0;
                    if (barInfo.TextAtTop) {
                        binTopOffset = this.getBarCodeData().SpaceTextTop;
                    }
                    this.baseFillRectangle(context, (StiBrush)foreBrush, binOffsetX + this.getBarCodeData().LineWidth * inSymPosition, binOffsetY + binTopOffset, this.getBarCodeData().LineWidth * this.GetSymbolWidth(currentChar), binHeight - binTopOffset, zoom, pageZoom);
                }
                inSymPosition += this.GetSymbolWidth(currentChar);
            }
            if (barCode.getShowLabelText() && barInfo.SymbolText != ' ') {
                StiRectangle rect = barInfo.TextAtTop ? new StiRectangle(binOffsetX, binOffsetY + this.getBarCodeData().TextPositionTop, inSymPosition * this.getBarCodeData().LineWidth, this.getBarCodeData().SpaceTextTop) : new StiRectangle(binOffsetX, binOffsetY + this.getBarCodeData().TextPositionBottom, inSymPosition * this.getBarCodeData().LineWidth, this.getBarCodeData().SpaceTextTop);
                this.baseDrawString(context, new Character(barInfo.SymbolText).toString(), barCodeFont, (StiBrush)foreBrush, rect, StiTextHorAlignment.Center, StiVertAlignment.Top, zoom);
            }
            binOffsetX += this.getBarCodeData().LineWidth * inSymPosition;
        }
    }

    protected final ArrayList<EanBarInfo> MakeEan13Bars(String code, boolean isLast) {
        EanBarInfo sym;
        int currentNumber;
        int index;
        int[] dig = new int[12];
        for (int tempIndex = 0; tempIndex < 12; ++tempIndex) {
            dig[tempIndex] = Integer.parseInt(String.valueOf(code.charAt(tempIndex)));
        }
        int sum = (dig[1] + dig[3] + dig[5] + dig[7] + dig[9] + dig[11]) * 3 + dig[0] + dig[2] + dig[4] + dig[6] + dig[8] + dig[10];
        int checkDigit = 10 - sum % 10;
        if (checkDigit == 10) {
            checkDigit = 0;
        }
        code = code.substring(0, 12) + (char)(checkDigit + 48);
        ArrayList<EanBarInfo> barsArray = new ArrayList<EanBarInfo>();
        barsArray.add(new EanBarInfo(Ean13Symbol.SpaceLeft, code.charAt(0), false));
        barsArray.add(new EanBarInfo(Ean13Symbol.GuardLeft, ' ', false));
        int firstNumber = Integer.parseInt(String.valueOf(code.charAt(0)));
        for (index = 0; index < 6; ++index) {
            currentNumber = Integer.parseInt(String.valueOf(code.charAt(1 + index)));
            sym = new EanBarInfo(Ean13Symbol.forValue(Ean13Symbol.ComboA0.getValue() + currentNumber), code.charAt(1 + index), false);
            if (this.symComboSet[firstNumber].charAt(index) != '0') {
                sym.SymbolType = Ean13Symbol.forValue(Ean13Symbol.ComboB0.intValue + currentNumber);
            }
            barsArray.add(sym);
        }
        barsArray.add(new EanBarInfo(Ean13Symbol.GuardCenter, ' ', false));
        for (index = 0; index < 6; ++index) {
            currentNumber = Integer.parseInt(String.valueOf(code.charAt(7 + index)));
            sym = new EanBarInfo(Ean13Symbol.forValue(Ean13Symbol.ComboC0.intValue + currentNumber), code.charAt(7 + index), false);
            barsArray.add(sym);
        }
        barsArray.add(new EanBarInfo(Ean13Symbol.GuardRight, ' ', false));
        if (isLast) {
            barsArray.add(new EanBarInfo(Ean13Symbol.SpaceRight, this.getShowQuietZoneIndicator() ? (char)'>' : ' ', false));
        } else {
            barsArray.add(new EanBarInfo(Ean13Symbol.SpaceBeforeAdd, ' ', false));
        }
        return barsArray;
    }

    protected final ArrayList<EanBarInfo> MakeEanAdd2Bars(String code, ArrayList<EanBarInfo> baseArray, boolean isLast) {
        ArrayList<EanBarInfo> barsArray = baseArray != null ? baseArray : new ArrayList<EanBarInfo>();
        barsArray.add(new EanBarInfo(Ean13Symbol.GuardAddLeft, ' ', true));
        int numberDigits = 2;
        String symbolParity = this.symParitySetAdd2[Integer.parseInt(code.substring(0, 2)) % 4];
        for (int index = 0; index < numberDigits; ++index) {
            int currentNumber = Integer.parseInt(String.valueOf(code.charAt(index)));
            char parity = symbolParity.charAt(index);
            EanBarInfo sym = new EanBarInfo(Ean13Symbol.forValue(Ean13Symbol.ComboA0.getValue() + currentNumber), code.charAt(index), true);
            if (parity != 'o') {
                sym.SymbolType = Ean13Symbol.forValue(Ean13Symbol.ComboB0.intValue + currentNumber);
            }
            barsArray.add(sym);
            if (index >= numberDigits - 1) continue;
            barsArray.add(new EanBarInfo(Ean13Symbol.GuardAddDelineator, ' ', true));
        }
        if (isLast) {
            barsArray.add(new EanBarInfo(Ean13Symbol.SpaceRight, this.getShowQuietZoneIndicator() ? (char)'>' : ' ', true));
        } else {
            barsArray.add(new EanBarInfo(Ean13Symbol.SpaceBeforeAdd, ' ', true));
        }
        return barsArray;
    }

    protected final ArrayList<EanBarInfo> MakeEanAdd5Bars(String code, ArrayList<EanBarInfo> baseArray, boolean isLast) {
        ArrayList<EanBarInfo> barsArray = baseArray != null ? baseArray : new ArrayList<EanBarInfo>();
        barsArray.add(new EanBarInfo(Ean13Symbol.GuardAddLeft, ' ', true));
        int checkSum = Integer.parseInt(String.valueOf(code.charAt(0))) * 3 + Integer.parseInt(String.valueOf(code.charAt(1))) * 9 + Integer.parseInt(String.valueOf(code.charAt(2))) * 3 + Integer.parseInt(String.valueOf(code.charAt(3))) * 9 + Integer.parseInt(String.valueOf(code.charAt(4))) * 3;
        String symbolParity = this.symParitySetAdd5[checkSum % 10];
        int numberDigits = 5;
        for (int index = 0; index < numberDigits; ++index) {
            int currentNumber = Integer.parseInt(String.valueOf(code.charAt(index)));
            char parity = symbolParity.charAt(index);
            EanBarInfo sym = new EanBarInfo(Ean13Symbol.forValue(Ean13Symbol.ComboA0.getValue() + currentNumber), code.charAt(index), true);
            if (parity != 'o') {
                sym.SymbolType = Ean13Symbol.forValue(Ean13Symbol.ComboB0.intValue + currentNumber);
            }
            barsArray.add(sym);
            if (index >= numberDigits - 1) continue;
            barsArray.add(new EanBarInfo(Ean13Symbol.GuardAddDelineator, ' ', true));
        }
        if (isLast) {
            barsArray.add(new EanBarInfo(Ean13Symbol.SpaceRight, this.getShowQuietZoneIndicator() ? (char)'>' : ' ', true));
        } else {
            barsArray.add(new EanBarInfo(Ean13Symbol.SpaceBeforeAdd, ' ', true));
        }
        return barsArray;
    }

    protected final String makeLonger(String symString) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < symString.length(); ++index) {
            char sym = symString.charAt(index);
            switch (sym) {
                case '4': {
                    sym = '8';
                    break;
                }
                case '5': {
                    sym = '9';
                    break;
                }
                case '6': {
                    sym = 'a';
                    break;
                }
                case '7': {
                    sym = 'b';
                }
            }
            sb.append(sym);
        }
        return sb.toString();
    }

    @Override
    protected double GetSymbolWidth(char symbol) {
        double symbolWidth;
        switch (symbol) {
            case '0': 
            case '4': 
            case '8': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                symbolWidth = 1.0;
                break;
            }
            case '1': 
            case '5': 
            case '9': {
                symbolWidth = 1.0 * this.getEanWideToNarrowRatio();
                break;
            }
            case '2': 
            case '6': 
            case 'a': {
                symbolWidth = 1.5 * this.getEanWideToNarrowRatio();
                break;
            }
            case '3': 
            case '7': 
            case 'b': {
                symbolWidth = 2.0 * this.getEanWideToNarrowRatio();
                break;
            }
            case 'x': {
                symbolWidth = this.getEanSpaceLeft();
                break;
            }
            case 'y': {
                symbolWidth = this.getEanSpaceRight();
                break;
            }
            case 'z': {
                symbolWidth = this.getEanSpaceBeforeAdd();
                break;
            }
            default: {
                symbolWidth = 1.0;
            }
        }
        return symbolWidth;
    }

    @Override
    protected boolean IsSymbolSpace(char symbol) {
        boolean isSpace;
        switch (symbol) {
            case '0': 
            case '1': 
            case '2': 
            case '3': {
                isSpace = true;
                break;
            }
            case 'x': 
            case 'y': 
            case 'z': {
                isSpace = true;
                break;
            }
            default: {
                isSpace = false;
            }
        }
        return isSpace;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, "0123456789") + "0000000000000";
        String suppCode = this.CheckCodeSymbols(this.getSupplementCode(), "0123456789") + "00000";
        ArrayList<EanBarInfo> barsArray = null;
        if (this.getSupplementType() == StiEanSupplementType.None) {
            String tempRef_code = new String(code);
            barsArray = this.MakeEan13Bars(tempRef_code, true);
            code = tempRef_code;
        } else {
            String tempRef_code2 = new String(code);
            barsArray = this.MakeEan13Bars(tempRef_code2, false);
            code = tempRef_code2;
            if (this.getSupplementType() == StiEanSupplementType.TwoDigit) {
                this.MakeEanAdd2Bars(suppCode, barsArray, true);
            } else {
                this.MakeEanAdd5Bars(suppCode, barsArray, true);
            }
        }
        this.CalculateSizeEan(0.0, zoom, barsArray, rect, barCode);
        this.translateRect(context, rect, barCode);
        this.drawEanBars(context, barsArray, barCode);
        this.rollbackTransform(context);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 13.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        jObject.AddPropertyEnum("SupplementType", (Enum)this.getSupplementType(), (Enum)StiEanSupplementType.None);
        jObject.AddPropertyStringNullOfEmpty("SupplementCode", this.getSupplementCode());
        jObject.AddPropertyBool("ShowQuietZoneIndicator", this.getShowQuietZoneIndicator(), true);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Height")) {
                this.height = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("SupplementType")) {
                this.supplementType = StiEanSupplementType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("SupplementCode")) {
                this.supplementCodeValue = (String)property.Value;
                continue;
            }
            if (!property.Name.equals("ShowQuietZoneIndicator")) continue;
            this.showQuietZoneIndicator = (Boolean)property.Value;
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "0123456789012";
    }

    protected static enum Ean13Symbol {
        ComboA0(0),
        ComboA1(1),
        ComboA2(2),
        ComboA3(3),
        ComboA4(4),
        ComboA5(5),
        ComboA6(6),
        ComboA7(7),
        ComboA8(8),
        ComboA9(9),
        ComboB0(10),
        ComboB1(11),
        ComboB2(12),
        ComboB3(13),
        ComboB4(14),
        ComboB5(15),
        ComboB6(16),
        ComboB7(17),
        ComboB8(18),
        ComboB9(19),
        ComboC0(20),
        ComboC1(21),
        ComboC2(22),
        ComboC3(23),
        ComboC4(24),
        ComboC5(25),
        ComboC6(26),
        ComboC7(27),
        ComboC8(28),
        ComboC9(29),
        GuardLeft(30),
        GuardCenter(31),
        GuardRight(32),
        GuardSpecial(33),
        GuardAddLeft(34),
        GuardAddDelineator(35),
        SpaceLeft(36),
        SpaceRight(37),
        SpaceBeforeAdd(38);

        private int intValue;
        private static HashMap<Integer, Ean13Symbol> mappings;

        private static synchronized HashMap<Integer, Ean13Symbol> getMappings() {
            if (mappings == null) {
                mappings = new HashMap();
            }
            return mappings;
        }

        private Ean13Symbol(int value) {
            this.intValue = value;
            Ean13Symbol.getMappings().put(value, this);
        }

        public int getValue() {
            return this.intValue;
        }

        public static Ean13Symbol forValue(int value) {
            return Ean13Symbol.getMappings().get(value);
        }
    }

    protected static class EanBarInfo {
        public Ean13Symbol SymbolType = Ean13Symbol.forValue(0);
        public char SymbolText;
        public boolean TextAtTop;
        public boolean MakeLonger;

        public EanBarInfo(Ean13Symbol symbolType, char symbolText, boolean textAtTop) {
            this(symbolType, symbolText, textAtTop, false);
        }

        public EanBarInfo(Ean13Symbol symbolType, char symbolText, boolean textAtTop, boolean makeLonger) {
            this.SymbolType = symbolType;
            this.SymbolText = symbolText;
            this.TextAtTop = textAtTop;
            this.MakeLonger = makeLonger;
        }
    }
}

