/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiCode39BarCodeType;
import com.stimulsoft.report.barCodes.enums.StiCheckSum;

public class StiCode39ExtBarCodeType
extends StiCode39BarCodeType {
    protected String[] Code39ExtTable = new String[]{"%U", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J", "$K", "$L", "$M", "$N", "$O", "$P", "$Q", "$R", "$S", "$T", "$U", "$V", "$W", "$X", "$Y", "$Z", "%A", "%B", "%C", "%D", "%E", " ", "/A", "/B", "/C", "/D", "/E", "/F", "/G", "/H", "/I", "/J", "/K", "/L", "-", ".", "/O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "/Z", "%F", "%G", "%H", "%I", "%J", "%V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "%K", "%L", "%M", "%N", "%O", "%W", "+A", "+B", "+C", "+D", "+E", "+F", "+G", "+H", "+I", "+J", "+K", "+L", "+M", "+N", "+O", "+P", "+Q", "+R", "+S", "+T", "+U", "+V", "+W", "+X", "+Y", "+Z", "%P", "%Q", "%R", "%S", "%T"};

    public StiCode39ExtBarCodeType() {
        this(13.0, 1.0, 2.2, StiCheckSum.Yes);
    }

    public StiCode39ExtBarCodeType(double module, double height, double ratio, StiCheckSum checkSum) {
        super(module, height, ratio, checkSum);
    }

    @Override
    public String getServiceName() {
        return "Code39 Extended";
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        if (code == null) {
            code = "";
        }
        StringBuilder checkedCode = new StringBuilder();
        StringBuilder checkedString = new StringBuilder();
        for (int index = 0; index < code.length(); ++index) {
            char sym = code.charAt(index);
            if (sym >= '\u0080') continue;
            checkedCode.append(this.Code39ExtTable[sym]);
            checkedString.append(sym);
        }
        code = checkedCode.toString();
        int[] fullCode = new int[code.length() + (this.getCheckSum() == StiCheckSum.Yes ? 3 : 2)];
        fullCode[0] = this.Code39StartStopSymbolIndex;
        int checkSum = 0;
        for (int index = 0; index < code.length(); ++index) {
            fullCode[index + 1] = this.Code39Symbols.indexOf(code.charAt(index));
            checkSum += fullCode[index + 1];
        }
        if (this.getCheckSum() == StiCheckSum.Yes) {
            fullCode[fullCode.length - 2] = checkSum % 43;
        }
        fullCode[fullCode.length - 1] = fullCode[0];
        StringBuilder barsArray = new StringBuilder();
        for (int index = 0; index < fullCode.length; ++index) {
            barsArray.append(this.CodeToBar(this.Code39Table[fullCode[index]]));
        }
        this.CalculateSizeFull(10.0, 10.0, 0.0, 1.0, 45.0, 45.0, 46.0, 8.33f, 55.0, 45.0, this.getRatio(), zoom, code, checkedString.toString(), barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public String getDefaultCodeValue() {
        return "Abc123";
    }
}

