/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.enums.StiCheckSum;

public class StiCode39BarCodeType
extends StiBarCodeTypeService {
    protected String Code39Symbols = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";
    protected int Code39StartStopSymbolIndex = 43;
    protected String[] Code39Table = new String[]{"1112212111", "2112111121", "1122111121", "2122111111", "1112211121", "2112211111", "1122211111", "1112112121", "2112112111", "1122112111", "2111121121", "1121121121", "2121121111", "1111221121", "2111221111", "1121221111", "1111122121", "2111122111", "1121122111", "1111222111", "2111111221", "1121111221", "2121111211", "1111211221", "2111211211", "1121211211", "1111112221", "2111112211", "1121112211", "1111212211", "2211111121", "1221111121", "2221111111", "1211211121", "2211211111", "1221211111", "1211112121", "2211112111", "1221112111", "1212121111", "1212111211", "1211121211", "1112121211", "1211212111"};
    private StiCheckSum checkSum = StiCheckSum.Yes;
    private double module = 13.0;
    private double height = 1.0;
    private double ratio = 2.2;
    protected static final double Code39SpaceLeft = 10.0;
    protected static final double Code39SpaceRight = 10.0;
    protected static final double Code39SpaceTop = 0.0;
    protected static final double Code39SpaceBottom = 1.0;
    protected static final double Code39LineHeightShort = 45.0;
    protected static final double Code39LineHeightLong = 45.0;
    protected static final double Code39TextPosition = 46.0;
    protected static final double Code39TextHeight = (double)8.33f;
    protected static final double Code39MainHeight = 55.0;
    protected static final double Code39LineHeightForCut = 45.0;

    public StiCode39BarCodeType() {
        this(13.0, 1.0, 2.2, StiCheckSum.Yes);
    }

    public StiCode39BarCodeType(double module, double height, double ratio, StiCheckSum checkSum) {
        this.module = module;
        this.height = height;
        this.ratio = ratio;
        this.checkSum = checkSum;
    }

    public String getServiceName() {
        return "Code39";
    }

    @StiDefaulValue(value="Yes")
    @StiSerializable
    public final StiCheckSum getCheckSum() {
        return this.checkSum;
    }

    public final void setCheckSum(StiCheckSum value) {
        this.checkSum = value;
    }

    @Override
    @StiDefaulValue(value="13.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 2.0) {
            this.module = 2.0;
        }
        if (value > 40.0) {
            this.module = 40.0;
        }
        this.setRatio(this.getRatio());
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 0.5) {
            this.height = 0.5;
        }
        if (value > 2.0) {
            this.height = 2.0;
        }
    }

    @StiDefaulValue(value="2.2")
    @StiSerializable
    public final double getRatio() {
        return this.ratio;
    }

    public final void setRatio(double value) {
        this.ratio = value;
        double minRatio = this.getModule() > 20.0 ? 2.0f : 2.2f;
        if (value < minRatio) {
            this.ratio = minRatio;
        }
        if (value > 3.0) {
            this.ratio = 3.0;
        }
    }

    @Override
    public double getLabelFontHeight() {
        return 8.33f;
    }

    protected final String CodeToBar(String inputCode) {
        StringBuilder outputBar = new StringBuilder();
        boolean counter = true;
        for (int index = 0; index < inputCode.length(); ++index) {
            char currentsym = counter ? (inputCode.charAt(index) == '1' ? (char)'4' : '5') : (inputCode.charAt(index) == '1' ? (char)'0' : '1');
            outputBar.append(currentsym);
            counter = !counter;
        }
        return outputBar.toString();
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, this.Code39Symbols);
        int[] fullCode = new int[code.length() + (this.getCheckSum() == StiCheckSum.Yes ? 3 : 2)];
        fullCode[0] = this.Code39StartStopSymbolIndex;
        int checkSum = 0;
        for (int index = 0; index < code.length(); ++index) {
            fullCode[index + 1] = this.Code39Symbols.indexOf(code.charAt(index));
            checkSum += fullCode[index + 1];
        }
        if (this.getCheckSum() == StiCheckSum.Yes) {
            fullCode[fullCode.length - 2] = checkSum % 43;
        }
        fullCode[fullCode.length - 1] = fullCode[0];
        StringBuilder barsArray = new StringBuilder();
        for (int index = 0; index < fullCode.length; ++index) {
            barsArray.append(this.CodeToBar(this.Code39Table[fullCode[index]]));
        }
        this.CalculateSizeFull(10.0, 10.0, 0.0, 1.0, 45.0, 45.0, 46.0, 8.33f, 55.0, 45.0, this.getRatio(), zoom, code, code, barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 13.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        jObject.AddPropertyEnum("CheckSum", (Enum)this.getCheckSum(), (Enum)StiCheckSum.Yes);
        jObject.AddPropertyFloat("Ratio", this.getRatio(), (double)2.2f);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Height")) {
                this.height = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("CheckSum")) {
                this.checkSum = StiCheckSum.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("Ratio")) continue;
            this.ratio = property.floatValue().floatValue();
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "ABC123";
    }
}

