/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.services.StiService;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiGraphicsUnit;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.barCodes.IStiBarCode;
import com.stimulsoft.report.barCodes.StiAustraliaPost4StateBarCodeType;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiEAN13BarCodeType;
import com.stimulsoft.report.barCodes.StiITF14BarCodeType;
import com.stimulsoft.report.components.enums.StiAngle;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.export.tools.StiBarCodeExportPainter;
import com.stimulsoft.report.painters.components.StiBarCodePainter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class StiBarCodeTypeService
extends StiService {
    private final StiBarCodeData barCodeData = new StiBarCodeData();
    protected StiRectangle RectWindow = new StiRectangle(0L, 0L, 0L, 0L);
    protected static final double DefaultLabelFontHeight = 8.0;
    public final int visiblePropertiesCount = 27;
    StiBarCodePainter painter = new StiBarCodePainter();
    StiBarCodeExportPainter exportPainter = null;

    public String toString() {
        return this.getServiceName();
    }

    protected boolean isTextSpacing() {
        return true;
    }

    public abstract String getDefaultCodeValue();

    public static String unpackTilde(String input, boolean processTilde) {
        if (!processTilde) {
            return input;
        }
        int[] ints = new int[input.length()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = input.charAt(i);
        }
        Integer[] ints2 = StiBarCodeTypeService.unpackTilde(ints, true);
        StringBuilder sb = new StringBuilder(ints2.length);
        for (int i = 0; i < ints2.length; ++i) {
            sb.append((char)ints2[i].intValue());
        }
        return sb.toString();
    }

    public static Integer[] unpackTilde(int[] input, boolean processTilde) {
        int index = 0;
        ArrayList<Integer> output = new ArrayList<Integer>();
        while (index < input.length) {
            int ch = input[index++];
            if (processTilde && ch == 126) {
                boolean flag = false;
                if (index < input.length && input[index] == 126) {
                    output.add(126);
                    flag = true;
                    ++index;
                }
                if (!flag && index + 2 < input.length) {
                    int num;
                    if (input[index] == 70 && input[index + 1] == 78 && input[index + 2] == 67 && index + 3 < input.length && ((num = input[index + 3] - 48) == 1 || num == 2 || num == 3 || num == 4)) {
                        if (num == 1) {
                            output.add(Integer.valueOf(BarcodeCommandCode.Fnc1));
                        }
                        if (num == 2) {
                            output.add(Integer.valueOf(BarcodeCommandCode.Fnc2));
                        }
                        if (num == 3) {
                            output.add(Integer.valueOf(BarcodeCommandCode.Fnc3));
                        }
                        if (num == 4) {
                            output.add(Integer.valueOf(BarcodeCommandCode.Fnc4));
                        }
                        flag = true;
                        index += 4;
                    }
                    if (!flag && Character.isDigit((char)input[index]) && Character.isDigit((char)input[index + 1]) && Character.isDigit((char)input[index + 2]) && (num = (input[index] - 48) * 100 + (input[index + 1] - 48) * 10 + (input[index + 2] - 48)) >= 0 && num <= 255) {
                        output.add(num);
                        flag = true;
                        index += 3;
                    }
                }
                if (flag) continue;
            }
            output.add(ch);
        }
        return output.toArray(new Integer[0]);
    }

    public final String getServiceCategory() {
        return "BarCodeTypes";
    }

    public final Class<?> getServiceType() {
        return StiBarCodeTypeService.class;
    }

    protected final StiBarCodeData getBarCodeData() {
        return this.barCodeData;
    }

    @StiSerializable
    public abstract double getModule();

    public abstract void setModule(double var1);

    @StiSerializable
    public abstract double getHeight();

    public abstract void setHeight(double var1);

    protected StiTextHorAlignment getTextAlignment() {
        return StiTextHorAlignment.Center;
    }

    public abstract double getLabelFontHeight();

    protected final String CheckCodeSymbols(String inputCode, String tolerantSymbols) {
        StringBuilder outputCode = new StringBuilder();
        if (inputCode != null) {
            for (int index = 0; index < inputCode.length(); ++index) {
                char currentChar = inputCode.charAt(index);
                if (tolerantSymbols.indexOf(currentChar) == -1) continue;
                outputCode.append(currentChar);
            }
        }
        return outputCode.toString();
    }

    public String GetCode(IStiBarCode barCode) {
        return barCode.GetBarCodeString();
    }

    public String getCombinedCode() {
        return null;
    }

    protected double GetSymbolWidth(char symbol) {
        double symbolWidth;
        switch (symbol) {
            case '0': 
            case '4': 
            case '8': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                symbolWidth = 1.0;
                break;
            }
            case '1': 
            case '5': 
            case '9': {
                symbolWidth = 1.0 * this.getBarCodeData().WideToNarrowRatio;
                break;
            }
            case '2': 
            case '6': 
            case 'a': {
                symbolWidth = 1.5 * this.getBarCodeData().WideToNarrowRatio;
                break;
            }
            case '3': 
            case '7': 
            case 'b': {
                symbolWidth = 2.0 * this.getBarCodeData().WideToNarrowRatio;
                break;
            }
            default: {
                symbolWidth = 1.0;
            }
        }
        return symbolWidth;
    }

    protected final boolean IsSymbolLong(char symbol) {
        boolean isLong;
        switch (symbol) {
            case '8': 
            case '9': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'e': {
                isLong = true;
                break;
            }
            default: {
                isLong = false;
            }
        }
        return isLong;
    }

    protected boolean IsSymbolSpace(char symbol) {
        boolean isSpace;
        switch (symbol) {
            case '0': 
            case '1': 
            case '2': 
            case '3': {
                isSpace = true;
                break;
            }
            default: {
                isSpace = false;
            }
        }
        return isSpace;
    }

    protected final boolean IsSymbolPostDescend(char symbol) {
        boolean isPostDescend;
        switch (symbol) {
            case 'e': 
            case 'f': {
                isPostDescend = true;
                break;
            }
            default: {
                isPostDescend = false;
            }
        }
        return isPostDescend;
    }

    protected final double GetSymbolsStringWidth(String symbolsString) {
        double symbolsStringLength = 0.0;
        for (int index = 0; index < symbolsString.length(); ++index) {
            symbolsStringLength += this.GetSymbolWidth(symbolsString.charAt(index));
        }
        return symbolsStringLength;
    }

    protected final void drawBars(StiGraphics context, String sym, StiBrush foreBrush, Double zoom, Double pageZoom) throws Exception {
        double binOffsetX = this.getBarCodeData().SpaceLeft;
        double binOffsetY = this.getBarCodeData().SpaceTop;
        double inSymPosition = 0.0;
        for (int index = 0; index < sym.length(); ++index) {
            char currentChar = sym.charAt(index);
            if (!this.IsSymbolSpace(currentChar)) {
                double binHeight = this.getBarCodeData().LineHeightShort;
                if (this.IsSymbolLong(currentChar)) {
                    binHeight = this.getBarCodeData().LineHeightLong;
                }
                double binPostnetOffset = 0.0;
                if (this.IsSymbolPostDescend(currentChar)) {
                    binPostnetOffset = this.getBarCodeData().LineHeightLong - this.getBarCodeData().LineHeightShort;
                }
                this.baseFillRectangle(context, foreBrush, binOffsetX + this.getBarCodeData().LineWidth * inSymPosition, binOffsetY + binPostnetOffset, this.getBarCodeData().LineWidth * this.GetSymbolWidth(currentChar), binHeight - binPostnetOffset, zoom, pageZoom);
            }
            inSymPosition += this.GetSymbolWidth(currentChar);
        }
    }

    protected final void drawBarCode(StiGraphics context, StiRectangle rect, StiBarCode barCode) throws Exception {
        StiFont barCodeFont = new StiFont(barCode.getFont().getName(), barCode.getFont().getSize() * barCode.getBarCodeType().getLabelFontHeight() * this.getModule() / 104.0, barCode.getFont().getStyle(), StiGraphicsUnit.Point);
        Double zoom = barCode.getReport().getInfo().getZoom();
        Double pageZoom = barCode.getReport().getInfo().getPageZoom();
        this.translateRect(context, rect, barCode);
        StiSolidBrush foreBrush = new StiSolidBrush(barCode.getForeColor());
        StiSolidBrush backBrush = new StiSolidBrush(barCode.getBackColor());
        this.baseFillRectangle(context, (StiBrush)backBrush, 0.0, 0.0, this.getBarCodeData().MainWidth, this.getBarCodeData().MainHeight, zoom, pageZoom);
        this.drawBars(context, this.getBarCodeData().BarsArray, (StiBrush)foreBrush, zoom, pageZoom);
        if (barCode.getShowLabelText() && this.getBarCodeData().TextString.length() > 0) {
            StringBuilder tempString = new StringBuilder();
            if (this.isTextSpacing()) {
                for (int index = 0; index < this.getBarCodeData().TextString.length(); ++index) {
                    tempString.append(this.getBarCodeData().TextString.charAt(index));
                    tempString.append(' ');
                }
                tempString.setLength(tempString.length() - 1);
            } else {
                tempString.append(this.getBarCodeData().TextString);
            }
            String outputString = tempString.toString();
            StiSize stringSizeF = this.baseMeasureString(context, outputString, barCodeFont);
            double barsWidth = this.GetSymbolsStringWidth(this.getBarCodeData().BarsArray);
            if (stringSizeF.getWidth() > barsWidth * this.getBarCodeData().LineWidth + this.getBarCodeData().SpaceLeft + this.getBarCodeData().SpaceRight) {
                outputString = this.getBarCodeData().TextString;
            }
            double binOffsetX = 0.0;
            double binOffsetY = this.getBarCodeData().TextPosition;
            if (this.getTextAlignment().equals((Object)StiTextHorAlignment.Center)) {
                this.baseDrawString(context, outputString, barCodeFont, (StiBrush)foreBrush, new StiRectangle(binOffsetX, binOffsetY, barsWidth * this.getBarCodeData().LineWidth + this.getBarCodeData().SpaceLeft + this.getBarCodeData().SpaceRight, this.getBarCodeData().TextHeight * 2.0), this.getTextAlignment(), StiVertAlignment.Top, zoom);
            } else {
                this.baseDrawString(context, this.getBarCodeData().TextString, barCodeFont, (StiBrush)foreBrush, new StiRectangle(this.getBarCodeData().SpaceLeft, binOffsetY, barsWidth * this.getBarCodeData().LineWidth, this.getBarCodeData().TextHeight * 2.0), this.getTextAlignment(), StiVertAlignment.Top, zoom);
            }
        }
        this.rollbackTransform(context);
    }

    protected final void CalculateSizeFull(double SpaceLeft, double SpaceRight, double SpaceTop, double SpaceBottom, double LineHeightShort, double LineHeightLong, double TextPosition, double TextHeight, double MainHeight, double LineHeightForCut, double WideToNarrowRatio, double Zoom, String Code, String TextString, String BarsArray, StiRectangle rect, StiBarCode barCode) {
        double fullZoomX;
        this.getBarCodeData().WideToNarrowRatio = WideToNarrowRatio;
        this.getBarCodeData().Code = Code;
        this.getBarCodeData().TextString = TextString;
        this.getBarCodeData().BarsArray = BarsArray;
        if (!(barCode.getShowQuietZones() || this instanceof StiAustraliaPost4StateBarCodeType || this instanceof StiITF14BarCodeType)) {
            SpaceLeft = 0.0;
            SpaceRight = 0.0;
            SpaceTop = 0.0;
            SpaceBottom = 0.0;
        }
        this.RectWindow = new StiRectangle(0.0, 0.0, rect.getWidth(), rect.getHeight());
        if (barCode.getAngle() == StiAngle.Angle90 || barCode.getAngle() == StiAngle.Angle270) {
            this.RectWindow = new StiRectangle(0.0, 0.0, rect.getHeight(), rect.getWidth());
        }
        double fontAddSize = barCode.getFont().size - 8.0 + 0.5;
        MainHeight += fontAddSize;
        TextHeight += fontAddSize;
        double fullZoomY = fullZoomX = this.getModule() / 10.0 * Zoom;
        double cutHeight = LineHeightForCut * (1.0 - this.getHeight());
        if (barCode.getAutoScale()) {
            fullZoomX = this.RectWindow.getWidth() / (this.GetSymbolsStringWidth(BarsArray) + SpaceLeft + SpaceRight);
            cutHeight = -(this.RectWindow.getHeight() / fullZoomY - MainHeight);
            if (!barCode.getShowLabelText() && TextPosition > LineHeightForCut) {
                cutHeight -= TextHeight;
            }
        }
        this.getBarCodeData().FullZoomY = fullZoomY;
        this.getBarCodeData().SpaceLeft = SpaceLeft * fullZoomX;
        this.getBarCodeData().SpaceRight = SpaceRight * fullZoomX;
        this.getBarCodeData().LineWidth = 1.0 * fullZoomX;
        this.getBarCodeData().MainWidth = (this.GetSymbolsStringWidth(BarsArray) + SpaceLeft + SpaceRight) * fullZoomX;
        this.getBarCodeData().SpaceTop = SpaceTop * fullZoomY;
        this.getBarCodeData().SpaceBottom = SpaceBottom * fullZoomY;
        this.getBarCodeData().LineHeightShort = (LineHeightShort - cutHeight) * fullZoomY;
        this.getBarCodeData().LineHeightLong = (LineHeightLong - cutHeight) * fullZoomY;
        if (TextPosition > SpaceTop) {
            TextPosition -= cutHeight;
        }
        this.getBarCodeData().TextPosition = TextPosition * fullZoomY;
        this.getBarCodeData().MainHeight = (MainHeight - cutHeight) * fullZoomY;
        this.getBarCodeData().TextHeight = TextHeight * fullZoomY;
    }

    protected final void CalculateSize2(double SpaceLeft, double SpaceRight, double SpaceTop, double SpaceBottom, double LineHeightShort, double LineHeightLong, double TextPosition, double TextHeight, double MainHeight, double WideToNarrowRatio, double Zoom, String BarsArray, StiRectangle rect, StiBarCode barCode) {
        this.CalculateSizeFull(SpaceLeft, SpaceRight, SpaceTop, SpaceBottom, LineHeightShort, LineHeightLong, TextPosition, TextHeight, MainHeight, LineHeightShort, WideToNarrowRatio, Zoom, "", "", BarsArray, rect, barCode);
    }

    protected final void draw2DBarCode(StiGraphics context, StiRectangle rect, StiBarCode barCode, double zoom) throws Exception {
        double fullZoomX;
        this.RectWindow = new StiRectangle(0.0, 0.0, rect.getWidth(), rect.getHeight());
        if (barCode.getAngle() == StiAngle.Angle90 || barCode.getAngle() == StiAngle.Angle270) {
            this.RectWindow = new StiRectangle(0.0, 0.0, rect.getHeight(), rect.getWidth());
        }
        Double pageZoom = barCode.getReport().getInfo().getPageZoom();
        int quietZone = 2;
        if (!barCode.getShowQuietZones()) {
            quietZone = 0;
        }
        double fullZoomY = fullZoomX = this.getModule() / 10.0 * zoom;
        if (barCode.getAutoScale()) {
            fullZoomX = this.RectWindow.getWidth() / (double)(this.barCodeData.MatrixWidth + quietZone * 2);
            fullZoomY = this.RectWindow.getHeight() / (double)(this.barCodeData.MatrixHeight * this.barCodeData.MatrixRatioY + quietZone * 2);
            fullZoomY = fullZoomX = Math.min(fullZoomX, fullZoomY);
        }
        this.getBarCodeData().MainWidth = (double)(this.barCodeData.MatrixWidth + quietZone * 2) * fullZoomX;
        this.getBarCodeData().MainHeight = (double)(this.barCodeData.MatrixHeight * this.barCodeData.MatrixRatioY + quietZone * 2) * fullZoomY;
        this.getBarCodeData().SpaceLeft = (double)quietZone * fullZoomX;
        this.getBarCodeData().SpaceTop = (double)quietZone * fullZoomY;
        this.translateRect(context, rect, barCode);
        StiSolidBrush foreBrush = new StiSolidBrush(barCode.getForeColor());
        StiSolidBrush backBrush = new StiSolidBrush(barCode.getBackColor());
        this.baseFillRectangle(context, (StiBrush)backBrush, 0.0, 0.0, this.getBarCodeData().MainWidth, this.getBarCodeData().MainHeight, zoom, pageZoom);
        double binOffsetX = this.getBarCodeData().SpaceLeft;
        double binOffsetY = this.getBarCodeData().SpaceTop;
        for (int indexY = 0; indexY < this.barCodeData.MatrixHeight; ++indexY) {
            for (int indexX = 0; indexX < this.barCodeData.MatrixWidth; ++indexX) {
                if (this.barCodeData.MatrixGrid[indexX + indexY * this.barCodeData.MatrixWidth] == 0) continue;
                this.baseFillRectangle2D(context, (StiBrush)foreBrush, binOffsetX + (double)indexX * fullZoomX, binOffsetY + (double)indexY * fullZoomY * (double)this.barCodeData.MatrixRatioY, fullZoomX, fullZoomY * (double)this.barCodeData.MatrixRatioY, zoom, pageZoom);
            }
        }
        this.rollbackTransform(context);
    }

    protected void drawMaxicode(StiGraphics context, StiRectangle rect, StiBarCode barCode, double zoom) throws Exception {
        this.RectWindow = new StiRectangle(0.0, 0.0, rect.width, rect.height);
        if (barCode.getAngle() == StiAngle.Angle90 || barCode.getAngle() == StiAngle.Angle270) {
            this.RectWindow = new StiRectangle(0.0, 0.0, rect.height, rect.width);
        }
        Double pageZoom = barCode.getReport().getInfo().getPageZoom();
        float size_L = 100.0f;
        float size_W = size_L / 29.0f;
        float size_V = size_W * 1.1547f;
        float size_Y = size_W * 0.866f;
        float offset_X = size_W * 1.5f;
        float offset_Y = size_Y + size_V / 2.0f;
        double scale = zoom;
        float fullZoomX = size_W * 32.0f;
        float fullZoomY = size_Y * 34.0f + size_V;
        if (barCode.getAutoScale()) {
            scale = (float)Math.min(this.RectWindow.height, this.RectWindow.width) / fullZoomX;
        }
        this.barCodeData.MainWidth = (double)fullZoomX * scale;
        this.barCodeData.MainHeight = (double)fullZoomY * scale;
        this.translateRect(context, rect, barCode);
        StiSolidBrush foreBrush = new StiSolidBrush(barCode.getForeColor());
        StiSolidBrush backBrush = new StiSolidBrush(barCode.getBackColor().a < 64 ? StiColorEnum.White.color() : barCode.getBackColor());
        this.baseFillRectangle(context, (StiBrush)backBrush, 0.0, 0.0, this.barCodeData.MainWidth, this.barCodeData.MainHeight, zoom, pageZoom);
        float[] Hex_Offset_X = new float[]{0.0f, size_W / 2.0f, size_W / 2.0f, 0.0f, -size_W / 2.0f, -size_W / 2.0f};
        float[] Hex_Offset_Y = new float[]{size_V / 2.0f, size_V / 4.0f, -size_V / 4.0f, -size_V / 2.0f, -size_V / 4.0f, size_V / 4.0f};
        float Hex_InkSpread = 0.87f;
        for (int row = 0; row < 33; ++row) {
            for (int col = 0; col < 30; ++col) {
                if (this.barCodeData.MatrixGrid[row * 30 + col] != 1) continue;
                float x = offset_X + (float)col * size_W;
                if ((row & 1) != 0) {
                    x += size_W / 2.0f;
                }
                float y = offset_Y + size_Y * (float)row;
                StiPoint[] points = new StiPoint[6];
                for (int i = 0; i < 6; ++i) {
                    points[i] = new StiPoint((double)(x + Hex_Offset_X[i] * Hex_InkSpread) * scale, (double)(y + Hex_Offset_Y[i] * Hex_InkSpread) * scale);
                }
                this.baseFillPolygon(context, (StiBrush)foreBrush, points, zoom, pageZoom);
            }
        }
        float centreX = offset_X + size_W * 14.0f;
        float centreY = offset_Y + size_Y * 16.0f;
        float[] radii = new float[]{15.236f, 12.598f, 9.96f, 7.32f, 4.646f, 2.008f};
        for (int i = 0; i < radii.length; ++i) {
            StiRectangle rectf = new StiRectangle((double)(centreX - radii[i]) * scale, (double)(centreY - radii[i]) * scale, (double)(radii[i] * 2.0f) * scale, (double)(radii[i] * 2.0f) * scale);
            this.baseFillEllipse(context, (StiBrush)((i & 1) > 0 ? backBrush : foreBrush), rectf.x, rectf.y, rectf.width, rectf.height, zoom, pageZoom);
        }
        this.rollbackTransform(context);
    }

    protected final void drawBarCodeError(StiGraphics context, StiRectangle rect, StiBarCode barCode) throws Exception {
        this.drawBarCodeError(context, rect, barCode, null);
    }

    protected final void drawBarCodeError(StiGraphics context, StiRectangle rect, StiBarCode barCode, String message) throws Exception {
        Double zoom = barCode.getReport().getInfo().getZoom();
        Double pageZoom = barCode.getReport().getInfo().getPageZoom();
        StiSolidBrush backBrush = new StiSolidBrush(barCode.getBackColor());
        this.baseFillRectangle(context, (StiBrush)backBrush, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), zoom, pageZoom);
        this.baseDrawRectangle(context, StiColorEnum.Red.color(), 4.0, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), zoom, pageZoom);
        StiFont foreFont = new StiFont("Arial", 8.0);
        if (message == null || message.length() == 0) {
            this.baseDrawString(context, "Not valid data", foreFont, (StiBrush)new StiSolidBrush(StiColorEnum.Red), rect.inflate(Double.valueOf(1.0), Double.valueOf(1.0)), StiTextHorAlignment.Left, StiVertAlignment.Top, zoom);
        } else {
            this.baseDrawString(context, message, foreFont, (StiBrush)new StiSolidBrush(StiColorEnum.Red), rect.inflate(Double.valueOf(1.0), Double.valueOf(1.0)), StiTextHorAlignment.Left, StiVertAlignment.Top, zoom);
        }
    }

    public abstract void draw(StiGraphics var1, StiBarCode var2, StiRectangle var3, double var4) throws Exception;

    protected final void translateRect(StiGraphics context, StiRectangle rect, StiBarCode barCode) throws IOException {
        double transformY;
        double transformX;
        double transformAngle;
        double transformdY;
        double transformdX;
        switch (barCode.getHorAlignment()) {
            case Right: {
                transformdX = this.RectWindow.getWidth() - this.getBarCodeData().MainWidth;
                break;
            }
            case Center: {
                transformdX = (this.RectWindow.getWidth() - this.getBarCodeData().MainWidth) / 2.0;
                break;
            }
            default: {
                transformdX = 0.0;
            }
        }
        switch (barCode.getVertAlignment()) {
            case Bottom: {
                transformdY = this.RectWindow.getHeight() - this.getBarCodeData().MainHeight;
                break;
            }
            case Center: {
                transformdY = (this.RectWindow.getHeight() - this.getBarCodeData().MainHeight) / 2.0;
                break;
            }
            default: {
                transformdY = 0.0;
            }
        }
        switch (barCode.getAngle()) {
            case Angle90: {
                transformAngle = -90.0;
                transformX = rect.getX();
                transformY = rect.getY() + rect.getHeight();
                break;
            }
            case Angle180: {
                transformAngle = -180.0;
                transformX = rect.getX() + rect.getWidth();
                transformY = rect.getY() + rect.getHeight();
                break;
            }
            case Angle270: {
                transformAngle = -270.0;
                transformX = rect.getX() + rect.getWidth();
                transformY = rect.getY();
                break;
            }
            default: {
                transformAngle = 0.0;
                transformX = rect.getX();
                transformY = rect.getY();
            }
        }
        this.baseTransform(context, transformX, transformY, transformAngle, transformdX, transformdY, rect);
    }

    protected final void rollbackTransform(StiGraphics context) {
        this.baseRollbackTransform(context);
    }

    protected void baseTransform(StiGraphics context, double x, double y, double angle, double dx, double dy, StiRectangle clip) throws IOException {
        if (this.exportPainter != null) {
            this.exportPainter.baseTransform(null, x, y, angle, dx, dy);
        } else {
            this.painter.baseTransform(context, x, y, angle, dx, dy, clip);
        }
    }

    protected void baseRollbackTransform(StiGraphics context) {
        if (this.exportPainter != null) {
            this.exportPainter.baseRollbackTransform(context);
        } else {
            this.painter.baseRollbackTransform(context);
        }
    }

    protected void baseFillRectangle(StiGraphics context, StiBrush brush, double x, double y, double width, double height, Double zoom, Double pageZoom) throws Exception {
        if (this.exportPainter != null) {
            this.exportPainter.baseFillRectangle(null, brush, x, y, width, height);
        } else {
            this.painter.baseFillRectangle(context, brush, x, y, width, height, zoom, pageZoom);
        }
    }

    protected void baseFillPolygon(StiGraphics context, StiBrush brush, StiPoint[] points, Double zoom, Double pageZoom) throws Exception {
        if (this.exportPainter != null) {
            this.exportPainter.baseFillPolygon(context, brush, points);
        } else {
            this.painter.baseFillPolygon(context, brush, points, zoom, pageZoom);
        }
    }

    protected void baseFillRectangle2D(StiGraphics context, StiBrush brush, double x, double y, double width, double height, Double zoom, Double pageZoom) throws Exception {
        if (this.exportPainter != null) {
            this.exportPainter.baseFillRectangle2D(null, brush, x, y, width, height);
        } else {
            this.painter.baseFillRectangle2D(context, brush, x, y, width, height, zoom, pageZoom);
        }
    }

    protected void baseFillEllipse(StiGraphics context, StiBrush brush, double x, double y, double width, double height, Double zoom, Double pageZoom) throws Exception {
        if (this.exportPainter != null) {
            this.exportPainter.baseFillEllipse(context, brush, x, y, width, height);
        } else {
            this.painter.baseFillEllipse(context, brush, x, y, width, height, zoom, pageZoom);
        }
    }

    protected void baseDrawRectangle(StiGraphics context, StiColor penColor, double penSize, double x, double y, double width, double height, Double zoom, Double pageZoom) throws Exception {
        if (this.exportPainter != null) {
            this.exportPainter.baseDrawRectangle(context, penColor, penSize, x, y, width, height);
        } else {
            this.painter.baseDrawRectangle(context, penColor, penSize, x, y, width, height, zoom, pageZoom);
        }
    }

    protected void baseDrawImage(StiGraphics context, String imageStr, BufferedImage image, StiReport report, double x, double y, double width, double height, double zoom) throws IOException {
        if (this.exportPainter != null) {
            StiImage stiImage = new StiImage(imageStr);
            stiImage.setPage(report.getPages().get(0));
            this.exportPainter.baseDrawImage(context, stiImage, report, x, y, width, height);
        } else {
            this.painter.baseDrawImage(context, image, new StiRectangle(x, y, width, height), zoom);
        }
    }

    protected void baseDrawString(StiGraphics context, String st, StiFont font, StiBrush brush, StiRectangle rect, StiTextHorAlignment horAlignment, StiVertAlignment vertAlignment, Double zoom) throws IOException {
        if (this.exportPainter != null) {
            this.exportPainter.baseDrawString(context, st, font, brush, rect, horAlignment, vertAlignment);
        } else {
            this.painter.baseDrawString(context, st, font, brush, rect, horAlignment, vertAlignment, zoom);
        }
    }

    protected StiSize baseMeasureString(StiGraphics context, String st, StiFont font) {
        return this.exportPainter != null ? this.exportPainter.baseMeasureString(context, st, font) : this.painter.baseMeasureString(context, st, font);
    }

    protected static int[] toInts(byte[] bytes) {
        int[] ints = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            ints[i] = bytes[i];
        }
        return ints;
    }

    public StiBarCodeExportPainter getExportPainter() {
        return this.exportPainter;
    }

    public void setExportPainter(StiBarCodeExportPainter exportPainter) {
        this.exportPainter = exportPainter;
    }

    public static StiBarCodeTypeService LoadFromJsonObjectInternal(JSONObject jObject) throws JSONException {
        String ident = (String)jObject.Properties().FirstOrDefault((String)"Ident").Value;
        List<Class<?>> classes = StiOptions.Services.getBarCodes();
        Class<?> clazz = null;
        for (Class<?> claz : classes) {
            String name = claz.getName();
            if (!name.substring(name.lastIndexOf(46) + 1).equals(ident)) continue;
            clazz = claz;
        }
        StiBarCodeTypeService barcode = null;
        if (clazz != null) {
            try {
                barcode = (StiBarCodeTypeService)((Object)clazz.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            barcode.LoadFromJsonObject(jObject);
        }
        return barcode;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", ((Object)((Object)this)).getClass().getName());
        return jObject;
    }

    public abstract void LoadFromJsonObject(JSONObject var1) throws JSONException;

    protected static class ValueObject {
        private String code = "";
        private String barsArray = "";
        private String errorString = "";
        private Boolean result = true;
        private int codeLength;
        private int[] output;
        private int outPos = 0;
        private int barPos = 0;
        private int widthOriginal;
        private int heightOriginal;

        public int getWidthOriginal() {
            return this.widthOriginal;
        }

        public void setWidthOriginal(int widthOriginal) {
            this.widthOriginal = widthOriginal;
        }

        public int getHeightOriginal() {
            return this.heightOriginal;
        }

        public void setHeightOriginal(int heightOriginal) {
            this.heightOriginal = heightOriginal;
        }

        public int getOutPos() {
            return this.outPos;
        }

        public void setOutPos(int outPos) {
            this.outPos = outPos;
        }

        public int getBarPos() {
            return this.barPos;
        }

        public void setBarPos(int barPos) {
            this.barPos = barPos;
        }

        public ValueObject() {
        }

        public ValueObject(int codeLength, int[] output) {
            this.codeLength = codeLength;
            this.output = output;
        }

        public ValueObject(int codeLength) {
            this.codeLength = codeLength;
        }

        public int getCodeLength() {
            return this.codeLength;
        }

        public void setCodeLength(int codeLength) {
            this.codeLength = codeLength;
        }

        public int[] getOutput() {
            return this.output;
        }

        public void setOutput(int[] output) {
            this.output = output;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getBarsArray() {
            return this.barsArray;
        }

        public void setBarsArray(String barsArray) {
            this.barsArray = barsArray;
        }

        public String getErrorString() {
            return this.errorString;
        }

        public void setErrorString(String errorString) {
            this.errorString = errorString;
        }

        public Boolean getResult() {
            return this.result;
        }

        public void setResult(Boolean result) {
            this.result = result;
        }
    }

    protected static class StiBarCodeData {
        public double SpaceLeft;
        public double SpaceRight;
        public double SpaceTop;
        public double SpaceBottom;
        public double LineHeightShort;
        public double LineHeightLong;
        public double LineWidth;
        public double TextPosition;
        public double TextHeight;
        public double MainHeight;
        public double MainWidth;
        public double WideToNarrowRatio;
        public String Code;
        public String TextString;
        public String BarsArray;
        public double FullZoomY;
        public double SpaceBeforeAdd;
        public double SpaceTextTop;
        public double TextPositionTop;
        public double TextPositionBottom;
        public ArrayList<StiEAN13BarCodeType.EanBarInfo> EanBarsArray;
        public double OffsetY;
        public int[] MatrixGrid;
        public int MatrixWidth;
        public int MatrixHeight;
        public int MatrixRatioY;

        protected StiBarCodeData() {
        }
    }

    public static class BarcodeCommandCode {
        public static char Fnc1 = (char)65457;
        public static char Fnc2 = (char)65458;
        public static char Fnc3 = (char)65459;
        public static char Fnc4 = (char)65460;
    }
}

