/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.report.barCodes.GaloisFieldPolynomial;

public class GaloisField {
    public static GaloisField Aztec_Data_12 = new GaloisField(4201, 4096, 1);
    public static GaloisField Aztec_Data_10 = new GaloisField(1033, 1024, 1);
    public static GaloisField Aztec_Data_8 = new GaloisField(301, 256, 1);
    public static GaloisField Aztec_Data_6 = new GaloisField(67, 64, 1);
    public static GaloisField Aztec_Param = new GaloisField(19, 16, 1);
    public static GaloisField QRCode_256 = new GaloisField(285, 256, 0);
    public static GaloisField Maxicode_64 = Aztec_Data_6;
    public static GaloisField DataMatrix_256 = Aztec_Data_8;
    private final int[] expTable;
    private final int[] logTable;
    private final GaloisFieldPolynomial zero;
    private final GaloisFieldPolynomial one;
    private final int size;
    private final int generatorBase;

    public GaloisField(int primitive, int size, int genBase) {
        int i;
        this.size = size;
        this.generatorBase = genBase;
        this.expTable = new int[size];
        this.logTable = new int[size];
        int x = 1;
        for (i = 0; i < size; ++i) {
            this.expTable[i] = x;
            if ((x <<= 1) < size) continue;
            x ^= primitive;
            x &= size - 1;
        }
        for (i = 0; i < size - 1; ++i) {
            this.logTable[this.expTable[i]] = i;
        }
        this.zero = new GaloisFieldPolynomial(this, new int[]{0});
        this.one = new GaloisFieldPolynomial(this, new int[]{1});
    }

    public GaloisFieldPolynomial GetZero() {
        return this.zero;
    }

    public GaloisFieldPolynomial GetOne() {
        return this.one;
    }

    public int GetGeneratorBase() {
        return this.generatorBase;
    }

    public GaloisFieldPolynomial BuildMonomial(int degree, int coefficient) {
        if (degree < 0) {
            throw new IllegalArgumentException();
        }
        if (coefficient == 0) {
            return this.zero;
        }
        int[] coefficients = new int[degree + 1];
        coefficients[0] = coefficient;
        return new GaloisFieldPolynomial(this, coefficients);
    }

    static int AddOrSubtract(int a, int b) {
        return a ^ b;
    }

    int Exp(int a) {
        return this.expTable[a];
    }

    int Inverse(int a) {
        if (a == 0) {
            throw new ArithmeticException();
        }
        return this.expTable[this.size - this.logTable[a] - 1];
    }

    int Multiply(int a, int b) {
        if (a == 0 || b == 0) {
            return 0;
        }
        return this.expTable[(this.logTable[a] + this.logTable[b]) % (this.size - 1)];
    }
}

